/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.channel.dao.jpa;

import java.util.Collection;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.apache.commons.lang.Validate;
import org.jasig.portal.channel.IChannelType;
import org.jasig.portal.channel.dao.IChannelTypeDao;
import org.jasig.portal.channel.dao.jpa.ChannelTypeImpl;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.transaction.annotation.Transactional;

public class JpaChannelTypeDao
implements IChannelTypeDao {
    private static final String FIND_ALL_CHAN_TYPE = "from ChannelTypeImpl channel";
    private static final String FIND_CHAN_TYPE_BY_NAME = "from ChannelTypeImpl type where type.name = :name";
    private static final String FIND_CHAN_TYPE_BY_NAME_CACHE_REGION = ChannelTypeImpl.class.getName() + ".query.FIND_CHAN_TYPE_BY_NAME";
    private static final String FIND_ALL_CHAN_TYPE_CACHE_REGION = ChannelTypeImpl.class.getName() + ".query.FIND_ALL_CHAN_TYPE";
    private EntityManager entityManager;

    @PersistenceContext
    public void setEntityManager(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    @Override
    @Transactional
    public void deleteChannelType(IChannelType type) {
        Validate.notNull((Object)type, (String)"definition can not be null");
        IChannelType persistentChanneltype = this.entityManager.contains((Object)type) ? type : (IChannelType)this.entityManager.merge((Object)type);
        this.entityManager.remove((Object)persistentChanneltype);
    }

    @Override
    @Transactional
    public IChannelType createChannelType(String name, String clazz, String cpdUri) {
        Validate.notEmpty((String)name, (String)"name can not be null");
        Validate.notEmpty((String)clazz, (String)"clazz can not be null");
        Validate.notEmpty((String)cpdUri, (String)"cpdUri can not be null");
        ChannelTypeImpl channelType = new ChannelTypeImpl(name, clazz, cpdUri);
        this.entityManager.persist((Object)channelType);
        return channelType;
    }

    @Override
    public IChannelType getChannelType(int id) {
        return (IChannelType)this.entityManager.find(ChannelTypeImpl.class, (Object)id);
    }

    @Override
    public IChannelType getChannelType(String name) {
        Query query = this.entityManager.createQuery(FIND_CHAN_TYPE_BY_NAME);
        query.setParameter("name", (Object)name);
        query.setHint("org.hibernate.cacheable", (Object)true);
        query.setHint("org.hibernate.cacheRegion", (Object)FIND_CHAN_TYPE_BY_NAME_CACHE_REGION);
        query.setMaxResults(1);
        List channelTypes = query.getResultList();
        IChannelType type = (IChannelType)DataAccessUtils.uniqueResult((Collection)channelTypes);
        return type;
    }

    @Override
    public List<IChannelType> getChannelTypes() {
        Query query = this.entityManager.createQuery(FIND_ALL_CHAN_TYPE);
        query.setHint("org.hibernate.cacheable", (Object)true);
        query.setHint("org.hibernate.cacheRegion", (Object)FIND_ALL_CHAN_TYPE_CACHE_REGION);
        List channelTypes = query.getResultList();
        return channelTypes;
    }

    @Override
    @Transactional
    public IChannelType updateChannelType(IChannelType type) {
        Validate.notNull((Object)type, (String)"type can not be null");
        this.entityManager.persist((Object)type);
        return type;
    }
}

