/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.channels;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.ChannelCacheKey;
import org.jasig.portal.ICacheable;
import org.jasig.portal.PortalException;
import org.jasig.portal.channels.BaseChannel;
import org.jasig.portal.channels.adminnav.AdminNavChannel;
import org.jasig.portal.i18n.LocaleManager;
import org.jasig.portal.layout.dlm.DistributedLayoutManager;
import org.jasig.portal.properties.PropertiesManager;
import org.jasig.portal.utils.DocumentFactory;
import org.jasig.portal.utils.ResourceLoader;
import org.jasig.portal.utils.XSLT;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.ContentHandler;

@Deprecated
public class CHeader
extends BaseChannel
implements ICacheable {
    private static final Log log = LogFactory.getLog(CHeader.class);
    private static final String sslLocation = "CHeader/CHeader.ssl";

    private boolean canUserAccessAdminNavigation() {
        boolean canPublish = false;
        try {
            canPublish = AdminNavChannel.canAccess(this.staticData.getAuthorizationPrincipal());
        }
        catch (Exception e) {
            log.error((Object)"Exception determining whether user can access administrative channels, defaulting to false.", (Throwable)e);
        }
        return canPublish;
    }

    public static String getDate(String format) {
        try {
            SimpleDateFormat formatter = new SimpleDateFormat(format);
            Date currentTime = new Date();
            return formatter.format(currentTime);
        }
        catch (Exception e) {
            log.error((Object)"Exception getting current date.", (Throwable)e);
            return "&nbsp;";
        }
    }

    private Document getUserXML() {
        String fullName = this.staticData.getPerson().getFullName();
        if (fullName == null) {
            fullName = "";
        }
        Document doc = DocumentFactory.getNewDocument();
        Element headerEl = doc.createElement("header");
        Element fullNameEl = doc.createElement("full-name");
        fullNameEl.appendChild(doc.createTextNode(fullName));
        headerEl.appendChild(fullNameEl);
        Element timeStampLongEl = doc.createElement("timestamp-long");
        timeStampLongEl.appendChild(doc.createTextNode(CHeader.getDate("EEEE, MMM d, yyyy 'at' hh:mm a")));
        headerEl.appendChild(timeStampLongEl);
        Element timeStampShortEl = doc.createElement("timestamp-short");
        timeStampShortEl.appendChild(doc.createTextNode(CHeader.getDate("M.d.y h:mm a")));
        headerEl.appendChild(timeStampShortEl);
        if (this.staticData.getPerson().getSecurityContext().isAuthenticated()) {
            Element preferencesChanidEl = doc.createElement("preferences-chanid");
            String layoutMgmFac = PropertiesManager.getProperty("org.jasig.portal.layout.UserLayoutManagerFactory.coreImplementation", "default");
            if (layoutMgmFac.equals(DistributedLayoutManager.class.getName())) {
                preferencesChanidEl.appendChild(doc.createTextNode("portal_userpreferences_dlm"));
            } else {
                preferencesChanidEl.appendChild(doc.createTextNode("portal_userpreferences_general"));
            }
            headerEl.appendChild(preferencesChanidEl);
        }
        doc.appendChild(headerEl);
        return doc;
    }

    @Override
    public ChannelCacheKey generateKey() {
        ChannelCacheKey k = new ChannelCacheKey();
        StringBuffer sbKey = new StringBuffer(1024);
        sbKey.append("org.jasig.portal.CHeader: ");
        if (this.staticData.getPerson().isGuest()) {
            k.setKeyScope(1);
            sbKey.append("userId:").append(this.staticData.getPerson().getID()).append(", ");
        } else {
            k.setKeyScope(0);
        }
        sbKey.append("locales:").append(LocaleManager.stringValueOf(this.runtimeData.getLocales()));
        sbKey.append("authenticated:").append(this.staticData.getPerson().getSecurityContext().isAuthenticated()).append(", ");
        sbKey.append("baseActionURL:").append(this.runtimeData.getBaseActionURL()).append(", ");
        sbKey.append("stylesheetURI:");
        try {
            String sslUri = ResourceLoader.getResourceAsURLString(this.getClass(), sslLocation);
            sbKey.append(XSLT.getStylesheetURI(sslUri, this.runtimeData.getBrowserInfo()));
        }
        catch (Exception e) {
            sbKey.append("not defined");
        }
        k.setKey(sbKey.toString());
        k.setKeyValidity(new Long(System.currentTimeMillis()));
        return k;
    }

    @Override
    public boolean isCacheValid(Object validity) {
        boolean cacheValid = false;
        if (validity instanceof Long) {
            Long oldtime = (Long)validity;
            if (!this.staticData.getPerson().getSecurityContext().isAuthenticated()) {
                cacheValid = true;
            } else if (System.currentTimeMillis() - oldtime < 60000L) {
                cacheValid = true;
            }
        }
        return cacheValid;
    }

    @Override
    public void renderXML(ContentHandler out) throws PortalException {
        XSLT xslt = XSLT.getTransformer(this, this.runtimeData.getLocales());
        xslt.setXML(this.getUserXML());
        xslt.setXSL(sslLocation, this.runtimeData.getBrowserInfo());
        xslt.setTarget(out);
        xslt.setStylesheetParameter("baseActionURL", this.runtimeData.getBaseActionURL());
        if (this.staticData.getPerson().getSecurityContext().isAuthenticated()) {
            xslt.setStylesheetParameter("authenticated", "true");
        }
        xslt.transform();
    }
}

