/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.channels;

import java.io.IOException;
import java.util.Properties;
import javax.servlet.http.HttpSession;
import org.jasig.portal.ChannelCacheKey;
import org.jasig.portal.ChannelRuntimeData;
import org.jasig.portal.ChannelRuntimeProperties;
import org.jasig.portal.ChannelStaticData;
import org.jasig.portal.ICacheable;
import org.jasig.portal.IPrivilegedChannel;
import org.jasig.portal.PortalControlStructures;
import org.jasig.portal.PortalEvent;
import org.jasig.portal.PortalException;
import org.jasig.portal.ResourceMissingException;
import org.jasig.portal.i18n.LocaleManager;
import org.jasig.portal.security.ISecurityContext;
import org.jasig.portal.utils.DocumentFactory;
import org.jasig.portal.utils.ResourceLoader;
import org.jasig.portal.utils.XSLT;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.ContentHandler;

@Deprecated
public class CLogin
implements IPrivilegedChannel,
ICacheable {
    private ChannelStaticData staticData;
    private ChannelRuntimeData runtimeData;
    private String attemptedUserName = "";
    private static final String sslLocation = "CLogin/CLogin.ssl";
    private boolean bAuthenticated = false;
    private boolean bauthenticationAttemptFailed = false;
    private boolean bSecurityError = false;
    private String xslUriForKey = null;
    private static final String SECURITY_PROPERTIES = "/properties/security.properties";
    private static final String CAS_LOGIN_URL_PROPERTY = "org.jasig.portal.channels.CLogin.CasLoginUrl";
    private String casLoginUrl = null;
    private static final String systemCacheId = "org.jasig.portal.CLogin:";
    private ISecurityContext ic;

    @Override
    public void setPortalControlStructures(PortalControlStructures pcs) {
        HttpSession session = pcs.getHttpSession();
        try {
            String authenticationAttempted = (String)session.getAttribute("up_authenticationAttempted");
            String authenticationError = (String)session.getAttribute("up_authenticationError");
            this.attemptedUserName = (String)session.getAttribute("up_attemptedUserName");
            if (authenticationAttempted != null) {
                this.bauthenticationAttemptFailed = true;
            }
            if (authenticationError != null) {
                this.bSecurityError = true;
            }
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Override
    public ChannelRuntimeProperties getRuntimeProperties() {
        return new ChannelRuntimeProperties();
    }

    @Override
    public void receiveEvent(PortalEvent ev) {
    }

    @Override
    public void setStaticData(ChannelStaticData sd) {
        this.staticData = sd;
        this.ic = this.staticData.getPerson().getSecurityContext();
        try {
            Properties props = ResourceLoader.getResourceAsProperties(CLogin.class, SECURITY_PROPERTIES);
            this.casLoginUrl = props.getProperty(CAS_LOGIN_URL_PROPERTY);
        }
        catch (ResourceMissingException e) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.ic != null && this.ic.isAuthenticated()) {
            this.bAuthenticated = true;
        }
    }

    @Override
    public void setRuntimeData(ChannelRuntimeData rd) {
        this.runtimeData = rd;
    }

    @Override
    public void renderXML(ContentHandler out) throws PortalException {
        String fullName = this.staticData.getPerson().getFullName();
        Document doc = DocumentFactory.getNewDocument();
        Element loginStatusElement = doc.createElement("login-status");
        if (this.bSecurityError) {
            Element errorElement = doc.createElement("error");
            loginStatusElement.appendChild(errorElement);
        } else if (this.bauthenticationAttemptFailed && !this.bAuthenticated) {
            Element failureElement = doc.createElement("failure");
            failureElement.setAttribute("attemptedUserName", this.attemptedUserName);
            loginStatusElement.appendChild(failureElement);
        } else if (fullName != null) {
            Element fullNameElement = doc.createElement("full-name");
            fullNameElement.appendChild(doc.createTextNode(fullName));
            loginStatusElement.appendChild(fullNameElement);
        }
        doc.appendChild(loginStatusElement);
        XSLT xslt = XSLT.getTransformer(this, this.runtimeData.getLocales());
        xslt.setXML(doc);
        xslt.setXSL(sslLocation, this.runtimeData.getBrowserInfo());
        xslt.setTarget(out);
        xslt.setStylesheetParameter("baseActionURL", this.runtimeData.getBaseActionURL());
        if (this.casLoginUrl != null) {
            xslt.setStylesheetParameter("casLoginUrl", this.casLoginUrl);
        }
        xslt.setStylesheetParameter("unauthenticated", String.valueOf(!this.staticData.getPerson().getSecurityContext().isAuthenticated()));
        xslt.transform();
    }

    @Override
    public ChannelCacheKey generateKey() {
        ChannelCacheKey k = new ChannelCacheKey();
        StringBuffer sbKey = new StringBuffer(1024);
        if (this.staticData.getPerson().isGuest()) {
            k.setKeyScope(1);
            sbKey.append(systemCacheId);
        } else {
            k.setKeyScope(0);
        }
        sbKey.append("userId:").append(this.staticData.getPerson().getID()).append(", ");
        sbKey.append("authenticated:").append(this.staticData.getPerson().getSecurityContext().isAuthenticated()).append(", ");
        if (this.xslUriForKey == null) {
            try {
                String sslUri = ResourceLoader.getResourceAsURLString(this.getClass(), sslLocation);
                this.xslUriForKey = XSLT.getStylesheetURI(sslUri, this.runtimeData.getBrowserInfo());
            }
            catch (PortalException pe) {
                this.xslUriForKey = "Not attainable!";
            }
        }
        sbKey.append("xslUri:").append(this.xslUriForKey).append(", ");
        sbKey.append("bAuthenticated:").append(this.bAuthenticated).append(", ");
        sbKey.append("bauthenticationAttemptFailed:").append(this.bauthenticationAttemptFailed).append(", ");
        sbKey.append("attemptedUserName:").append(this.attemptedUserName).append(", ");
        sbKey.append("bSecurityError:").append(this.bSecurityError).append(", ");
        sbKey.append("locales:").append(LocaleManager.stringValueOf(this.runtimeData.getLocales()));
        k.setKey(sbKey.toString());
        k.setKeyValidity(new Long(System.currentTimeMillis()));
        return k;
    }

    @Override
    public boolean isCacheValid(Object validity) {
        return true;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getName());
        sb.append(" authenticated:");
        sb.append(this.bAuthenticated);
        sb.append(" authenticationAttemptFailed:");
        sb.append(this.bauthenticationAttemptFailed);
        sb.append(" securityError:");
        sb.append(this.bSecurityError);
        sb.append(" attemptedUserName=[");
        sb.append(this.attemptedUserName);
        sb.append("]");
        return sb.toString();
    }
}

