/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.channels;

import java.io.StringWriter;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.ChannelRuntimeData;
import org.jasig.portal.ChannelRuntimeProperties;
import org.jasig.portal.ChannelStaticData;
import org.jasig.portal.IChannel;
import org.jasig.portal.PortalEvent;
import org.jasig.portal.PortalException;
import org.jasig.portal.utils.XSLT;
import org.xml.sax.ContentHandler;

@Deprecated
public class CNumberGuess
implements IChannel {
    private static final Log log = LogFactory.getLog(CNumberGuess.class);
    ChannelStaticData staticData = new ChannelStaticData();
    ChannelRuntimeData runtimeData = new ChannelRuntimeData();
    private static final String sslLocation = "CNumberGuess/CNumberGuess.ssl";
    private static final String bundleLocation = "/org/jasig/portal/channels/CNumberGuess/CNumberGuess";
    private int iMinNum = 0;
    private int iMaxNum = 0;
    private int iGuess = 0;
    private int iGuesses = 0;
    private int iAnswer = 0;
    private boolean bFirstTime = true;

    @Override
    public ChannelRuntimeProperties getRuntimeProperties() {
        return new ChannelRuntimeProperties();
    }

    @Override
    public void receiveEvent(PortalEvent ev) {
    }

    @Override
    public void setStaticData(ChannelStaticData sd) {
        block4: {
            this.staticData = sd;
            String sMinNum = null;
            String sMaxNum = null;
            try {
                sMinNum = sd.getParameter("minNum");
                if (sMinNum != null) {
                    this.iMinNum = Integer.parseInt(sMinNum);
                }
                if ((sMaxNum = sd.getParameter("maxNum")) != null) {
                    this.iMaxNum = Integer.parseInt(sMaxNum);
                }
                this.iAnswer = this.getRandomNumber(this.iMinNum, this.iMaxNum);
            }
            catch (NumberFormatException nfe) {
                this.iMinNum = 0;
                this.iMaxNum = 100;
                if (!log.isWarnEnabled()) break block4;
                log.warn((Object)("CNumberGuess::setStaticData() : either " + sMinNum + " or " + sMaxNum + " (minNum, maxNum) is not a valid integer. Defaults " + this.iMinNum + " and " + this.iMaxNum + " will be used instead."));
            }
        }
    }

    @Override
    public void setRuntimeData(ChannelRuntimeData rd) {
        this.runtimeData = rd;
        String sGuess = this.runtimeData.getParameter("guess");
        if (sGuess != null) {
            try {
                this.iGuess = Integer.parseInt(sGuess);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.bFirstTime = false;
            ++this.iGuesses;
        }
    }

    @Override
    public void renderXML(ContentHandler out) throws PortalException {
        String sSuggest = null;
        ResourceBundle l10n = ResourceBundle.getBundle(bundleLocation, this.runtimeData.getLocales()[0]);
        if (this.iGuess < this.iAnswer) {
            sSuggest = l10n.getString("HIGHER");
        } else if (this.iGuess > this.iAnswer) {
            sSuggest = l10n.getString("LOWER");
        }
        String GUESS_SUGGEST = MessageFormat.format(l10n.getString("GUESS_SUGGEST"), sSuggest);
        String THE_ANSWER_WAS_X = MessageFormat.format(l10n.getString("THE_ANSWER_WAS_X"), String.valueOf(this.iAnswer));
        String YOU_GOT_IT_AFTER_X_TRIES = MessageFormat.format(l10n.getString("YOU_GOT_IT_AFTER_X_TRIES"), String.valueOf(this.iGuesses));
        String YOU_HAVE_MADE_X_GUESSES = MessageFormat.format(l10n.getString("YOU_HAVE_MADE_X_GUESSES"), String.valueOf(this.iGuesses));
        String YOUR_GUESS_OF_GUESS_WAS_INCORRECT = MessageFormat.format(l10n.getString("YOUR_GUESS_OF_GUESS_WAS_INCORRECT"), String.valueOf(this.iGuess));
        String I_AM_THINKING_OF_A_NUMBER_BETWEEN_X_AND_Y = MessageFormat.format(l10n.getString("I_AM_THINKING_OF_A_NUMBER_BETWEEN_X_AND_Y"), String.valueOf(this.iMinNum), String.valueOf(this.iMaxNum));
        StringWriter w = new StringWriter();
        w.write("<?xml version='1.0'?>\n");
        w.write("<content>\n");
        w.write("  <minNum>" + this.iMinNum + "</minNum>\n");
        w.write("  <maxNum>" + this.iMaxNum + "</maxNum>\n");
        w.write("  <guesses>" + this.iGuesses + "</guesses>\n");
        w.write("  <guess>" + this.iGuess + "</guess>\n");
        if (!this.bFirstTime) {
            if (this.iGuess == this.iAnswer) {
                w.write("  <answer>" + this.iAnswer + "</answer>\n");
                this.bFirstTime = true;
                this.iGuesses = 0;
                this.iAnswer = this.getRandomNumber(this.iMinNum, this.iMaxNum);
            } else {
                w.write("  <suggest>" + sSuggest + "</suggest>\n");
            }
        }
        w.write("</content>\n");
        XSLT xslt = XSLT.getTransformer(this);
        xslt.setResourceBundle(l10n);
        xslt.setXML(w.toString());
        xslt.setXSL(sslLocation, "main", this.runtimeData.getBrowserInfo());
        xslt.setTarget(out);
        xslt.setStylesheetParameter("baseActionURL", this.runtimeData.getBaseActionURL());
        xslt.setStylesheetParameter("guessSuggest", GUESS_SUGGEST);
        xslt.setStylesheetParameter("theAnswerWasX", THE_ANSWER_WAS_X);
        xslt.setStylesheetParameter("youHaveMadeXGuesses", YOU_HAVE_MADE_X_GUESSES);
        xslt.setStylesheetParameter("youGotItAfterXTries", YOU_GOT_IT_AFTER_X_TRIES);
        xslt.setStylesheetParameter("YourGuessOfGuessWasIncorrect", YOUR_GUESS_OF_GUESS_WAS_INCORRECT);
        xslt.setStylesheetParameter("IAmThinkingOfANumberBetweenXAndY", I_AM_THINKING_OF_A_NUMBER_BETWEEN_X_AND_Y);
        xslt.transform();
    }

    private int getRandomNumber(int min, int max) {
        return new Double((double)(max - min) * Math.random() + (double)min).intValue();
    }
}

