/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.channels.DLMUserPreferences;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.ChannelRuntimeData;
import org.jasig.portal.ChannelRuntimeProperties;
import org.jasig.portal.ChannelStaticData;
import org.jasig.portal.IPrivilegedChannel;
import org.jasig.portal.IUserPreferencesManager;
import org.jasig.portal.PortalControlStructures;
import org.jasig.portal.PortalEvent;
import org.jasig.portal.PortalException;
import org.jasig.portal.StylesheetSet;
import org.jasig.portal.ThemeStylesheetDescription;
import org.jasig.portal.UserPreferences;
import org.jasig.portal.UserProfile;
import org.jasig.portal.channels.DLMUserPreferences.BaseState;
import org.jasig.portal.channels.DLMUserPreferences.GPreferencesState;
import org.jasig.portal.channels.DLMUserPreferences.ManageProfilesState;
import org.jasig.portal.layout.IUserLayoutManager;
import org.jasig.portal.layout.IUserLayoutStore;
import org.jasig.portal.layout.UserLayoutStoreFactory;
import org.jasig.portal.security.IPerson;
import org.w3c.dom.Document;
import org.xml.sax.ContentHandler;

@Deprecated
public class CUserPreferences
implements IPrivilegedChannel {
    private static final Log log = LogFactory.getLog(CUserPreferences.class);
    IUserPreferencesManager upm;
    ChannelRuntimeData runtimeData = new ChannelRuntimeData();
    ChannelStaticData staticData = null;
    StylesheetSet set = new StylesheetSet(this.getClass().getResource("/org/jasig/portal/channels/DLMUserPreferences/CUserPreferences.ssl").toString());
    private static final String sslLocation = "/org/jasig/portal/channels/DLMUserPreferences/CUserPreferences.ssl";
    private UserPreferences up = null;
    public static final int MANAGE_PREFERENCES = 1;
    public static final int MANAGE_PROFILES = 2;
    IPrivilegedChannel internalState = null;
    IPrivilegedChannel managePreferences = null;
    IPrivilegedChannel manageProfiles = null;
    protected IUserLayoutStore ulsdb;
    UserProfile editedProfile = null;

    public CUserPreferences() throws PortalException {
        this.set.setMediaProps("/properties/media.properties");
        this.manageProfiles = new ManageProfilesState(this);
        this.ulsdb = UserLayoutStoreFactory.getUserLayoutStoreImpl();
    }

    protected IUserPreferencesManager getUserPreferencesManager() {
        return this.upm;
    }

    protected IUserLayoutManager getUserLayoutManager() {
        return this.getUserPreferencesManager().getUserLayoutManager();
    }

    protected UserPreferences getCurrentUserPreferences() {
        return this.up;
    }

    protected ChannelRuntimeData getRuntimeData() {
        return this.runtimeData;
    }

    protected StylesheetSet getStylesheetSet() {
        return this.set;
    }

    @Override
    public void setPortalControlStructures(PortalControlStructures pcs) throws PortalException {
        if (this.upm == null) {
            this.upm = pcs.getUserPreferencesManager();
        }
        if (this.up == null) {
            this.up = this.upm.getUserPreferencesCopy();
        }
        if (this.internalState != null) {
            this.internalState.setPortalControlStructures(pcs);
        }
    }

    private void instantiateManagePreferencesState(UserProfile profile) {
        try {
            ThemeStylesheetDescription tsd = this.ulsdb.getThemeStylesheetDescription(profile.getThemeStylesheetId());
            if (tsd != null) {
                String cupmClass = tsd.getCustomUserPreferencesManagerClass();
                this.managePreferences = (IPrivilegedChannel)Class.forName(cupmClass).newInstance();
                ((BaseState)this.managePreferences).setContext(this);
            } else {
                log.error((Object)("Unable to retrieve theme stylesheet description. stylesheetId=" + profile.getThemeStylesheetId()));
                this.managePreferences = new GPreferencesState(this);
            }
        }
        catch (Exception e) {
            log.error((Object)("Error instantiating user profile [" + profile + "]"), (Throwable)e);
            this.managePreferences = new GPreferencesState(this);
        }
    }

    @Override
    public ChannelRuntimeProperties getRuntimeProperties() {
        return new ChannelRuntimeProperties();
    }

    @Override
    public void receiveEvent(PortalEvent ev) {
        if (this.internalState != null) {
            this.internalState.receiveEvent(ev);
        }
    }

    @Override
    public void setStaticData(ChannelStaticData sd) throws PortalException {
        this.staticData = sd;
        this.instantiateManagePreferencesState(this.up.getProfile());
        this.internalState = this.managePreferences;
        this.internalState.setStaticData(this.staticData);
        this.editedProfile = this.up.getProfile();
    }

    @Override
    public void setRuntimeData(ChannelRuntimeData rd) throws PortalException {
        this.runtimeData = rd;
        String action = this.runtimeData.getParameter("userPreferencesAction");
        if (action != null) {
            String profileType;
            Integer profileId = null;
            try {
                profileId = new Integer(this.runtimeData.getParameter("profileId"));
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
            boolean systemProfile = false;
            if (profileId != null && (profileType = this.runtimeData.getParameter("profileType")) != null && profileType.equals("system")) {
                systemProfile = true;
            }
            if (action.equals("manageProfiles")) {
                this.internalState = this.manageProfiles;
            } else if (action.equals("managePreferences")) {
                if (profileId != null) {
                    try {
                        UserProfile newProfile;
                        if (systemProfile) {
                            newProfile = this.ulsdb.getSystemProfileById(profileId);
                            if (!(newProfile == null || this.editedProfile.isSystemProfile() && this.editedProfile.getProfileId() == newProfile.getProfileId())) {
                                this.editedProfile = newProfile;
                                this.instantiateManagePreferencesState(this.editedProfile);
                            }
                        } else {
                            newProfile = this.ulsdb.getUserProfileById(this.upm.getPerson(), profileId);
                            if (newProfile != null && (this.editedProfile.isSystemProfile() || this.editedProfile.getProfileId() != newProfile.getProfileId())) {
                                this.editedProfile = newProfile;
                                this.instantiateManagePreferencesState(this.editedProfile);
                            }
                        }
                    }
                    catch (Exception e) {
                        throw new PortalException(e);
                    }
                }
                if (this.editedProfile == null) {
                    this.editedProfile = this.up.getProfile();
                }
                this.internalState = this.managePreferences;
            }
        }
        if (this.internalState != null) {
            this.internalState.setRuntimeData(rd);
        }
    }

    @Override
    public void renderXML(ContentHandler out) throws PortalException {
        this.internalState.renderXML(out);
    }

    protected UserPreferences getUserPreferencesFromStore(UserProfile profile) throws Exception {
        this.up = this.ulsdb.getUserPreferences(this.getUserPreferencesManager().getPerson(), profile);
        IUserLayoutStore uls = UserLayoutStoreFactory.getUserLayoutStoreImpl();
        IPerson person = this.getUserPreferencesManager().getPerson();
        UserProfile currProfile = this.getCurrentUserPreferences().getProfile();
        Document layout = uls.getUserLayout(person, currProfile);
        this.up.synchronizeWithUserLayoutXML(layout);
        return this.up;
    }

    protected UserProfile getEditedUserProfile() {
        return this.editedProfile;
    }
}

