/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.channels;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

@Deprecated
public class SaferHTMLHandler
implements ContentHandler {
    Node currentNode;
    StringBuffer chars = new StringBuffer();
    Document doc;
    private static final String[] SAFE_ELEMNTS = new String[]{"a", "abbr", "acronym", "address", "area", "b", "big", "blockquote", "br", "button", "caption", "center", "cite", "code", "col", "colgroup", "dd", "del", "dfn", "dir", "div", "dl", "dt", "em", "fieldset", "font", "form", "h1", "h2", "h3", "h4", "h5", "h6", "hr", "i", "img", "input", "ins", "kbd", "label", "legend", "li", "map", "menu", "ol", "optgroup", "option", "p", "pre", "q", "s", "samp", "select", "small", "span", "strike", "strong", "sub", "sup", "table", "tbody", "td", "textarea", "tfoot", "th", "thead", "tr", "tt", "u", "ul", "var"};
    private static final String[] SAFE_ATTS = new String[]{"abbr", "accept", "accept-charset", "accesskey", "action", "align", "alt", "axis", "border", "cellpadding", "cellspacing", "char", "charoff", "charset", "checked", "cite", "class", "clear", "cols", "colspan", "color", "compact", "coords", "datetime", "dir", "disabled", "enctype", "for", "frame", "headers", "height", "href", "hreflang", "hspace", "id", "ismap", "label", "lang", "longdesc", "maxlength", "media", "method", "multiple", "name", "nohref", "noshade", "nowrap", "prompt", "readonly", "rel", "rev", "rows", "rowspan", "rules", "scope", "selected", "shape", "size", "span", "src", "start", "summary", "tabindex", "target", "title", "type", "usemap", "valign", "value", "vspace", "width"};
    private static final String[] SAFE_URL_SCHEMES = new String[]{"http", "https", "ftp", "mailto"};
    private static final Set<String> SAFE_ELEMENTS_SET = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(SAFE_ELEMNTS)));
    private static final Set<String> SAFE_ATTS_SET = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(SAFE_ATTS)));
    private static final Set<String> SAFE_URL_SCHEMES_SET = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(SAFE_URL_SCHEMES)));

    public SaferHTMLHandler(Document doc, Node root) {
        this.doc = doc;
        this.currentNode = root;
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    @Override
    public void startDocument() throws SAXException {
    }

    @Override
    public void endDocument() throws SAXException {
        Text n = this.doc.createTextNode(this.chars.toString());
        this.chars = new StringBuffer();
        this.currentNode.appendChild(n);
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        if (SAFE_ELEMENTS_SET.contains(qName)) {
            if (this.chars.length() > 0) {
                Text n = this.doc.createTextNode(this.chars.toString());
                this.chars = new StringBuffer();
                this.currentNode.appendChild(n);
            }
            Element temp = this.doc.createElement(qName);
            int length = atts.getLength();
            for (int i = 0; i < length; ++i) {
                String attrName = atts.getQName(i);
                String value = atts.getValue(i);
                if (!SAFE_ATTS_SET.contains(attrName) || value == null) continue;
                if (attrName.toLowerCase().trim().equals("src") || attrName.toLowerCase().trim().equals("href")) {
                    value = SaferHTMLHandler.sanitizeURL(value);
                }
                temp.setAttribute(attrName, value);
            }
            this.currentNode.appendChild(temp);
            this.currentNode = temp;
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (SAFE_ELEMENTS_SET.contains(qName)) {
            if (this.chars.length() > 0) {
                Text n = this.doc.createTextNode(this.chars.toString());
                this.chars = new StringBuffer();
                this.currentNode.appendChild(n);
            }
            this.currentNode = this.currentNode.getParentNode();
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.chars.append(ch, start, length);
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
    }

    private static String parseScheme(String url) {
        String scheme = "";
        if (url != null) {
            int pos = (url = url.trim()).indexOf(58);
            if (pos >= 0) {
                scheme = url.substring(0, pos);
            }
            scheme = scheme.toLowerCase();
        }
        return scheme;
    }

    public static String sanitizeURL(String url) {
        String scheme = SaferHTMLHandler.parseScheme(url);
        if (SAFE_URL_SCHEMES_SET.contains(scheme)) {
            return url;
        }
        return "";
    }
}

