/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.channels.groupsmanager.wrappers;

import java.util.Iterator;
import org.jasig.portal.channels.groupsmanager.CGroupsManagerUnrestrictedSessionData;
import org.jasig.portal.channels.groupsmanager.GroupsManagerXML;
import org.jasig.portal.channels.groupsmanager.IGroupsManagerPermissions;
import org.jasig.portal.channels.groupsmanager.Utility;
import org.jasig.portal.channels.groupsmanager.wrappers.GroupMemberWrapper;
import org.jasig.portal.groups.IEntityGroup;
import org.jasig.portal.groups.IGroupMember;
import org.jasig.portal.properties.PropertiesManager;
import org.jasig.portal.security.IAuthorizationPrincipal;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

@Deprecated
public class GroupWrapper
extends GroupMemberWrapper {
    private boolean limitRetrievals;
    private int retrievalLimit;

    public GroupWrapper() {
        this.ELEMENT_TAGNAME = "group";
        this.limitRetrievals = PropertiesManager.getPropertyAsBoolean("org.jasig.portal.channels.groupsmanager.wrappers.GroupWrapper.limitRetrievals");
        this.retrievalLimit = PropertiesManager.getPropertyAsInt("org.jasig.portal.channels.groupsmanager.wrappers.GroupWrapper.retrievalLimit");
    }

    @Override
    public Element getXml(IGroupMember gm, Element anElem, CGroupsManagerUnrestrictedSessionData sessionData) {
        Document aDoc = sessionData.model;
        IEntityGroup entGrp = (IEntityGroup)gm;
        Element rootElem = anElem != null ? anElem : GroupsManagerXML.createElement(this.ELEMENT_TAGNAME, aDoc, false);
        Utility.logMessage("DEBUG", "GroupWrapper::getXml(): START, Element Expanded: " + rootElem.getAttribute("expanded"));
        try {
            String uid = rootElem.getAttribute("id");
            if (Utility.areEqual(uid, "")) {
                String nextID = GroupsManagerXML.getNextUid();
                rootElem.setAttribute("id", nextID);
            }
            rootElem.setAttribute("key", gm.getKey());
            rootElem.setAttribute("entityType", gm.getLeafType().getName());
            rootElem.setAttribute("type", gm.getType().getName());
            rootElem.setAttribute("editable", String.valueOf(entGrp.isEditable()));
            boolean hasMems = gm.hasMembers();
            if (!hasMems) {
                rootElem.setAttribute("expanded", "false");
            }
            boolean isGroupExpanded = Boolean.valueOf(rootElem.getAttribute("expanded"));
            if (!Utility.areEqual(rootElem.getAttribute("selected"), "true")) {
                rootElem.setAttribute("selected", "false");
            }
            rootElem.setAttribute("hasMembers", String.valueOf(hasMems));
            IGroupsManagerPermissions gmp = sessionData.gmPermissions;
            IAuthorizationPrincipal ap = sessionData.authPrincipal;
            this.applyPermissions(rootElem, gm, gmp, ap);
            NodeList nList = rootElem.getElementsByTagName("rdf:RDF");
            if (nList.getLength() == 0) {
                Element rdf = GroupsManagerXML.createRdfElement(entGrp, aDoc);
                rootElem.appendChild(rdf);
            } else {
                GroupsManagerXML.refreshAllNodesIfRequired(sessionData, rootElem);
            }
            if (isGroupExpanded) {
                this.expandElement(gm, rootElem, sessionData);
            }
            Utility.logMessage("DEBUG", "GroupWrapper::getXml(): FINISHED");
        }
        catch (Exception e) {
            Utility.logMessage("ERROR", "GroupWrapper::getXml(): ERROR retrieving entity " + e, e);
        }
        return rootElem;
    }

    @Override
    protected IGroupMember retrieveGroupMember(String aKey, String aType) {
        return GroupsManagerXML.retrieveGroup(aKey);
    }

    private Element expandElement(IGroupMember gm, Element anElem, CGroupsManagerUnrestrictedSessionData sessionData) {
        Utility.logMessage("DEBUG", "GroupWrapper::expandElement(): START");
        Utility.logMessage("DEBUG", "GroupWrapper::expandElement(): Group Member: " + gm);
        Utility.logMessage("DEBUG", "GroupWrapper::expandElement(): Element: " + anElem);
        if (!Utility.areEqual(anElem.getAttribute("expanded"), "true")) {
            return anElem;
        }
        Iterator gmItr = null;
        IGroupMember aChildGm = null;
        Element tempElem = null;
        try {
            Utility.logMessage("DEBUG", "GroupWrapper::expandElement():  HERE COME THE KIDS");
            gmItr = gm.getMembers();
            int gmCount = 0;
            while (gmItr.hasNext()) {
                aChildGm = (IGroupMember)gmItr.next();
                if (this.limitRetrievals && !aChildGm.isGroup() && gmCount >= this.retrievalLimit) continue;
                String childKey = aChildGm.getKey();
                Utility.logMessage("DEBUG", "GroupWrapper::expandElement():  " + aChildGm);
                boolean memberElementFound = false;
                String tagname = aChildGm.isGroup() ? "group" : "entity";
                memberElementFound = GroupsManagerXML.getNodesByTagNameAndKey(anElem, tagname, childKey).hasNext();
                if (!memberElementFound) {
                    tempElem = GroupsManagerXML.getGroupMemberXml(aChildGm, false, null, sessionData);
                    Utility.logMessage("DEBUG", "GroupWrapper::expandElement():  APPENDING " + tempElem.getNodeName());
                    anElem.appendChild(tempElem);
                    Utility.logMessage("DEBUG", "GroupWrapper::expandElement():  APPENDING ACCOMPLISHED");
                }
                ++gmCount;
            }
            NodeList nList = anElem.getChildNodes();
            for (int i = 0; i < nList.getLength(); ++i) {
                tempElem = (Element)nList.item(i);
                if (!Utility.notEmpty(tempElem.getAttribute("entityType"))) continue;
                Utility.logMessage("DEBUG", "GroupWrapper::expandElement():  Checking if child element (id = " + tempElem.getAttribute("id") + ") still a member");
                Utility.logMessage("DEBUG", "GroupWrapper::expandElement():  child element (key = " + tempElem.getAttribute("key") + ")");
                Utility.logMessage("DEBUG", "GroupWrapper::expandElement():  child element (entityType = " + tempElem.getAttribute("entityType") + ")");
                aChildGm = GroupsManagerXML.retrieveGroupMemberForElement(tempElem);
                if (aChildGm != null && gm.contains(aChildGm)) continue;
                Utility.logMessage("DEBUG", "GroupWrapper::expandElement():  About to remove child element");
                anElem.removeChild(tempElem);
            }
        }
        catch (Exception e) {
            Utility.logMessage("ERROR", "GroupWrapper::expandElement(): ERROR expanding \nElement: " + anElem + "\nFor group member: " + gm + "\n" + e, e);
        }
        return anElem;
    }
}

