/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.channels.jsp.tree;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.channels.jsp.tree.Config;
import org.jasig.portal.channels.jsp.tree.IDomainActionSet;
import org.jasig.portal.channels.jsp.tree.ISurrogate;
import org.jasig.portal.channels.jsp.tree.Node;

@Deprecated
public class Model {
    private static final Log LOG = LogFactory.getLog(Model.class);
    private static final int ACTION_LABEL_TYPE = 0;
    private static final int ASPECT_LABEL_TYPE = 1;
    private static final int NODE_LABEL_TYPE = 2;
    private Config cfg = null;
    private int unresolvableCount = 0;
    private ArrayList indentations = new ArrayList();
    private Node root = null;
    private boolean isRendering = false;
    private Node node = null;
    private String action = null;
    private int labelType = 0;

    public Node getNodeForId(String id) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("getNodeForId('" + id + "')"));
        }
        return Model.getNodeForId(id, this.root);
    }

    public static Node getNodeForId(String id, Node nodeToSearch) {
        if (id.equals(nodeToSearch.getId())) {
            return nodeToSearch;
        }
        if (!nodeToSearch.getHasChildren()) {
            return null;
        }
        Node[] children = nodeToSearch.getChildren();
        if (children == null) {
            return null;
        }
        Node childWithId = null;
        for (int i = 0; childWithId == null && i < children.length; ++i) {
            childWithId = Model.getNodeForId(id, children[i]);
        }
        return childWithId;
    }

    public void setExpandedForId(String id, boolean expanded) {
        Node n;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("setExpandedForId('" + id + "', " + expanded + ")"));
        }
        if ((n = this.getNodeForId(id)) == null || !n.getHasChildren()) {
            return;
        }
        n.setIsExpanded(expanded);
    }

    public void setRootDomainObject(Object root) {
        if (LOG.isDebugEnabled()) {
            if (root == null) {
                LOG.debug((Object)"setRootDomainObject(null)");
            } else {
                LOG.debug((Object)("setRootDomainObject(" + root.getClass().getName() + ")"));
            }
        }
        this.root = this.resolveChild(root);
        this.root.setIsExpanded(true);
    }

    public Model(Config cfg) {
        this.cfg = cfg;
    }

    public Config getConfig() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"getConfig()");
        }
        return this.cfg;
    }

    Node resolveChild(Object o) {
        return this.resolveObject(o, false);
    }

    Node resolveAspect(Object o) {
        return this.resolveObject(o, true);
    }

    private Node resolveObject(Object o, boolean isAspect) {
        Node node;
        String id;
        ISurrogate s = null;
        Iterator itr = this.cfg.getSurrogates().iterator();
        while (s == null && itr.hasNext()) {
            ISurrogate sgt = (ISurrogate)itr.next();
            if (!sgt.canResolve(o)) continue;
            s = sgt;
        }
        if (s == null) {
            if (this.cfg.getIncludeUnresolveables()) {
                id = "tun_" + this.unresolvableCount++;
                node = new Node(this, id, o);
                if (isAspect) {
                    node.setIsAspect(true);
                }
                return node;
            }
            return null;
        }
        id = s.getId(o);
        node = new Node(this, id, o, s);
        if (isAspect) {
            node.setIsAspect(true);
        } else if (!this.cfg.getLazilyLoad()) {
            node.loadChildren();
            node.loadAspects();
        }
        return node;
    }

    public List getIndentImages() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("getIndentImages() --> list.size()=" + this.indentations.size()));
        }
        return this.indentations;
    }

    public void setPushIndent(String indentType) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("setPushIndent('" + indentType + "')"));
        }
        this.indentations.add(indentType);
    }

    public String getPopIndent() {
        if (this.indentations.size() > 0) {
            String indent = (String)this.indentations.remove(this.indentations.size() - 1);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("getPopIndent() --> '" + indent + "'"));
            }
            return indent;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"getPopIndent() --> 'garbage' since empty");
        }
        return "garbage";
    }

    public Object getLabelData() {
        Node node = this.getNode();
        if (this.getLabelType() == this.getActionLabelType()) {
            IDomainActionSet set = this.cfg.getActionSet();
            if (set == null || node == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"getLabelData() --> null (for actionLabelType)");
                }
                return null;
            }
            Object obj = node.getDomainObject();
            String action = this.getDomainAction();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("getLabelData() --> IDomainActionSet.getLabelData('" + action + "', domainObject) for node id=" + node.getId()));
            }
            return set.getLabelData(action, obj);
        }
        if (node == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"getLabelData() --> null (for null node)");
            }
            return null;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("getLabelData() --> node.getLabelData() for node id=" + node.getId()));
        }
        return node.getLabelData();
    }

    public Map getTreeUrls() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"getTreeUrls()");
        }
        return this.cfg.getTreeUrlResolvers();
    }

    public synchronized boolean getStartRendering() {
        if (this.isRendering) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"getStartRendering() --> false");
            }
            return false;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"getStartRendering() --> true");
        }
        this.isRendering = true;
        return this.isRendering;
    }

    public synchronized void setIsRendering(boolean b) {
        this.isRendering = b;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("setIsRenderering(" + b + ")"));
        }
    }

    public Node getRoot() {
        if (LOG.isDebugEnabled()) {
            if (this.root == null) {
                LOG.debug((Object)"getRoot() --> null");
            } else {
                LOG.debug((Object)("getRoot() --> id=" + this.root.getId()));
            }
        }
        return this.root;
    }

    public Node getNode() {
        if (LOG.isDebugEnabled()) {
            if (this.node == null) {
                LOG.debug((Object)"getNode() --> null");
            } else {
                LOG.debug((Object)("getNode() --> id=" + this.node.getId()));
            }
        }
        return this.node;
    }

    public void setNode(Node node) {
        if (LOG.isDebugEnabled()) {
            if (node == null) {
                LOG.debug((Object)"setNode(null)");
            } else {
                LOG.debug((Object)("setNode(id=" + node.getId() + ")"));
            }
        }
        this.node = node;
    }

    public String getDomainAction() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("getDomainAction() --> '" + this.action + "'"));
        }
        return this.action;
    }

    public void setDomainAction(String action) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("setDomainAction('" + action + "')"));
        }
        this.action = action;
    }

    public int getLabelType() {
        if (LOG.isDebugEnabled()) {
            String type = "" + this.labelType + "?";
            if (this.labelType == 2) {
                type = "NODE";
            } else if (this.labelType == 1) {
                type = "ASPECT";
            } else if (this.labelType == 0) {
                type = "ACTION_LABEL_TYPE";
            }
            LOG.debug((Object)("getLabelType() --> " + type));
        }
        return this.labelType;
    }

    public int getActionLabelType() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"getActionLabelType()");
        }
        return 0;
    }

    public int getNodeLabelType() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"getNodeLabelType()");
        }
        return 2;
    }

    public int getAspectLabelType() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"getAspectLabelType()");
        }
        return 1;
    }

    public void setLabelType(int labelType) {
        if (LOG.isDebugEnabled()) {
            String type = "" + labelType + "?";
            if (labelType == 2) {
                type = "NODE";
            } else if (labelType == 1) {
                type = "ASPECT";
            } else if (labelType == 0) {
                type = "ACTION_LABEL_TYPE";
            }
            LOG.debug((Object)("setLabelType(" + type + ")"));
        }
        this.labelType = labelType;
    }
}

