/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.channels.portlet;

import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class PortletHttpServletResponseWrapper
extends HttpServletResponseWrapper {
    private final Writer wrappedWriter;
    private PrintWriter writer;
    private boolean committed;

    public PortletHttpServletResponseWrapper(HttpServletResponse res, Writer writer) {
        super(res);
        Validate.notNull((Object)writer, (String)"writer cannot be null");
        this.wrappedWriter = writer;
    }

    private void setCommitted(boolean committed) {
        this.committed = committed;
    }

    public ServletOutputStream getOutputStream() {
        throw new UnsupportedOperationException("As of Pluto 1.1.4 Portlet rendering should always only use getWriter() on the underlying HttpServletResponse");
    }

    public PrintWriter getWriter() throws UnsupportedEncodingException {
        if (this.writer == null) {
            this.writer = new PrintWriterWrapper(this.wrappedWriter);
        }
        return this.writer;
    }

    public void setBufferSize(int bufferSize) {
    }

    public int getBufferSize() {
        return 0;
    }

    public void flushBuffer() {
        this.committed = true;
        if (this.writer != null) {
            this.writer.flush();
        }
    }

    public void resetBuffer() {
        if (this.committed) {
            throw new IllegalStateException("Cannot reset buffer - response is already committed");
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PortletHttpServletResponseWrapper)) {
            return false;
        }
        PortletHttpServletResponseWrapper rhs = (PortletHttpServletResponseWrapper)((Object)obj);
        return new EqualsBuilder().append((Object)this.getResponse(), (Object)rhs.getResponse()).append(this.committed, rhs.committed).append((Object)this.wrappedWriter, (Object)rhs.wrappedWriter).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(0x3A3FAFFF, 179084321).append((Object)this.getResponse()).append(this.committed).append((Object)this.wrappedWriter).toHashCode();
    }

    private class PrintWriterWrapper
    extends PrintWriter {
        public PrintWriterWrapper(Writer w) {
            super(w);
        }

        @Override
        public void flush() {
            super.flush();
            PortletHttpServletResponseWrapper.this.setCommitted(true);
        }
    }
}

