/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.concurrency.caching;

import org.jasig.portal.EntityIdentifier;
import org.jasig.portal.IBasicEntity;
import org.jasig.portal.concurrency.CachingException;
import org.jasig.portal.concurrency.IEntityCache;
import org.jasig.portal.concurrency.IEntityCachingService;

public abstract class AbstractEntityCachingService
implements IEntityCachingService {
    protected abstract IEntityCache getCache(Class<? extends IBasicEntity> var1) throws CachingException;

    @Override
    public void add(IBasicEntity entity) throws CachingException {
        EntityIdentifier entityIdentifier = entity.getEntityIdentifier();
        Class<? extends IBasicEntity> entityType = entityIdentifier.getType();
        IEntityCache entityCache = this.getCache(entityType);
        entityCache.add(entity);
    }

    @Override
    public IBasicEntity get(Class<? extends IBasicEntity> entityType, String key) throws CachingException {
        IEntityCache entityCache = this.getCache(entityType);
        return entityCache.get(key);
    }

    @Override
    public void remove(Class<? extends IBasicEntity> entityType, String key) throws CachingException {
        IEntityCache entityCache = this.getCache(entityType);
        entityCache.remove(key);
    }

    @Override
    public void update(IBasicEntity entity) throws CachingException {
        this.add(entity);
    }
}

