/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.events;

import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.jasig.portal.events.EventType;
import org.jasig.portal.events.handlers.db.StatsSession;
import org.jasig.portal.security.IPerson;
import org.springframework.context.ApplicationEvent;

public abstract class PortalEvent
extends ApplicationEvent {
    private final IPerson person;
    private EventType eventType;
    private long id;
    private Date timeStampAsDate;
    private StatsSession statsSession;

    public PortalEvent(Object source, IPerson person) {
        super(source);
        this.person = person;
        this.eventType = EventType.getEventType(((Object)((Object)this)).getClass().getName(), null);
    }

    public PortalEvent(Object source, IPerson person, EventType eventType) {
        super(source);
        this.person = person;
        this.eventType = eventType;
    }

    public final IPerson getPerson() {
        return this.person;
    }

    public final Date getTimestampAsDate() {
        if (this.timeStampAsDate == null) {
            long timestamp = this.getTimestamp();
            this.timeStampAsDate = new Date(timestamp);
        }
        return this.timeStampAsDate;
    }

    public final String getDescription() {
        return this.toString();
    }

    public final void setDescription(String description) {
    }

    public final void setTimestampAsDate(Date timestamp) {
    }

    public EventType getEventType() {
        return this.eventType;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public StatsSession getStatsSession() {
        return this.statsSession;
    }

    public void setStatsSession(StatsSession statsSession) {
        this.statsSession = statsSession;
    }

    protected String getDisplayName() {
        if (this.person == null) {
            return "NULL_PERSON";
        }
        String userName = StringUtils.trimToEmpty((String)((String)this.person.getAttribute("username")));
        if (this.person.isGuest()) {
            return "GUEST_USER (" + userName + ")";
        }
        String firstName = StringUtils.trimToEmpty((String)((String)this.person.getAttribute("givenName")));
        String lastName = StringUtils.trimToEmpty((String)((String)this.person.getAttribute("sn")));
        return firstName + " " + lastName + " (" + userName + ")";
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getName() + " for " + this.getDisplayName() + " at " + this.getTimestampAsDate();
    }
}

