/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.events.handlers;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.events.BatchingEventHandler;
import org.jasig.portal.events.PortalEvent;
import org.jasig.portal.events.handlers.AbstractLimitedSupportEventHandler;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.util.Assert;

public class QueueingEventHandler
extends AbstractLimitedSupportEventHandler
implements DisposableBean {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final Queue<PortalEvent> eventQueue = new ConcurrentLinkedQueue<PortalEvent>();
    private final AtomicLong eventCount = new AtomicLong(0L);
    private final Lock flushLock = new ReentrantLock();
    private int batchSize = 25;
    private BatchingEventHandler batchingEventHandler;

    public BatchingEventHandler getBatchingEventHandler() {
        return this.batchingEventHandler;
    }

    @Required
    public void setBatchingEventHandler(BatchingEventHandler batchingEventHandler) {
        Assert.notNull((Object)batchingEventHandler, (String)"batchingEventHandler can not be null");
        this.batchingEventHandler = batchingEventHandler;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public void destroy() throws Exception {
        this.flush(true);
    }

    @Override
    public void handleEvent(PortalEvent event) {
        this.eventQueue.offer(event);
        this.eventCount.incrementAndGet();
    }

    public void flush() {
        this.flush(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush(boolean ignoreFailure) {
        boolean hasMoreEvents = true;
        while (hasMoreEvents) {
            if (!this.flushLock.tryLock()) {
                return;
            }
            try {
                int flushSize;
                int pendingEventCount = this.eventCount.intValue();
                if (pendingEventCount == 0) {
                    return;
                }
                if (pendingEventCount < this.batchSize) {
                    hasMoreEvents = false;
                    flushSize = pendingEventCount;
                } else {
                    hasMoreEvents = true;
                    flushSize = this.batchSize;
                }
                PortalEvent[] flushedEvents = new PortalEvent[flushSize];
                for (int index = 0; index < flushedEvents.length; ++index) {
                    PortalEvent event;
                    flushedEvents[index] = event = this.eventQueue.poll();
                }
                this.eventCount.addAndGet(-flushedEvents.length);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Flushing " + flushedEvents.length + " PortalEvents to " + this.batchingEventHandler));
                }
                try {
                    this.batchingEventHandler.handleEvents(flushedEvents);
                }
                catch (Throwable t) {
                    if (!ignoreFailure) {
                        this.logger.error((Object)("An exception was thrown while trying to flush " + flushedEvents.length + " PortalEvents to " + this.batchingEventHandler), t);
                        StringBuilder failedEvents = new StringBuilder();
                        failedEvents.append("The following is the list of events that was being flushed, some may have been persisted correctly");
                        for (PortalEvent portalEvent : flushedEvents) {
                            failedEvents.append("\n\t");
                            try {
                                failedEvents.append(portalEvent.toString());
                            }
                            catch (Exception e) {
                                failedEvents.append("toString failed on a PortalEvent of type '" + ((Object)((Object)portalEvent)).getClass() + "': " + e);
                            }
                        }
                        this.logger.error((Object)failedEvents, t);
                    }
                }
            }
            finally {
                this.flushLock.unlock();
            }
            if (!hasMoreEvents || !this.logger.isDebugEnabled()) continue;
            this.logger.debug((Object)"Has more events, looping until all pending events are flushed");
        }
    }
}

