/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.groups;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameParser;
import javax.naming.NamingException;
import org.jasig.portal.EntityIdentifier;
import org.jasig.portal.groups.GroupServiceConfiguration;
import org.jasig.portal.groups.GroupsException;
import org.jasig.portal.groups.IGroupConstants;
import org.jasig.portal.utils.cache.CacheFactory;
import org.jasig.portal.utils.cache.CacheFactoryLocator;

public class CompositeEntityIdentifier
extends EntityIdentifier
implements IGroupConstants {
    protected static String separator;
    protected Name compositeKey;
    protected String cachedCompositeKey;
    protected String cachedLocalKey;
    protected Name cachedServiceName;

    public CompositeEntityIdentifier(String entityKey, Class entityType) throws GroupsException {
        super(entityKey, entityType);
        try {
            this.compositeKey = this.parseCompoundKey(entityKey);
        }
        catch (NamingException ne) {
            throw new GroupsException("Error in group key", (Throwable)ne);
        }
    }

    protected Name getCompositeKey() {
        return this.compositeKey;
    }

    @Override
    public synchronized String getKey() {
        if (this.cachedCompositeKey == null) {
            this.cachedCompositeKey = this.getCompositeKey().toString();
        }
        return this.cachedCompositeKey;
    }

    public synchronized String getLocalKey() {
        if (this.cachedLocalKey == null) {
            this.cachedLocalKey = this.getCompositeKey().get(this.size() - 1);
        }
        return this.cachedLocalKey;
    }

    protected NameParser getParser() {
        return new NameParser(){

            @Override
            public Name parse(String s) throws InvalidNameException {
                int start = 0;
                int separatorLength = separator.length();
                int end = s.indexOf(separator, start);
                ArrayList<String> list = new ArrayList<String>(4);
                while (end != -1) {
                    list.add(s.substring(start, end));
                    start = end + separatorLength;
                    end = s.indexOf(separator, start);
                }
                list.add(s.substring(start));
                return new NameImpl(list);
            }
        };
    }

    public synchronized Name getServiceName() {
        if (this.size() < 2) {
            return null;
        }
        if (this.cachedServiceName == null) {
            this.cachedServiceName = this.getCompositeKey().getPrefix(this.size() - 1);
        }
        return this.cachedServiceName;
    }

    public Name newName() throws InvalidNameException {
        return new NameImpl();
    }

    public String popNode() throws InvalidNameException {
        return (String)this.getCompositeKey().remove(0);
    }

    public Name pushNode(String newNode) throws InvalidNameException {
        return this.getCompositeKey().add(0, newNode);
    }

    public synchronized void setCompositeKey(Name newCompositeKey) {
        this.compositeKey = newCompositeKey;
        this.cachedCompositeKey = null;
        this.cachedLocalKey = null;
        this.cachedServiceName = null;
    }

    public void setServiceName(Name newServiceName) throws InvalidNameException {
        Name newKey = this.newName().addAll(newServiceName).add(this.getLocalKey());
        this.setCompositeKey(newKey);
        this.cachedServiceName = newServiceName;
    }

    protected int size() {
        return this.getCompositeKey().size();
    }

    @Override
    public String toString() {
        return "CompositeEntityIdentifier (" + this.type + "(" + this.getKey() + "))";
    }

    public Name parseCompoundKey(String key) throws NamingException {
        CacheFactory cacheFactory = CacheFactoryLocator.getCacheFactory();
        Map<String, Name> nameCache = cacheFactory.getCache("org.jasig.portal.groups.CompositeEntityIdentifier.NAME_PARSE_CACHE");
        Name n = (Name)nameCache.get(key);
        if (n == null) {
            n = this.getParser().parse(key);
            nameCache.put(key, n);
        }
        return n;
    }

    static {
        try {
            separator = GroupServiceConfiguration.getConfiguration().getNodeSeparator();
        }
        catch (Exception ex) {
            separator = ".";
        }
    }

    private class NameImplEnumerator
    implements Enumeration<String> {
        List<String> list;
        int count;
        int limit;

        NameImplEnumerator(List<String> l, int start, int lim) {
            this.list = l;
            this.count = start;
            this.limit = lim;
        }

        @Override
        public boolean hasMoreElements() {
            return this.count < this.limit;
        }

        @Override
        public String nextElement() {
            if (this.count < this.limit) {
                return this.list.get(this.count++);
            }
            throw new NoSuchElementException("NameImplEnumerator");
        }
    }

    private class NameImpl
    implements Name {
        List<String> components;

        public NameImpl() {
            this(new ArrayList<String>(4));
        }

        public NameImpl(List<String> comps) {
            this.components = comps;
        }

        @Override
        public Name add(String comp) {
            this.components.add(comp);
            return this;
        }

        @Override
        public Name add(int posn, String comp) {
            this.components.add(posn, comp);
            return this;
        }

        @Override
        public Name addAll(int posn, Name n) {
            int i = posn;
            Enumeration<String> e = n.getAll();
            while (e.hasMoreElements()) {
                this.add(i, e.nextElement());
                ++i;
            }
            return this;
        }

        @Override
        public Name addAll(Name n) {
            Enumeration<String> e = n.getAll();
            while (e.hasMoreElements()) {
                this.add(e.nextElement());
            }
            return this;
        }

        @Override
        public Object clone() {
            List comps = (List)((ArrayList)this.components).clone();
            return new NameImpl(comps);
        }

        @Override
        public int compareTo(Object obj) {
            if (this == obj) {
                return 0;
            }
            if (!(obj instanceof Name)) {
                throw new ClassCastException("Not a Name");
            }
            Name name = (Name)obj;
            int len1 = this.size();
            int len2 = name.size();
            int n = Math.min(len1, len2);
            int index1 = 0;
            int index2 = 0;
            while (n-- != 0) {
                String comp1 = this.get(index1++);
                String comp2 = name.get(index2++);
                int local = (comp1 = comp1.trim()).compareTo(comp2 = comp2.trim());
                if (local == 0) continue;
                return local;
            }
            return len1 - len2;
        }

        @Override
        public boolean endsWith(Name n) {
            int startIndex = this.size() - n.size();
            if (startIndex < 0 || startIndex > this.size()) {
                return false;
            }
            Enumeration<String> suffix = n.getAll();
            try {
                Enumeration mycomps = this.getAll();
                while (mycomps.hasMoreElements()) {
                    String my = (String)mycomps.nextElement();
                    String his = suffix.nextElement();
                    if ((my = my.trim()).equals(his = his.trim())) continue;
                    return false;
                }
            }
            catch (NoSuchElementException e) {
                return false;
            }
            return true;
        }

        @Override
        public String get(int posn) {
            return this.components.get(posn);
        }

        public Enumeration getAll() {
            return new NameImplEnumerator(this.components, 0, this.components.size());
        }

        @Override
        public Name getPrefix(int posn) {
            if (posn < 0 || posn >= this.size()) {
                throw new ArrayIndexOutOfBoundsException(posn);
            }
            return this.getNameComponents(0, posn);
        }

        @Override
        public Name getSuffix(int posn) {
            if (posn < 0 || posn > this.size()) {
                throw new ArrayIndexOutOfBoundsException(posn);
            }
            return this.getNameComponents(posn, this.size());
        }

        @Override
        public boolean isEmpty() {
            return this.components.isEmpty();
        }

        @Override
        public Object remove(int posn) throws InvalidNameException {
            if (posn < 0 || posn >= this.size()) {
                throw new InvalidNameException("Invalid position.");
            }
            return this.components.remove(posn);
        }

        @Override
        public int size() {
            return this.components.size();
        }

        @Override
        public boolean startsWith(Name n) {
            Name myPrefix = this.getPrefix(n.size());
            return myPrefix.compareTo(n) == 0;
        }

        public String toString() {
            if (this.size() == 0) {
                return "";
            }
            if (this.size() == 1) {
                return this.get(0);
            }
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < this.size(); ++i) {
                if (i != 0) {
                    sb.append(separator);
                }
                sb.append(this.get(i));
            }
            return sb.toString();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof Name)) {
                return false;
            }
            Name target = (Name)obj;
            if (target.size() != this.size()) {
                return false;
            }
            return target.toString().equals(this.toString());
        }

        public int hashCode() {
            int hash = 0;
            Enumeration e = this.getAll();
            while (e.hasMoreElements()) {
                String comp = (String)e.nextElement();
                hash += comp.hashCode();
            }
            return hash;
        }

        private Enumeration<String> getComponents(int start, int limit) {
            return new NameImplEnumerator(this.components, start, limit);
        }

        private Name getNameComponents(int start, int limit) {
            ArrayList<String> comps = new ArrayList<String>(limit - start);
            Enumeration<String> e = this.getComponents(start, limit);
            while (e.hasMoreElements()) {
                comps.add(e.nextElement());
            }
            return new NameImpl(comps);
        }
    }
}

