/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.groups;

import org.jasig.portal.EntityIdentifier;
import org.jasig.portal.EntityTypes;
import org.jasig.portal.groups.GroupMemberImpl;
import org.jasig.portal.groups.GroupsException;
import org.jasig.portal.groups.IEntity;

public class EntityImpl
extends GroupMemberImpl
implements IEntity {
    protected EntityIdentifier entityIdentifier;

    public EntityImpl(String newEntityKey, Class newEntityType) throws GroupsException {
        this(new EntityIdentifier(newEntityKey, newEntityType));
    }

    public EntityImpl(EntityIdentifier ei) throws GroupsException {
        super(ei);
        Integer id = EntityTypes.getEntityTypeID(ei.getType());
        String key = id + "." + ei.getKey();
        this.entityIdentifier = new EntityIdentifier(key, EntityTypes.LEAF_ENTITY_TYPE);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof EntityImpl)) {
            return false;
        }
        return this.getEntityIdentifier().equals(((IEntity)obj).getEntityIdentifier());
    }

    @Override
    public EntityIdentifier getEntityIdentifier() {
        return this.entityIdentifier;
    }

    @Override
    public Class getEntityType() {
        return this.getUnderlyingEntityIdentifier().getType();
    }

    @Override
    public String getKey() {
        return this.getUnderlyingEntityIdentifier().getKey();
    }

    @Override
    public Class getLeafType() {
        return this.getEntityType();
    }

    @Override
    public Class getType() {
        return this.getEntityType();
    }

    @Override
    public boolean isEntity() {
        return true;
    }

    public String toString() {
        String clsName = this.getEntityType().getName();
        return "EntityImpl (" + clsName + ") " + this.getKey();
    }
}

