/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.groups;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.jasig.portal.EntityIdentifier;
import org.jasig.portal.EntityTypes;
import org.jasig.portal.groups.GroupsException;
import org.jasig.portal.groups.ICompositeGroupService;
import org.jasig.portal.groups.IEntityGroup;
import org.jasig.portal.groups.IGroupMember;
import org.jasig.portal.services.GroupService;

public abstract class GroupMemberImpl
implements IGroupMember {
    private EntityIdentifier underlyingEntityIdentifier;
    private static Class defaultEntityType;
    private Set groupKeys;
    private boolean groupKeysInitialized;

    public GroupMemberImpl(String key, Class type) throws GroupsException {
        this(new EntityIdentifier(key, type));
    }

    public GroupMemberImpl(EntityIdentifier newEntityIdentifier) throws GroupsException {
        if (!this.isKnownEntityType(newEntityIdentifier.getType())) {
            throw new GroupsException("Unknown entity type: " + newEntityIdentifier.getType());
        }
        this.underlyingEntityIdentifier = newEntityIdentifier;
    }

    public void addGroup(IEntityGroup eg) throws GroupsException {
        Set newGroupKeys = this.copyGroupKeys();
        newGroupKeys.add(eg.getEntityIdentifier().getKey());
        this.setGroupKeys(newGroupKeys);
    }

    private boolean areGroupKeysInitialized() {
        return this.groupKeysInitialized;
    }

    @Override
    public boolean contains(IGroupMember gm) throws GroupsException {
        return false;
    }

    private Set copyGroupKeys() throws GroupsException {
        return this.castAndCopyHashSet(this.getGroupKeys());
    }

    protected Set castAndCopyHashSet(Set s) {
        return (Set)((HashSet)s).clone();
    }

    @Override
    public boolean deepContains(IGroupMember gm) throws GroupsException {
        return false;
    }

    @Override
    public Iterator getAllContainingGroups() throws GroupsException {
        return this.primGetAllContainingGroups(this, new HashSet()).iterator();
    }

    @Override
    public Iterator getAllEntities() throws GroupsException {
        return this.getEmptyIterator();
    }

    @Override
    public Iterator getAllMembers() throws GroupsException {
        return this.getEmptyIterator();
    }

    protected String getCacheKey() {
        return this.getEntityIdentifier().getKey();
    }

    protected ICompositeGroupService getCompositeGroupService() throws GroupsException {
        return GroupService.getCompositeGroupService();
    }

    @Override
    public Iterator getContainingGroups() throws GroupsException {
        Set groupKeys = this.getGroupKeys();
        ArrayList<IEntityGroup> groupsColl = new ArrayList<IEntityGroup>(groupKeys.size());
        for (String groupKey : groupKeys) {
            groupsColl.add(this.getCompositeGroupService().findGroup(groupKey));
        }
        return groupsColl.iterator();
    }

    private Class getDefaultEntityType() {
        if (defaultEntityType == null) {
            Class<?> cls;
            defaultEntityType = cls = new Object().getClass();
        }
        return defaultEntityType;
    }

    private Iterator getEmptyIterator() {
        return Collections.EMPTY_LIST.iterator();
    }

    @Override
    public Iterator getEntities() throws GroupsException {
        return this.getEmptyIterator();
    }

    private synchronized Set getGroupKeys() throws GroupsException {
        if (!this.groupKeysInitialized) {
            this.initializeContainingGroupKeys();
        }
        return this.groupKeys;
    }

    @Override
    public String getKey() {
        return this.getUnderlyingEntityIdentifier().getKey();
    }

    @Override
    public IEntityGroup getMemberGroupNamed(String name) throws GroupsException {
        return null;
    }

    @Override
    public Iterator getMembers() throws GroupsException {
        return this.getEmptyIterator();
    }

    @Override
    public Class getType() {
        return this.getUnderlyingEntityIdentifier().getType();
    }

    @Override
    public EntityIdentifier getUnderlyingEntityIdentifier() {
        return this.underlyingEntityIdentifier;
    }

    @Override
    public int hashCode() {
        return this.getKey().hashCode();
    }

    @Override
    public boolean hasMembers() throws GroupsException {
        return false;
    }

    private void initializeContainingGroupKeys() throws GroupsException {
        HashSet<String> keys = new HashSet<String>(10);
        Iterator it = this.getCompositeGroupService().findContainingGroups(this);
        while (it.hasNext()) {
            IEntityGroup eg = (IEntityGroup)it.next();
            keys.add(eg.getEntityIdentifier().getKey());
        }
        this.setGroupKeys(keys);
        this.setGroupKeysInitialized(true);
    }

    @Override
    public boolean isDeepMemberOf(IGroupMember gm) throws GroupsException {
        if (this.isMemberOf(gm)) {
            return true;
        }
        return gm.deepContains(this);
    }

    @Override
    public boolean isEntity() {
        return false;
    }

    @Override
    public boolean isGroup() {
        return false;
    }

    protected boolean isKnownEntityType(Class anEntityType) throws GroupsException {
        return EntityTypes.getEntityTypeID(anEntityType) != null;
    }

    @Override
    public boolean isMemberOf(IGroupMember gm) throws GroupsException {
        if (gm == this || gm.isEntity()) {
            return false;
        }
        String cacheKey = gm.getKey();
        return this.getGroupKeys().contains(cacheKey);
    }

    protected Set primGetAllContainingGroups(IGroupMember member, Set s) throws GroupsException {
        Iterator i = member.getContainingGroups();
        while (i.hasNext()) {
            IGroupMember gm = (IGroupMember)i.next();
            s.add(gm);
            this.primGetAllContainingGroups(gm, s);
        }
        return s;
    }

    public void removeGroup(IEntityGroup eg) throws GroupsException {
        Set newGroupKeys = this.copyGroupKeys();
        newGroupKeys.remove(eg.getEntityIdentifier().getKey());
        this.setGroupKeys(newGroupKeys);
    }

    private synchronized void setGroupKeys(Set newGroupKeys) {
        this.groupKeys = newGroupKeys;
    }

    protected void setGroupKeysInitialized(boolean newGroupKeysInitialized) {
        this.groupKeysInitialized = newGroupKeysInitialized;
    }
}

