/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.groups.local.searchers;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.EntityIdentifier;
import org.jasig.portal.RDBMServices;
import org.jasig.portal.channel.IChannelDefinition;
import org.jasig.portal.groups.GroupsException;
import org.jasig.portal.groups.local.ITypedEntitySearcher;

public class RDBMChannelDefSearcher
implements ITypedEntitySearcher {
    private static final Log log = LogFactory.getLog(RDBMChannelDefSearcher.class);
    private static final String is_search = "select CHAN_ID from UP_CHANNEL where (UPPER(CHAN_NAME)=UPPER(?) or UPPER(CHAN_TITLE)=UPPER(?))";
    private static final String partial_search = "select CHAN_ID from UP_CHANNEL where (UPPER(CHAN_NAME) like UPPER(?) or UPPER(CHAN_TITLE) like UPPER(?))";
    private Class chanDef = IChannelDefinition.class;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EntityIdentifier[] searchForEntities(String query, int method) throws GroupsException {
        EntityIdentifier[] r = new EntityIdentifier[]{};
        ArrayList<EntityIdentifier> ar = new ArrayList<EntityIdentifier>();
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            conn = RDBMServices.getConnection();
            switch (method) {
                case 1: {
                    ps = conn.prepareStatement(is_search);
                    break;
                }
                case 2: {
                    query = query + "%";
                    ps = conn.prepareStatement(partial_search);
                    break;
                }
                case 3: {
                    query = "%" + query;
                    ps = conn.prepareStatement(partial_search);
                    break;
                }
                case 4: {
                    query = "%" + query + "%";
                    ps = conn.prepareStatement(partial_search);
                    break;
                }
                default: {
                    throw new GroupsException("Unknown search type");
                }
            }
            try {
                ps.clearParameters();
                ps.setString(1, query);
                ps.setString(2, query);
                ResultSet rs = ps.executeQuery();
                try {
                    while (rs.next()) {
                        ar.add(new EntityIdentifier(rs.getString(1), this.chanDef));
                    }
                }
                finally {
                    RDBMChannelDefSearcher.close(rs);
                }
            }
            finally {
                RDBMChannelDefSearcher.close(ps);
            }
        }
        catch (Exception e) {
            log.error((Object)("RDBMChannelDefSearcher.searchForEntities(): " + ps), (Throwable)e);
        }
        finally {
            RDBMServices.releaseConnection(conn);
        }
        return ar.toArray(r);
    }

    @Override
    public Class getType() {
        return this.chanDef;
    }

    private static final void close(Statement statement) {
        try {
            statement.close();
        }
        catch (SQLException e) {
            log.warn((Object)"problem closing statement", (Throwable)e);
        }
    }

    private static final void close(ResultSet resultset) {
        try {
            resultset.close();
        }
        catch (SQLException e) {
            log.warn((Object)"problem closing resultset", (Throwable)e);
        }
    }
}

