/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.groups.local.searchers;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.EntityIdentifier;
import org.jasig.portal.RDBMServices;
import org.jasig.portal.groups.GroupsException;
import org.jasig.portal.groups.local.ITypedEntitySearcher;
import org.jasig.portal.security.IPerson;

public class RDBMPersonSearcher
implements ITypedEntitySearcher {
    private static final Log log = LogFactory.getLog(RDBMPersonSearcher.class);
    private static final String user_is_search = "select USER_NAME from UP_USER where UPPER(USER_NAME)=UPPER(?)";
    private static final String user_partial_search = "select USER_NAME from UP_USER where UPPER(USER_NAME) like UPPER(?)";
    private static final String person_partial_search = "select USER_NAME from UP_PERSON_DIR where (UPPER(FIRST_NAME) like UPPER(?) or UPPER(LAST_NAME) like UPPER(?))";
    private static final String person_is_search = "select USER_NAME from UP_PERSON_DIR where (UPPER(FIRST_NAME) = UPPER(?) or UPPER(LAST_NAME) = UPPER(?))";
    private Class personDef = IPerson.class;

    @Override
    public EntityIdentifier[] searchForEntities(String query, int method) throws GroupsException {
        ResultSet uprs;
        ResultSet urs;
        PreparedStatement uis;
        PreparedStatement ups;
        PreparedStatement ps;
        Connection conn;
        ArrayList<EntityIdentifier> ar;
        EntityIdentifier[] r;
        block25: {
            r = new EntityIdentifier[]{};
            ar = new ArrayList<EntityIdentifier>();
            conn = null;
            ps = null;
            ups = null;
            uis = null;
            ResultSet rs = null;
            urs = null;
            uprs = null;
            try {
                conn = RDBMServices.getConnection();
                uis = conn.prepareStatement(user_is_search);
                switch (method) {
                    case 1: {
                        ps = conn.prepareStatement(person_is_search);
                        ups = uis;
                        break;
                    }
                    case 2: {
                        query = query + "%";
                        ps = conn.prepareStatement(person_partial_search);
                        ups = conn.prepareStatement(user_partial_search);
                        break;
                    }
                    case 3: {
                        query = "%" + query;
                        ps = conn.prepareStatement(person_partial_search);
                        ups = conn.prepareStatement(user_partial_search);
                        break;
                    }
                    case 4: {
                        query = "%" + query + "%";
                        ps = conn.prepareStatement(person_partial_search);
                        ups = conn.prepareStatement(user_partial_search);
                        break;
                    }
                    default: {
                        throw new GroupsException("Unknown search type");
                    }
                }
                ps.clearParameters();
                ps.setString(1, query);
                ps.setString(2, query);
                rs = ps.executeQuery();
                while (rs.next()) {
                    uis.clearParameters();
                    uis.setString(1, rs.getString(1));
                    urs = uis.executeQuery();
                    if (!urs.next()) continue;
                    ar.add(new EntityIdentifier(urs.getString(1), this.personDef));
                }
                ups.clearParameters();
                ups.setString(1, query);
                uprs = ups.executeQuery();
                while (uprs.next()) {
                    ar.add(new EntityIdentifier(uprs.getString(1), this.personDef));
                }
                if (rs == null) break block25;
            }
            catch (SQLException e) {
                try {
                    throw new GroupsException("RDBMChannelDefSearcher.searchForEntities(): " + ps, (Throwable)e);
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        RDBMServices.closeResultSet(rs);
                    }
                    if (urs != null) {
                        RDBMServices.closeResultSet(urs);
                    }
                    if (uprs != null) {
                        RDBMServices.closeResultSet(uprs);
                    }
                    if (ps != null) {
                        RDBMServices.closeStatement(ps);
                    }
                    if (uis != null) {
                        RDBMServices.closeStatement(uis);
                    }
                    if (ups != null) {
                        RDBMServices.closeStatement(ups);
                    }
                    if (conn != null) {
                        RDBMServices.releaseConnection(conn);
                    }
                    throw throwable;
                }
            }
            RDBMServices.closeResultSet(rs);
        }
        if (urs != null) {
            RDBMServices.closeResultSet(urs);
        }
        if (uprs != null) {
            RDBMServices.closeResultSet(uprs);
        }
        if (ps != null) {
            RDBMServices.closeStatement(ps);
        }
        if (uis != null) {
            RDBMServices.closeStatement(uis);
        }
        if (ups != null) {
            RDBMServices.closeStatement(ups);
        }
        if (conn != null) {
            RDBMServices.releaseConnection(conn);
        }
        return ar.toArray(r);
    }

    @Override
    public Class getType() {
        return this.personDef;
    }
}

