/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.io;

import java.io.IOException;
import java.io.Writer;
import org.apache.commons.lang.Validate;

public abstract class AbstractTokenReplacementFilter
extends Writer {
    private final StringBuilder prefixBuffer;
    private final StringBuilder tokenBuffer;
    private final StringBuilder suffixBuffer;
    private final char[] resetBuffer;
    private final Writer wrappedWriter;
    private final String prefix;
    private final int maxTokenLength;
    private final String suffix;

    public AbstractTokenReplacementFilter(Writer wrappedWriter, String prefix, int maxTokenLength, String suffix) {
        Validate.notNull((Object)wrappedWriter, (String)"wrappedWriter can not be null");
        Validate.notNull((Object)prefix, (String)"Replacement prefix can not be null");
        Validate.notNull((Object)suffix, (String)"Replacement suffix can not be null");
        if (prefix.length() <= 0) {
            throw new IllegalArgumentException("prefix must be at least one character");
        }
        if (maxTokenLength <= 0) {
            throw new IllegalArgumentException("maxTokenLength must be greater than zero (was " + maxTokenLength + ")");
        }
        if (suffix.length() <= 0) {
            throw new IllegalArgumentException("suffix must be at least one character");
        }
        this.wrappedWriter = wrappedWriter;
        this.prefix = prefix;
        this.maxTokenLength = maxTokenLength;
        this.suffix = suffix;
        this.prefixBuffer = new StringBuilder(this.prefix.length());
        this.tokenBuffer = new StringBuilder(this.maxTokenLength);
        this.suffixBuffer = new StringBuilder(this.suffix.length());
        this.resetBuffer = new char[this.prefix.length() + this.maxTokenLength + this.suffix.length()];
    }

    protected abstract String replaceToken(String var1);

    @Override
    public final void close() throws IOException {
        if (this.prefixBuffer.length() > 0) {
            this.wrappedWriter.append(this.prefixBuffer);
        }
        if (this.tokenBuffer.length() > 0) {
            this.wrappedWriter.append(this.tokenBuffer);
        }
        if (this.suffixBuffer.length() > 0) {
            this.wrappedWriter.append(this.suffixBuffer);
        }
        this.wrappedWriter.close();
    }

    @Override
    public final void flush() throws IOException {
        this.wrappedWriter.flush();
    }

    @Override
    public final void write(char[] cbuf, int off, int len) throws IOException {
        for (int charIndex = off; charIndex < off + len; ++charIndex) {
            this.write(cbuf[charIndex]);
        }
    }

    @Override
    public final void write(int c) throws IOException {
        char writerChar = (char)c;
        int prefixBufferLength = this.prefixBuffer.length();
        if (this.prefix.length() == prefixBufferLength) {
            int suffixBufferLength = this.suffixBuffer.length();
            if (this.tokenBuffer.length() == 0) {
                this.tokenBuffer.append(writerChar);
            } else if (this.suffix.charAt(suffixBufferLength) == writerChar) {
                this.suffixBuffer.append(writerChar);
                if (this.suffix.length() == this.suffixBuffer.length()) {
                    String token = this.tokenBuffer.toString();
                    String tokenReplacement = this.replaceToken(token);
                    this.wrappedWriter.write(tokenReplacement);
                    this.prefixBuffer.delete(0, this.prefixBuffer.length());
                    this.tokenBuffer.delete(0, this.tokenBuffer.length());
                    this.suffixBuffer.delete(0, this.suffixBuffer.length());
                }
            } else {
                int tokenBufferLength = this.tokenBuffer.length();
                if (this.maxTokenLength == tokenBufferLength) {
                    char deadChar = this.prefixBuffer.charAt(0);
                    this.wrappedWriter.write(deadChar);
                    this.prefixBuffer.getChars(1, prefixBufferLength, this.resetBuffer, 0);
                    this.prefixBuffer.delete(0, prefixBufferLength);
                    this.tokenBuffer.getChars(0, tokenBufferLength, this.resetBuffer, prefixBufferLength - 1);
                    this.tokenBuffer.delete(0, tokenBufferLength);
                    this.resetBuffer[tokenBufferLength + prefixBufferLength - 1] = writerChar;
                    this.write(this.resetBuffer, 0, tokenBufferLength + prefixBufferLength);
                } else if (suffixBufferLength > 0) {
                    char tokenChar = this.suffixBuffer.charAt(0);
                    this.tokenBuffer.append(tokenChar);
                    this.suffixBuffer.getChars(1, suffixBufferLength, this.resetBuffer, 0);
                    this.suffixBuffer.delete(0, suffixBufferLength);
                    this.resetBuffer[suffixBufferLength - 1] = writerChar;
                    this.write(this.resetBuffer, 0, suffixBufferLength);
                } else {
                    this.tokenBuffer.append(writerChar);
                }
            }
        } else if (this.prefix.charAt(prefixBufferLength) == writerChar) {
            this.prefixBuffer.append(writerChar);
        } else if (prefixBufferLength > 0) {
            char deadChar = this.prefixBuffer.charAt(0);
            this.wrappedWriter.write(deadChar);
            this.prefixBuffer.getChars(1, prefixBufferLength, this.resetBuffer, 0);
            this.prefixBuffer.delete(0, prefixBufferLength);
            this.resetBuffer[prefixBufferLength - 1] = writerChar;
            this.write(this.resetBuffer, 0, prefixBufferLength);
        } else {
            this.wrappedWriter.write(writerChar);
        }
    }
}

