/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.jndi;

import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.spi.InitialContextFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.DisposableBean;
import tyrex.naming.MemoryContext;

public class DisposableMemoryContextFactory
implements InitialContextFactory,
DisposableBean {
    private static final Log LOGGER = LogFactory.getLog(DisposableMemoryContextFactory.class);
    private static MemoryContext context;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Context getInitialContext(Hashtable<?, ?> environment) throws NamingException {
        Class<DisposableMemoryContextFactory> clazz = DisposableMemoryContextFactory.class;
        synchronized (DisposableMemoryContextFactory.class) {
            if (context == null) {
                context = new MemoryContext(environment);
                LOGGER.info((Object)("Created new MemoryContext with environment '" + environment + "'"));
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return context;
        }
    }

    public void destroy() throws Exception {
        DisposableMemoryContextFactory.closeContext();
    }

    public static synchronized void closeContext() {
        if (context != null) {
            LOGGER.info((Object)("Closing MemoryContext with environment '" + context.getEnvironment() + "'"));
            context.close();
            context = null;
        }
    }
}

