/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.lang;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.jasig.portal.lang.ChainedException;
import org.jasig.portal.lang.ChainedThrowable;
import org.jasig.portal.lang.Resources;
import org.jasig.portal.lang.StackTrace;
import org.jasig.portal.lang.ThrowableHelper;
import org.jasig.portal.lang.TypeConverter;

public class ChainedRuntimeException
extends RuntimeException
implements ChainedThrowable {
    private Throwable mCause = null;
    private StackTrace[] mStackTrace = null;

    public ChainedRuntimeException() {
        this.initCause();
    }

    public ChainedRuntimeException(String message) {
        super(message);
        this.initCause();
    }

    public ChainedRuntimeException(Throwable cause) {
        super(null == cause ? null : cause.getMessage());
        this.initCause();
        this.mCause = cause;
    }

    public ChainedRuntimeException(String message, Throwable cause) {
        super(message);
        this.initCause();
        this.mCause = cause;
    }

    @Override
    public Throwable getCause() {
        return this.mCause;
    }

    @Override
    public String getLocalizedMessage() {
        return ThrowableHelper.getLocalizedMessage(this.getMessage());
    }

    @Override
    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void printStackTrace(PrintStream stream) {
        PrintStream printStream = stream;
        synchronized (printStream) {
            stream.println(this);
            StackTrace[] trace = this.getOurStackTrace0();
            for (int i = 0; i < trace.length; ++i) {
                stream.println(Resources.getString(ChainedException.class, "at", new String[]{trace[i].toString()}));
            }
            Throwable ourCause = this.getCause();
            if (null != ourCause) {
                if (ourCause instanceof ChainedException) {
                    ((ChainedRuntimeException)ourCause).printStackTraceAsCause(stream, trace);
                } else {
                    stream.println(Resources.getString(ChainedException.class, "caused_by", new String[]{ourCause.toString()}));
                    ourCause.printStackTrace(stream);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void printStackTrace(PrintWriter stream) {
        PrintWriter printWriter = stream;
        synchronized (printWriter) {
            stream.println(this);
            StackTrace[] trace = this.getOurStackTrace0();
            for (int i = 0; i < trace.length; ++i) {
                stream.println(Resources.getString(ChainedException.class, "at", new String[]{trace[i].toString()}));
            }
            Throwable ourCause = this.getCause();
            if (null != ourCause) {
                if (ourCause instanceof ChainedException) {
                    ((ChainedRuntimeException)ourCause).printStackTraceAsCause(stream, trace);
                } else {
                    stream.println(Resources.getString(ChainedException.class, "caused_by", new String[]{ourCause.toString()}));
                    ourCause.printStackTrace(stream);
                }
            }
        }
    }

    private StackTrace[] getOurStackTrace0() {
        if (null == this.mStackTrace) {
            try {
                Method getStackTrace = this.getClass().getMethod("getStackTrace", null);
                this.mStackTrace = StackTrace.convertStackTrace((Object[])getStackTrace.invoke((Object)this, (Object[])null));
            }
            catch (InvocationTargetException x) {
                this.mStackTrace = this.getOurStackTraceInPre1_4();
            }
            catch (NoSuchMethodException x) {
                this.mStackTrace = this.getOurStackTraceInPre1_4();
            }
            catch (IllegalAccessException x) {
                this.mStackTrace = this.getOurStackTraceInPre1_4();
            }
        }
        return this.mStackTrace;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StackTrace[] getOurStackTraceInPre1_4() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = null;
        StackTrace[] elements = null;
        try {
            printWriter = new PrintWriter(stringWriter);
            super.printStackTrace(printWriter);
            elements = StackTrace.getStackTrace(this, stringWriter.toString());
        }
        finally {
            if (null != printWriter) {
                printWriter.close();
            }
        }
        return elements;
    }

    private void initCause() {
        try {
            Method initCause = this.getClass().getMethod("initCause", Throwable.class);
            initCause.invoke((Object)this, new Object[]{null});
        }
        catch (NoSuchMethodException x) {
        }
        catch (InvocationTargetException x) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }

    private void printStackTraceAsCause(PrintStream stream, StackTrace[] causedTrace) {
        Throwable ourCause;
        StackTrace[] trace = this.getOurStackTrace0();
        int m = trace.length - 1;
        for (int n = causedTrace.length - 1; 0 <= m && 0 <= n && trace[m].equals(causedTrace[n]); --m, --n) {
        }
        stream.println(Resources.getString(ChainedException.class, "caused_by", new String[]{this.toString()}));
        for (int i = 0; i <= m; ++i) {
            stream.println(Resources.getString(ChainedException.class, "at", new String[]{trace[i].toString()}));
        }
        int framesInCommon = trace.length - 1 - m;
        if (0 != framesInCommon) {
            stream.println(Resources.getString(ChainedException.class, "more", new String[]{TypeConverter.toString(framesInCommon)}));
        }
        if (null != (ourCause = this.getCause()) && ourCause instanceof ChainedException) {
            ((ChainedRuntimeException)ourCause).printStackTraceAsCause(stream, trace);
        }
    }

    private void printStackTraceAsCause(PrintWriter stream, StackTrace[] causedTrace) {
        Throwable ourCause;
        StackTrace[] trace = this.getOurStackTrace0();
        int m = trace.length - 1;
        for (int n = causedTrace.length - 1; 0 <= m && 0 <= n && trace[m].equals(causedTrace[n]); --m, --n) {
        }
        stream.println(Resources.getString(ChainedException.class, "caused_by", new String[]{this.toString()}));
        for (int i = 0; i <= m; ++i) {
            stream.println(Resources.getString(ChainedException.class, "at", new String[]{trace[i].toString()}));
        }
        int framesInCommon = trace.length - 1 - m;
        if (0 != framesInCommon) {
            stream.println(Resources.getString(ChainedException.class, "more", new String[]{TypeConverter.toString(framesInCommon)}));
        }
        if (null != (ourCause = this.getCause()) && ourCause instanceof ChainedThrowable) {
            ((ChainedRuntimeException)ourCause).printStackTraceAsCause(stream, trace);
        }
    }
}

