/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.lang;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.lang.Resources;
import org.jasig.portal.lang.ThrowableHandler;

public final class ThrowableHelper {
    private static final Log LOG = LogFactory.getLog(ThrowableHelper.class);
    private static final String I18N_TOKEN = Resources.getString(ThrowableHelper.class, "i18n_token");
    private static final ThrowableHandler DEFAULT_HANDLER = ThrowableHelper.getDefaultHandler(Resources.getString(ThrowableHelper.class, "default_throwable_handler_class"));

    public static final ThrowableHandler getDefaultHandler(String className) {
        ThrowableHandler handler = new ThrowableHandler(){

            @Override
            public void handle(Class client, String property, String[] objects, Throwable cause) {
                if (null != property) {
                    String errorMessage = Resources.getString(client, property, objects);
                    LOG.warn((Object)errorMessage);
                }
                if (null != cause) {
                    LOG.warn((Object)cause, cause);
                }
            }
        };
        try {
            if (null != className && !"".equals(className)) {
                handler = (ThrowableHandler)Class.forName(className).newInstance();
            }
        }
        catch (ClassNotFoundException x) {
            ThrowableHelper.handle(ThrowableHelper.class, "error.class_not_found", new String[]{className}, x, handler);
        }
        catch (IllegalAccessException x) {
            ThrowableHelper.handle(ThrowableHelper.class, "error.illegal_access", new String[]{className}, x, handler);
        }
        catch (InstantiationException x) {
            ThrowableHelper.handle(ThrowableHelper.class, "error.instantiation", new String[]{className}, x, handler);
        }
        catch (ExceptionInInitializerError x) {
            ThrowableHelper.handle(ThrowableHelper.class, "error.initialization", new String[]{className}, x, handler);
        }
        return handler;
    }

    public static final String getInternationalizedMessage(Class client, String error) {
        return ThrowableHelper.getInternationalizedMessage(client, error, null);
    }

    public static final String getInternationalizedMessage(Class client, String error, String[] objects) {
        if (null == client) {
            throw new NullPointerException(ThrowableHelper.getInternationalizedMessage(ThrowableHelper.class, "getInternationalizedMessage.client_argument_is_null"));
        }
        if (null == error) {
            throw new NullPointerException(ThrowableHelper.getInternationalizedMessage(ThrowableHelper.class, "getInternationalizedMessage.error_argument_is_null"));
        }
        StringBuffer buffer = new StringBuffer().append(I18N_TOKEN).append(client.getName()).append(I18N_TOKEN).append(error);
        if (null != objects) {
            for (int i = 0; i < objects.length; ++i) {
                buffer.append(I18N_TOKEN).append(objects[i]);
            }
        }
        return buffer.toString();
    }

    public static final String getLocalizedMessage(String i18nMessage) {
        return ThrowableHelper.getLocalizedMessage(i18nMessage, Locale.getDefault());
    }

    public static final String getLocalizedMessage(Throwable throwable) {
        return ThrowableHelper.getLocalizedMessage(throwable, Locale.getDefault());
    }

    public static final String getLocalizedMessage(Throwable throwable, Locale locale) {
        return ThrowableHelper.getLocalizedMessage(throwable.getMessage(), locale);
    }

    public static final String getLocalizedMessage(String i18nMessage, Locale locale) {
        String l10nMessage = null;
        if (null != i18nMessage) {
            try {
                StringTokenizer tokenizer = new StringTokenizer("junk" + i18nMessage, I18N_TOKEN);
                tokenizer.nextToken();
                String className = tokenizer.nextToken();
                String errorName = tokenizer.nextToken();
                ArrayList<String> strings = new ArrayList<String>();
                while (tokenizer.hasMoreTokens()) {
                    strings.add(tokenizer.nextToken());
                }
                String[] objects = new String[strings.size()];
                for (int i = 0; i < objects.length; ++i) {
                    objects[i] = (String)strings.get(i);
                }
                ResourceBundle bundle = ResourceBundle.getBundle(className, locale);
                String message = bundle.getString(errorName);
                l10nMessage = MessageFormat.format(message, objects);
            }
            catch (NoSuchElementException x) {
                l10nMessage = i18nMessage;
            }
        }
        return l10nMessage;
    }

    public static final void initCause(Throwable throwable, Throwable cause) {
        try {
            Method initCause = throwable.getClass().getMethod("initCause", Throwable.class);
            initCause.invoke((Object)throwable, cause);
        }
        catch (NoSuchMethodException x) {
            ThrowableHelper.handle(x);
        }
        catch (InvocationTargetException x) {
            ThrowableHelper.handle(x);
        }
        catch (IllegalAccessException x) {
            ThrowableHelper.handle(x);
        }
        catch (IllegalStateException x) {
            ThrowableHelper.handle(x);
        }
    }

    public static final Throwable create(Class throwableClass, Class client, String propertyName, String[] args, Throwable cause) {
        Throwable throwable = null;
        String i18nMessage = ThrowableHelper.getInternationalizedMessage(client, propertyName, args);
        throwable = ThrowableHelper.createThrowable(throwableClass, new Class[]{String.class}, new Object[]{i18nMessage});
        if (null != cause) {
            ThrowableHelper.initCause(throwable, cause);
        }
        return throwable.fillInStackTrace();
    }

    private static final Throwable createThrowable(Class throwableClass, Class[] clsArguments, Object[] objArguments) {
        Throwable throwable = null;
        try {
            Constructor ctor = throwableClass.getConstructor(clsArguments);
            throwable = (Throwable)ctor.newInstance(objArguments);
        }
        catch (NoSuchMethodException x) {
            ThrowableHelper.handle(x);
        }
        catch (IllegalAccessException x) {
            ThrowableHelper.handle(x);
        }
        catch (InstantiationException x) {
            ThrowableHelper.handle(x);
        }
        catch (InvocationTargetException x) {
            ThrowableHelper.handle(x);
        }
        return throwable;
    }

    public static final void handle(Throwable cause) {
        ThrowableHelper.handle(null, null, null, cause, DEFAULT_HANDLER);
    }

    public static final void handle(Class client, String message, String[] objects, Throwable cause) {
        ThrowableHelper.handle(client, message, objects, cause, DEFAULT_HANDLER);
    }

    public static final void handle(Class client, String message, String[] objects, Throwable cause, ThrowableHandler handler) {
        ThrowableHandler errorHandler = handler;
        if (null == errorHandler) {
            errorHandler = DEFAULT_HANDLER;
        }
        errorHandler.handle(client, message, objects, cause);
    }

    private ThrowableHelper() {
    }
}

