/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.layout;

import java.lang.reflect.Constructor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.PortalException;
import org.jasig.portal.UserProfile;
import org.jasig.portal.layout.IUserLayoutManager;
import org.jasig.portal.layout.IUserLayoutStore;
import org.jasig.portal.layout.TransientUserLayoutManagerWrapper;
import org.jasig.portal.layout.UserLayoutStoreFactory;
import org.jasig.portal.layout.immutable.ImmutableUserLayoutManagerWrapper;
import org.jasig.portal.layout.simple.SimpleUserLayoutManager;
import org.jasig.portal.properties.PropertiesManager;
import org.jasig.portal.security.IPerson;
import org.jasig.portal.services.stats.StatsRecorderLayoutEventListener;

public class UserLayoutManagerFactory {
    private static final Log LOG = LogFactory.getLog(UserLayoutManagerFactory.class);
    private static Class coreUserLayoutManagerImpl = SimpleUserLayoutManager.class;

    public static IUserLayoutManager getUserLayoutManager(IPerson person, UserProfile profile) throws PortalException {
        try {
            Class[] cArgsClasses = new Class[]{IPerson.class, UserProfile.class, IUserLayoutStore.class};
            Constructor c = coreUserLayoutManagerImpl.getConstructor(cArgsClasses);
            Object[] cArgs = new Object[]{person, profile, UserLayoutStoreFactory.getUserLayoutStoreImpl()};
            IUserLayoutManager ulm = (IUserLayoutManager)c.newInstance(cArgs);
            ulm.addLayoutEventListener(new StatsRecorderLayoutEventListener(person, profile));
            TransientUserLayoutManagerWrapper ulmWrapper = new TransientUserLayoutManagerWrapper(ulm);
            return ulmWrapper;
        }
        catch (Exception e) {
            throw new PortalException("Unable to instantiate a \"" + coreUserLayoutManagerImpl.getName() + "\"", (Throwable)e);
        }
    }

    public static IUserLayoutManager immutableUserLayoutManager(IUserLayoutManager man) throws PortalException {
        return new ImmutableUserLayoutManagerWrapper(man);
    }

    static {
        String className = PropertiesManager.getProperty("org.jasig.portal.layout.UserLayoutManagerFactory.coreImplementation", null);
        if (className == null) {
            LOG.error((Object)"UserLayoutManagerFactory: org.jasig.portal.layout.UserLayoutManagerFactory.coreImplementation must be specified in portal.properties");
        }
        try {
            Class<?> newClass;
            coreUserLayoutManagerImpl = newClass = Class.forName(className);
            LOG.info((Object)("UserLayoutManagerFactory: Layout Manager Factory successfully loaded: " + className));
        }
        catch (Exception e) {
            LOG.error((Object)("UserLayoutManagerFactory: Could not instantiate " + className), (Throwable)e);
        }
    }
}

