/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.layout.dlm;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.PortalException;
import org.jasig.portal.layout.IUserLayoutStore;
import org.jasig.portal.layout.UserLayoutStoreFactory;
import org.jasig.portal.layout.dlm.IntegrationResult;
import org.jasig.portal.layout.dlm.RDBMDistributedLayoutStore;
import org.jasig.portal.security.IPerson;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DeleteManager {
    public static final String RCS_ID = "@(#) $Header$";
    private static final Log LOG = LogFactory.getLog(DeleteManager.class);
    private static RDBMDistributedLayoutStore dls = null;

    private static RDBMDistributedLayoutStore getDLS() {
        if (dls == null) {
            IUserLayoutStore uls = null;
            uls = UserLayoutStoreFactory.getUserLayoutStoreImpl();
            dls = (RDBMDistributedLayoutStore)uls;
        }
        return dls;
    }

    static void applyAndUpdateDeleteSet(Document plf, Document ilf, IntegrationResult result) {
        Element dSet = null;
        try {
            dSet = DeleteManager.getDeleteSet(plf, null, false);
        }
        catch (Exception e) {
            LOG.error((Object)"Exception occurred while getting user's DLM delete-set.", (Throwable)e);
        }
        if (dSet == null) {
            return;
        }
        NodeList deletes = dSet.getChildNodes();
        for (int i = deletes.getLength() - 1; i >= 0; --i) {
            if (!DeleteManager.applyDelete((Element)deletes.item(i), ilf)) {
                dSet.removeChild(deletes.item(i));
                result.changedPLF = true;
                continue;
            }
            result.changedILF = true;
        }
        if (dSet.getChildNodes().getLength() == 0) {
            plf.getDocumentElement().removeChild(dSet);
            result.changedPLF = true;
        }
    }

    private static boolean applyDelete(Element delete, Document ilf) {
        String nodeID = delete.getAttribute("name");
        Element e = ilf.getElementById(nodeID);
        if (e == null) {
            return false;
        }
        String deleteAllowed = e.getAttribute("dlm:deleteAllowed");
        if (deleteAllowed.equals("false")) {
            return false;
        }
        Element p = (Element)e.getParentNode();
        e.setIdAttribute("ID", false);
        p.removeChild(e);
        return true;
    }

    private static Element getDeleteSet(Document plf, IPerson person, boolean create) throws PortalException {
        Element root = plf.getDocumentElement();
        for (Node child = root.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!child.getNodeName().equals("dlm:deleteSet")) continue;
            return (Element)child;
        }
        if (!create) {
            return null;
        }
        String ID = null;
        try {
            ID = DeleteManager.getDLS().getNextStructDirectiveId(person);
        }
        catch (Exception e) {
            throw new PortalException("Exception encountered while generating new delete set node Id for userId=" + person.getID(), (Throwable)e);
        }
        Element delSet = plf.createElement("dlm:deleteSet");
        delSet.setAttribute("type", "dlm:deleteSet");
        delSet.setAttribute("ID", ID);
        root.appendChild(delSet);
        return delSet;
    }

    public static void addDeleteDirective(Element compViewNode, String elementID, IPerson person) throws PortalException {
        Document plf = (Document)person.getAttribute("RDBMDistributedLayoutStore.PLF");
        Element delSet = DeleteManager.getDeleteSet(plf, person, true);
        DeleteManager.addDeleteDirective(compViewNode, elementID, person, plf, delSet);
    }

    private static void addDeleteDirective(Element compViewNode, String elementID, IPerson person, Document plf, Element delSet) throws PortalException {
        String ID = null;
        try {
            ID = DeleteManager.getDLS().getNextStructDirectiveId(person);
        }
        catch (Exception e) {
            throw new PortalException("Exception encountered while generating new delete node Id for userId=" + person.getID(), (Throwable)e);
        }
        Element delete = plf.createElement("dlm:delete");
        delete.setAttribute("type", "dlm:delete");
        delete.setAttribute("ID", ID);
        delete.setAttributeNS("http://www.uportal.org/layout/dlm", "name", elementID);
        delSet.appendChild(delete);
        for (Element child = (Element)compViewNode.getFirstChild(); child != null; child = (Element)child.getNextSibling()) {
            String childID = child.getAttribute("ID");
            if (!childID.startsWith("u")) continue;
            DeleteManager.addDeleteDirective(child, childID, person, plf, delSet);
        }
    }
}

