/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.layout.dlm;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.StructureStylesheetUserPreferences;
import org.jasig.portal.ThemeStylesheetUserPreferences;

public class DistributedUserPreferences
extends StructureStylesheetUserPreferences {
    public static final String RCS_ID = "@(#) $Header$";
    private static Log LOG = LogFactory.getLog(DistributedUserPreferences.class);
    protected Hashtable incorporatedChannelAttributeValues;
    protected Hashtable incorporatedFolderAttributeValues;

    public DistributedUserPreferences() {
        this.incorporatedChannelAttributeValues = new Hashtable();
        this.incorporatedFolderAttributeValues = new Hashtable();
    }

    public DistributedUserPreferences(StructureStylesheetUserPreferences ssup) {
        super(ssup);
        this.incorporatedChannelAttributeValues = new Hashtable();
        this.incorporatedFolderAttributeValues = new Hashtable();
    }

    public DistributedUserPreferences(ThemeStylesheetUserPreferences tsup) {
        super(tsup);
        this.incorporatedChannelAttributeValues = new Hashtable();
    }

    public DistributedUserPreferences(DistributedUserPreferences dup) {
        super(dup);
        if (dup.incorporatedChannelAttributeValues != null) {
            this.incorporatedChannelAttributeValues = new Hashtable(dup.incorporatedChannelAttributeValues);
        }
        if (dup.incorporatedFolderAttributeValues != null) {
            this.incorporatedFolderAttributeValues = new Hashtable(dup.incorporatedFolderAttributeValues);
        }
    }

    @Override
    public Object newInstance() {
        return new DistributedUserPreferences(this);
    }

    @Override
    public Enumeration getFolders() {
        Enumeration userOwned = this.folderAttributeValues.keys();
        Enumeration incorporated = this.incorporatedFolderAttributeValues.keys();
        HashSet attribs = new HashSet();
        while (userOwned.hasMoreElements()) {
            attribs.add(userOwned.nextElement());
        }
        while (incorporated.hasMoreElements()) {
            attribs.add(incorporated.nextElement());
        }
        return Collections.enumeration(attribs);
    }

    @Override
    public boolean hasFolder(String folderId) {
        return this.folderAttributeValues.containsKey(folderId) || this.incorporatedFolderAttributeValues.containsKey(folderId);
    }

    public String getDefaultFolderAttributeValue(String folderId, String attributeName) {
        Integer attributeNumber = (Integer)this.folderAttributeNumbers.get(attributeName);
        if (attributeNumber == null) {
            LOG.error((Object)("Attempting to obtain a non-existing attribute \"" + attributeName + "\"."));
            return null;
        }
        String value = null;
        List l = (List)this.incorporatedFolderAttributeValues.get(folderId);
        if (l == null) {
            return (String)this.defaultFolderAttributeValues.get(attributeNumber);
        }
        if (attributeNumber < l.size()) {
            value = (String)l.get(attributeNumber);
        }
        if (value == null) {
            try {
                value = (String)this.defaultFolderAttributeValues.get(attributeNumber);
            }
            catch (IndexOutOfBoundsException e) {
                LOG.error((Object)"Internal Error - attribute name is registered, but no default value is provided.");
                return null;
            }
        }
        return value;
    }

    @Override
    public String getFolderAttributeValue(String folderId, String attributeName) {
        Integer attributeNumber = (Integer)this.folderAttributeNumbers.get(attributeName);
        if (attributeNumber == null) {
            LOG.error((Object)("Attempting to obtain a non-existing attribute \"" + attributeName + "\"."));
            return null;
        }
        String value = null;
        List l = (List)this.folderAttributeValues.get(folderId);
        if (l == null) {
            l = (List)this.incorporatedFolderAttributeValues.get(folderId);
            if (l == null) {
                return (String)this.defaultFolderAttributeValues.get(attributeNumber);
            }
            if (attributeNumber < l.size()) {
                value = (String)l.get(attributeNumber);
            }
            if (value == null) {
                try {
                    value = (String)this.defaultFolderAttributeValues.get(attributeNumber);
                }
                catch (IndexOutOfBoundsException e) {
                    LOG.error((Object)"Internal Error - attribute name is registered, but no default value is provided.");
                    return null;
                }
            }
        } else {
            if (attributeNumber < l.size()) {
                value = (String)l.get(attributeNumber);
            }
            if (value == null) {
                l = (List)this.incorporatedFolderAttributeValues.get(folderId);
                if (l == null) {
                    try {
                        value = (String)this.defaultFolderAttributeValues.get(attributeNumber);
                    }
                    catch (IndexOutOfBoundsException e) {
                        LOG.error((Object)"Internal Error - attribute name is registered, but no default value is provided.");
                        return null;
                    }
                }
                if (attributeNumber < l.size()) {
                    value = (String)l.get(attributeNumber);
                }
                if (value == null) {
                    try {
                        value = (String)this.defaultFolderAttributeValues.get(attributeNumber);
                    }
                    catch (IndexOutOfBoundsException e) {
                        LOG.error((Object)"Internal Error - attribute name is registered, but no default value is provided.");
                        return null;
                    }
                }
            }
        }
        return value;
    }

    public void setIncorporatedFolderAttributeValue(String folderSubscribeId, String attributeName, String attributeValue) {
        Integer attributeNumber = (Integer)this.folderAttributeNumbers.get(attributeName);
        if (attributeNumber == null) {
            LOG.error((Object)("Attempting to set a non-existing folder attribute \"" + attributeName + "\"."));
            return;
        }
        List l = (List)this.incorporatedFolderAttributeValues.get(folderSubscribeId);
        if (l == null) {
            l = this.createIncorporatedFolder(folderSubscribeId);
        }
        try {
            l.set(attributeNumber, attributeValue);
        }
        catch (IndexOutOfBoundsException e) {
            for (int i = l.size(); i < attributeNumber; ++i) {
                l.add(null);
            }
            l.add(attributeValue);
        }
    }

    @Override
    public void removeFolder(String folderID) {
        if (this.folderAttributeValues.remove(folderID) == null && this.incorporatedFolderAttributeValues.remove(folderID) == null) {
            LOG.error((Object)("Attempting to remove an non-existing folder (folderID=\"" + folderID + "\") "));
        }
    }

    @Override
    public void removeChannel(String channelSubscribeId) {
        if (this.channelAttributeValues.remove(channelSubscribeId) == null && this.incorporatedChannelAttributeValues.remove(channelSubscribeId) == null) {
            LOG.error((Object)("Attempting to remove an non-existing channel (channelSubscribeId=\"" + channelSubscribeId + "\")."));
        }
    }

    public void removeDefinedFolderAttributeValue(String folderID, String attributeName) {
        Integer attributeNumber = (Integer)this.folderAttributeNumbers.get(attributeName);
        if (attributeNumber == null) {
            return;
        }
        List l = (List)this.folderAttributeValues.get(folderID);
        if (l == null) {
            return;
        }
        try {
            l.remove(attributeNumber);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    private ArrayList createIncorporatedFolder(String folderID) {
        ArrayList l = new ArrayList(this.defaultFolderAttributeValues.size());
        this.incorporatedFolderAttributeValues.put(folderID, l);
        return l;
    }

    public void changeFolderId(String oldFolderId, String newFolderId) {
        List l = (List)this.folderAttributeValues.remove(oldFolderId);
        if (l != null) {
            this.folderAttributeValues.put(newFolderId, l);
        }
    }

    @Override
    public Enumeration getChannels() {
        Enumeration userOwned = this.channelAttributeValues.keys();
        Enumeration incorporated = this.incorporatedChannelAttributeValues.keys();
        HashSet attribs = new HashSet();
        while (userOwned.hasMoreElements()) {
            attribs.add(userOwned.nextElement());
        }
        while (incorporated.hasMoreElements()) {
            attribs.add(incorporated.nextElement());
        }
        return Collections.enumeration(attribs);
    }

    @Override
    public boolean hasChannel(String chanId) {
        return this.channelAttributeValues.containsKey(chanId) || this.incorporatedChannelAttributeValues.containsKey(chanId);
    }

    public String getDefaultChannelAttributeValue(String channelSubscribeId, String attributeName) {
        Integer attributeNumber = (Integer)this.channelAttributeNumbers.get(attributeName);
        if (attributeNumber == null) {
            LOG.error((Object)("Attempting to obtain a non-existing attribute \"" + attributeName + "\"."));
            return null;
        }
        String value = null;
        List l = (List)this.incorporatedChannelAttributeValues.get(channelSubscribeId);
        if (l == null) {
            return (String)this.defaultChannelAttributeValues.get(attributeNumber);
        }
        if (attributeNumber < l.size()) {
            value = (String)l.get(attributeNumber);
        }
        if (value == null) {
            try {
                value = (String)this.defaultChannelAttributeValues.get(attributeNumber);
            }
            catch (IndexOutOfBoundsException e) {
                LOG.error((Object)"Internal Error - attribute name is registered, but no default value is provided.");
                return null;
            }
        }
        return value;
    }

    @Override
    public String getChannelAttributeValue(String channelSubscribeId, String attributeName) {
        Integer attributeNumber = (Integer)this.channelAttributeNumbers.get(attributeName);
        if (attributeNumber == null) {
            LOG.error((Object)("Attempting to obtain a non-existing attribute \"" + attributeName + "\"."));
            return null;
        }
        String value = null;
        List l = (List)this.channelAttributeValues.get(channelSubscribeId);
        if (l == null) {
            l = (List)this.incorporatedChannelAttributeValues.get(channelSubscribeId);
            if (l == null) {
                return (String)this.defaultChannelAttributeValues.get(attributeNumber);
            }
            if (attributeNumber < l.size()) {
                value = (String)l.get(attributeNumber);
            }
            if (value == null) {
                try {
                    value = (String)this.defaultChannelAttributeValues.get(attributeNumber);
                }
                catch (IndexOutOfBoundsException e) {
                    LOG.error((Object)"Internal Error - attribute name is registered, but no default value is provided.");
                    return null;
                }
            }
        } else {
            if (attributeNumber < l.size()) {
                value = (String)l.get(attributeNumber);
            }
            if (value == null) {
                l = (List)this.incorporatedChannelAttributeValues.get(channelSubscribeId);
                if (l == null) {
                    try {
                        value = (String)this.defaultChannelAttributeValues.get(attributeNumber);
                    }
                    catch (IndexOutOfBoundsException e) {
                        LOG.error((Object)"Internal Error - attribute name is registered, but no default value is provided.");
                        return null;
                    }
                }
                if (attributeNumber < l.size()) {
                    value = (String)l.get(attributeNumber);
                }
                if (value == null) {
                    try {
                        value = (String)this.defaultChannelAttributeValues.get(attributeNumber);
                    }
                    catch (IndexOutOfBoundsException e) {
                        LOG.error((Object)"Internal Error - attribute name is registered, but no default value is provided.");
                        return null;
                    }
                }
            }
        }
        return value;
    }

    public void setIncorporatedChannelAttributeValue(String channelSubscribeId, String attributeName, String attributeValue) {
        Integer attributeNumber = (Integer)this.channelAttributeNumbers.get(attributeName);
        if (attributeNumber == null) {
            LOG.error((Object)("Attempting to set a non-existing channel attribute \"" + attributeName + "\"."));
            return;
        }
        List l = (List)this.incorporatedChannelAttributeValues.get(channelSubscribeId);
        if (l == null) {
            l = this.createIncorporatedChannel(channelSubscribeId);
        }
        try {
            l.set(attributeNumber, attributeValue);
        }
        catch (IndexOutOfBoundsException e) {
            for (int i = l.size(); i < attributeNumber; ++i) {
                l.add(null);
            }
            l.add(attributeValue);
        }
    }

    public void removeDefinedChannelAttributeValue(String channelID, String attributeName) {
        Integer attributeNumber = (Integer)this.channelAttributeNumbers.get(attributeName);
        if (attributeNumber == null) {
            return;
        }
        List l = (List)this.channelAttributeValues.get(channelID);
        if (l == null) {
            return;
        }
        try {
            l.remove(attributeNumber);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    private ArrayList createIncorporatedChannel(String channelSubscribeId) {
        ArrayList l = new ArrayList(this.defaultChannelAttributeValues.size());
        this.incorporatedChannelAttributeValues.put(channelSubscribeId, l);
        return l;
    }

    public void changeChannelId(String oldChannelId, String newChannelId) {
        List l = (List)this.channelAttributeValues.remove(oldChannelId);
        if (l != null) {
            this.channelAttributeValues.put(newChannelId, l);
        }
    }
}

