/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.layout.dlm;

import java.util.Collection;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.apache.commons.lang.Validate;
import org.jasig.portal.layout.dlm.FragmentDefinition;
import org.jasig.portal.layout.dlm.IFragmentDefinitionDao;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class FragmentDefinitionDao
implements IFragmentDefinitionDao {
    private static final String GET_ALL_FRAGMENTS = "SELECT x FROM FragmentDefinition x ORDER BY x.precedence DESC";
    private static final String FIND_FRAGMENT_BY_NAME = "SELECT x FROM FragmentDefinition x WHERE x.name = :name";
    private static final String GET_ALL_FRAGMENTS_CACHE_REGION = FragmentDefinition.class.getName() + ".query.GET_ALL_FRAGMENTS";
    private static final String FIND_FRAGMENT_BY_NAME_CACHE_REGION = FragmentDefinition.class.getName() + ".query.FIND_FRAGMENT_BY_NAME";
    private EntityManager entityManager;

    public EntityManager getEntityManager() {
        return this.entityManager;
    }

    @PersistenceContext
    public void setEntityManager(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    @Override
    public List<FragmentDefinition> getAllFragments() {
        Query query = this.entityManager.createQuery(GET_ALL_FRAGMENTS);
        query.setHint("org.hibernate.cacheable", (Object)true);
        query.setHint("org.hibernate.cacheRegion", (Object)GET_ALL_FRAGMENTS_CACHE_REGION);
        List rslt = query.getResultList();
        return rslt;
    }

    @Override
    public FragmentDefinition getFragmentDefinition(String name) {
        Query query = this.entityManager.createQuery(FIND_FRAGMENT_BY_NAME);
        query.setParameter("name", (Object)name);
        query.setHint("org.hibernate.cacheable", (Object)true);
        query.setHint("org.hibernate.cacheRegion", (Object)FIND_FRAGMENT_BY_NAME_CACHE_REGION);
        query.setMaxResults(1);
        List list = query.getResultList();
        FragmentDefinition rslt = (FragmentDefinition)DataAccessUtils.uniqueResult((Collection)list);
        return rslt;
    }

    @Override
    @Transactional
    public void updateFragmentDefinition(FragmentDefinition fd) {
        Validate.notNull((Object)fd, (String)"FragmentDefinition can not be null");
        this.entityManager.merge((Object)fd);
    }

    @Override
    @Transactional
    public void removeFragmentDefinition(FragmentDefinition fd) {
        Validate.notNull((Object)fd, (String)"FragmentDefinition can not be null");
        this.entityManager.remove((Object)fd);
    }
}

