/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.layout.dlm;

import org.jasig.portal.PortalException;
import org.jasig.portal.layout.dlm.DistributedLayoutManager;
import org.jasig.portal.layout.dlm.EditManager;
import org.jasig.portal.layout.dlm.HandlerUtils;
import org.jasig.portal.layout.dlm.IFolderLabelPolicy;
import org.jasig.portal.layout.dlm.ILayoutProcessingAction;
import org.jasig.portal.layout.dlm.RDBMDistributedLayoutStore;
import org.jasig.portal.security.IPerson;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class LPAChangeAttribute
implements ILayoutProcessingAction {
    private String nodeId = null;
    private String name = null;
    private IPerson person = null;
    private Element ilfNode = null;
    private String value = null;
    private boolean isFragmentOwner = false;

    LPAChangeAttribute(String nodeId, String name, String value, IPerson p, Element ilfNode, boolean isFragmentOwner) {
        this.nodeId = nodeId;
        this.name = name;
        this.person = p;
        this.ilfNode = ilfNode;
        this.value = value;
        this.isFragmentOwner = isFragmentOwner;
    }

    @Override
    public void perform() throws PortalException {
        if (this.nodeId.startsWith("u")) {
            Element plfNode = HandlerUtils.getPLFNode(this.ilfNode, this.person, true, false);
            plfNode.setAttribute(this.name, this.value);
            EditManager.addEditDirective(plfNode, this.name, this.person);
            IFolderLabelPolicy labelPolicy = DistributedLayoutManager.ContextHolder.getLabelPolicy();
            if (this.name.equals("name") && labelPolicy != null) {
                String plfId = plfNode.getAttribute("dlm:plfID");
                labelPolicy.updateNodeLabel(plfId, this.person.getID(), false, this.value);
            }
        } else {
            Document plf = RDBMDistributedLayoutStore.getPLF(this.person);
            Element plfNode = plf.getElementById(this.nodeId);
            if (plfNode != null) {
                IFolderLabelPolicy labelPolicy = DistributedLayoutManager.ContextHolder.getLabelPolicy();
                if (this.name.equals("name") && labelPolicy != null) {
                    String plfId = plfNode.getAttribute("dlm:plfID");
                    labelPolicy.updateNodeLabel(this.nodeId, this.person.getID(), this.isFragmentOwner, this.value);
                } else {
                    plfNode.setAttribute(this.name, this.value);
                }
            }
        }
        IFolderLabelPolicy labelPolicy = DistributedLayoutManager.ContextHolder.getLabelPolicy();
        if (!this.name.equals("name") || labelPolicy == null) {
            this.ilfNode.setAttribute(this.name, this.value);
        }
    }
}

