/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.layout.dlm;

import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class RootLocator {
    private static final Log LOG = LogFactory.getLog(RootLocator.class);
    private static final String cfgPrefix = RootLocator.class.getName() + ".";
    private static XPathExpression rootLocatorXpathExpression = null;

    public static Element getRootElement(Document layout) {
        Element root = null;
        try {
            if (rootLocatorXpathExpression == null) {
                RootLocator.createRootLocatorXpathExpression();
            }
            root = (Element)rootLocatorXpathExpression.evaluate(layout, XPathConstants.NODE);
        }
        catch (Exception e) {
            LOG.error((Object)"Unable to locate layout element of type root", (Throwable)e);
        }
        return root;
    }

    private static void createRootLocatorXpathExpression() {
        String expression = "//layout/folder";
        try {
            XPathFactory fac = XPathFactory.newInstance();
            XPath xpath = fac.newXPath();
            rootLocatorXpathExpression = xpath.compile(expression);
        }
        catch (XPathExpressionException e) {
            throw new RuntimeException("Unable to compile XPath expression '" + expression + "' for obtaining root layout element.", e);
        }
    }
}

