/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.layout.dlm.remoting;

import java.util.HashSet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.AuthorizationException;
import org.jasig.portal.layout.dlm.remoting.IGroupListHelper;
import org.jasig.portal.layout.dlm.remoting.JsonEntityBean;
import org.jasig.portal.security.AdminEvaluator;
import org.jasig.portal.security.IPerson;
import org.jasig.portal.security.IPersonManager;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractController;

public class SearchEntitiesController
extends AbstractController {
    private static final Log log = LogFactory.getLog(SearchEntitiesController.class);
    private IGroupListHelper groupListHelper;
    private IPersonManager personManager;

    public SearchEntitiesController() {
        this.setSupportedMethods(new String[]{"POST"});
    }

    public ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        IPerson user = this.personManager.getPerson(request);
        if (!AdminEvaluator.isAdmin(user)) {
            throw new AuthorizationException("User " + user.getUserName() + " not an administrator.");
        }
        String[] entityTypes = request.getParameterValues("entityType");
        String searchTerm = request.getParameter("searchTerm");
        if (entityTypes == null || entityTypes.length == 0) {
            return new ModelAndView("jsonView", "error", (Object)"No entityType specified.");
        }
        HashSet<JsonEntityBean> results = new HashSet<JsonEntityBean>();
        for (String entityType : entityTypes) {
            results.addAll(this.groupListHelper.search(entityType, searchTerm));
        }
        return new ModelAndView("jsonView", "results", results);
    }

    public void setGroupListHelper(IGroupListHelper groupListHelper) {
        this.groupListHelper = groupListHelper;
    }

    public void setPersonManager(IPersonManager personManager) {
        this.personManager = personManager;
    }
}

