/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.layout.node;

import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.ChannelRegistryStoreFactory;
import org.jasig.portal.IChannelRegistryStore;
import org.jasig.portal.PortalException;
import org.jasig.portal.channel.IChannelDefinition;
import org.jasig.portal.channel.IChannelParameter;
import org.jasig.portal.channels.portlet.IPortletAdaptor;
import org.jasig.portal.layout.node.IUserLayoutChannelDescription;
import org.jasig.portal.layout.node.UserLayoutNodeDescription;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class UserLayoutChannelDescription
extends UserLayoutNodeDescription
implements IUserLayoutChannelDescription {
    private static final Log log = LogFactory.getLog(UserLayoutChannelDescription.class);
    Hashtable parameters = new Hashtable();
    Hashtable override = new Hashtable();
    String title = null;
    String description = null;
    String className = null;
    Class channelClass = null;
    String channelPublishId = null;
    String channelTypeId = null;
    String functionalName = null;
    long timeout = -1L;
    boolean editable = false;
    boolean hasHelp = false;
    boolean hasAbout = false;
    boolean isSecure = false;

    public UserLayoutChannelDescription() {
    }

    public UserLayoutChannelDescription(IUserLayoutChannelDescription d) {
        this();
        this.title = d.getTitle();
        this.description = d.getDescription();
        this.setClassName(d.getClassName());
        this.channelPublishId = d.getChannelPublishId();
        this.channelTypeId = d.getChannelTypeId();
        this.functionalName = d.getFunctionalName();
        this.timeout = d.getTimeout();
        this.editable = d.isEditable();
        this.hasHelp = d.hasHelp();
        this.hasAbout = d.hasAbout();
        Enumeration enum1 = d.getParameterNames();
        while (enum1.hasMoreElements()) {
            String pName = (String)enum1.nextElement();
            this.setParameterValue(pName, d.getParameterValue(pName));
            this.setParameterOverride(pName, d.getParameterOverrideValue(pName));
        }
    }

    public UserLayoutChannelDescription(IChannelDefinition definition) {
        this();
        this.title = definition.getTitle();
        this.description = definition.getDescription();
        this.setClassName(definition.getJavaClass());
        this.channelPublishId = String.valueOf(definition.getId());
        this.channelTypeId = String.valueOf(definition.getType().getId());
        this.functionalName = definition.getFName();
        this.timeout = definition.getTimeout();
        this.editable = definition.isEditable();
        this.hasHelp = definition.hasHelp();
        this.hasAbout = definition.hasAbout();
        for (IChannelParameter param : definition.getParameters()) {
            this.setParameterValue(param.getName(), param.getValue());
            this.setParameterOverride(param.getName(), param.getOverride());
        }
    }

    public UserLayoutChannelDescription(Element xmlNode) throws PortalException {
        super(xmlNode);
        if (!xmlNode.getNodeName().equals("channel")) {
            throw new PortalException("Given XML Element is not a channel!");
        }
        this.setTitle(xmlNode.getAttribute("title"));
        this.setDescription(xmlNode.getAttribute("description"));
        this.setClassName(xmlNode.getAttribute("class"));
        this.setChannelPublishId(xmlNode.getAttribute("chanID"));
        this.setChannelTypeId(xmlNode.getAttribute("typeID"));
        this.setFunctionalName(xmlNode.getAttribute("fname"));
        this.setTimeout(Long.parseLong(xmlNode.getAttribute("timeout")));
        this.setEditable(Boolean.valueOf(xmlNode.getAttribute("editable")));
        this.setHasHelp(Boolean.valueOf(xmlNode.getAttribute("hasHelp")));
        this.setHasAbout(Boolean.valueOf(xmlNode.getAttribute("hasAbout")));
        this.setIsSecure(Boolean.valueOf(xmlNode.getAttribute("secure")));
        for (Node n = xmlNode.getFirstChild(); n != null; n = n.getNextSibling()) {
            Element e;
            if (n.getNodeType() != 1 || !(e = (Element)n).getNodeName().equals("parameter")) continue;
            String pName = e.getAttribute("name");
            String pValue = e.getAttribute("value");
            Boolean canOverride = new Boolean(false);
            String str_override = e.getAttribute("override");
            if (str_override != null && str_override.equals("yes")) {
                canOverride = new Boolean(true);
            }
            if (pName == null || pValue == null) continue;
            this.setParameterValue(pName, pValue);
            this.setParameterOverride(pName, canOverride);
        }
    }

    @Override
    public boolean hasAbout() {
        return this.hasAbout;
    }

    @Override
    public void setHasAbout(boolean v) {
        this.hasAbout = v;
    }

    @Override
    public boolean hasHelp() {
        return this.hasHelp;
    }

    @Override
    public void setHasHelp(boolean v) {
        this.hasHelp = v;
    }

    @Override
    public boolean isEditable() {
        return this.editable;
    }

    @Override
    public void setEditable(boolean v) {
        this.editable = v;
    }

    @Override
    public long getTimeout() {
        return this.timeout;
    }

    @Override
    public void setTimeout(long v) {
        this.timeout = v;
    }

    @Override
    public boolean isSecure() {
        return this.isSecure;
    }

    @Override
    public void setIsSecure(boolean secure) {
        this.isSecure = secure;
    }

    @Override
    public boolean isPortlet() {
        return this.channelClass != null && IPortletAdaptor.class.isAssignableFrom(this.channelClass);
    }

    @Override
    public String getFunctionalName() {
        return this.functionalName;
    }

    @Override
    public void setFunctionalName(String v) {
        this.functionalName = v;
    }

    @Override
    public String getChannelSubscribeId() {
        return super.getId();
    }

    @Override
    public void setChannelSubscribeId(String v) {
        super.setId(v);
    }

    @Override
    public String getChannelTypeId() {
        return this.channelTypeId;
    }

    @Override
    public void setChannelTypeId(String v) {
        this.channelTypeId = v;
    }

    @Override
    public String getChannelPublishId() {
        return this.channelPublishId;
    }

    @Override
    public void setChannelPublishId(String v) {
        this.channelPublishId = v;
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    @Override
    public void setClassName(String v) {
        this.className = v;
        if (!StringUtils.isBlank((String)this.className)) {
            try {
                this.channelClass = Class.forName(this.className);
            }
            catch (ClassNotFoundException e) {
                log.error((Object)("Unable to load class for name '" + this.className + "' for channel with pubId='" + this.channelPublishId + "', fname='" + this.functionalName + "'."), (Throwable)e);
            }
        }
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public void setTitle(String v) {
        this.title = v;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String v) {
        this.description = v;
    }

    @Override
    public String setParameterValue(String parameterName, String parameterValue) {
        if (parameterValue == null) {
            return null;
        }
        return this.parameters.put(parameterName, parameterValue);
    }

    @Override
    public void resetParameter(String parameterName) throws PortalException {
        try {
            IChannelRegistryStore crs = ChannelRegistryStoreFactory.getChannelRegistryStoreImpl();
            int pubId = Integer.parseInt(this.getChannelPublishId());
            IChannelDefinition def = crs.getChannelDefinition(pubId);
            IChannelParameter parm = def.getParameter(parameterName);
            if (parm == null) {
                this.parameters.remove(parameterName);
                this.override.remove(parameterName);
            } else if (parm.getOverride()) {
                this.parameters.put(parameterName, parm.getValue());
            }
        }
        catch (Exception e) {
            throw new PortalException("Unable to reset parameter [" + parameterName + "] for channel [" + this.getTitle() + "].", (Throwable)e);
        }
    }

    @Override
    public String getParameterValue(String parameterName) {
        return (String)this.parameters.get(parameterName);
    }

    @Override
    public boolean getParameterOverrideValue(String parameterName) {
        Boolean boolValue = (Boolean)this.override.get(parameterName);
        if (boolValue != null) {
            return boolValue;
        }
        return true;
    }

    @Override
    public Collection getParameterValues() {
        return this.parameters.values();
    }

    @Override
    public int numberOfParameters() {
        return this.parameters.size();
    }

    @Override
    public void clearParameters() {
        this.parameters.clear();
        this.override.clear();
    }

    @Override
    public boolean canOverrideParameter(String parameterName) {
        return this.getParameterOverrideValue(parameterName);
    }

    @Override
    public void setParameterOverride(String parameterName, boolean canOverride) {
        if (this.parameters.get(parameterName) != null) {
            this.override.put(parameterName, new Boolean(canOverride));
        }
    }

    @Override
    public String remove(String parameterName) {
        this.override.remove(parameterName);
        return (String)this.parameters.remove(parameterName);
    }

    @Override
    public Enumeration getParameterNames() {
        return this.parameters.keys();
    }

    @Override
    public Map getParameterMap() {
        return Collections.unmodifiableMap(this.parameters);
    }

    @Override
    public boolean hasParameters() {
        return !this.parameters.isEmpty();
    }

    @Override
    public boolean containsParameter(String parameterName) {
        return this.parameters.containsKey(parameterName);
    }

    @Override
    public Element getXML(Document root) {
        Element node = root.createElement("channel");
        this.addNodeAttributes(node);
        this.addParameterChildren(node, root);
        return node;
    }

    public void addParameterChildren(Element node, Document root) {
        Enumeration enum1 = this.getParameterNames();
        while (enum1.hasMoreElements()) {
            Element pElement = root.createElement("parameter");
            String pName = (String)enum1.nextElement();
            pElement.setAttribute("name", pName);
            pElement.setAttribute("value", this.getParameterValue(pName));
            pElement.setAttribute("override", this.getParameterOverrideValue(pName) ? "yes" : "no");
            node.appendChild(pElement);
        }
    }

    @Override
    public void addNodeAttributes(Element node) {
        super.addNodeAttributes(node);
        node.setAttribute("title", this.getTitle());
        node.setAttribute("description", this.getDescription());
        node.setAttribute("class", this.getClassName());
        node.setAttribute("chanID", this.getChannelPublishId());
        node.setAttribute("typeID", this.getChannelTypeId());
        node.setAttribute("fname", this.getFunctionalName());
        node.setAttribute("timeout", Long.toString(this.getTimeout()));
        node.setAttribute("editable", new Boolean(this.isEditable()).toString());
        node.setAttribute("hasHelp", new Boolean(this.hasHelp()).toString());
        node.setAttribute("hasAbout", new Boolean(this.hasAbout()).toString());
        node.setAttribute("secure", new Boolean(this.isSecure()).toString());
        node.setAttribute("isPortlet", Boolean.valueOf(this.isPortlet()).toString());
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public String toString() {
        return "[" + this.channelPublishId + "," + this.title + "]";
    }
}

