/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.layout.simple;

import java.util.Enumeration;
import java.util.Vector;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.PortalException;
import org.jasig.portal.layout.IUserLayout;
import org.jasig.portal.layout.LayoutEventListener;
import org.jasig.portal.layout.node.IUserLayoutFolderDescription;
import org.jasig.portal.layout.node.IUserLayoutNodeDescription;
import org.jasig.portal.layout.node.UserLayoutNodeDescription;
import org.jasig.portal.utils.XML;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ContentHandler;

public class SimpleLayout
implements IUserLayout {
    private Document layout;
    private String layoutId;
    private String cacheKey;
    private Log log = LogFactory.getLog(this.getClass());

    public SimpleLayout(String layoutId, Document layout) {
        this.layoutId = layoutId;
        this.layout = layout;
    }

    @Override
    public void writeTo(ContentHandler ch) throws PortalException {
        try {
            XML.dom2sax(this.layout, ch);
        }
        catch (Exception e) {
            throw new PortalException(e);
        }
    }

    @Override
    public void writeTo(String nodeId, ContentHandler ch) throws PortalException {
        try {
            XML.dom2sax(this.layout.getElementById(nodeId), ch);
        }
        catch (Exception e) {
            throw new PortalException(e);
        }
    }

    @Override
    public void writeTo(Document document) throws PortalException {
        document.appendChild(document.importNode(this.layout.getDocumentElement(), true));
    }

    @Override
    public void writeTo(String nodeId, Document document) throws PortalException {
        document.appendChild(document.importNode(this.layout.getElementById(nodeId), true));
    }

    @Override
    public IUserLayoutNodeDescription getNodeDescription(String nodeId) throws PortalException {
        Element element = this.layout.getElementById(nodeId);
        return UserLayoutNodeDescription.createUserLayoutNodeDescription(element);
    }

    @Override
    public String getParentId(String nodeId) throws PortalException {
        Node parent;
        String parentId = null;
        Element element = this.layout.getElementById(nodeId);
        if (element != null && (parent = element.getParentNode()) != null && parent.getNodeType() == 1) {
            Element parentE = (Element)parent;
            parentId = parentE.getAttribute("ID");
        }
        return parentId;
    }

    @Override
    public Enumeration getChildIds(String nodeId) throws PortalException {
        Vector<String> v = new Vector<String>();
        IUserLayoutNodeDescription node = this.getNodeDescription(nodeId);
        if (node instanceof IUserLayoutFolderDescription) {
            Element element = this.layout.getElementById(nodeId);
            for (Node n = element.getFirstChild(); n != null; n = n.getNextSibling()) {
                Element e;
                if (n.getNodeType() != 1 || (e = (Element)n).getAttribute("ID") == null) continue;
                v.add(e.getAttribute("ID"));
            }
        }
        return v.elements();
    }

    @Override
    public String getNextSiblingId(String nodeId) throws PortalException {
        String nextSiblingId = null;
        Element element = this.layout.getElementById(nodeId);
        if (element != null) {
            Node sibling;
            for (sibling = element.getNextSibling(); sibling != null && sibling.getNodeType() != 1; sibling = sibling.getNextSibling()) {
            }
            if (sibling != null) {
                Element e = (Element)sibling;
                nextSiblingId = e.getAttribute("ID");
            }
        }
        return nextSiblingId;
    }

    @Override
    public String getPreviousSiblingId(String nodeId) throws PortalException {
        String prevSiblingId = null;
        Element element = this.layout.getElementById(nodeId);
        if (element != null) {
            Node sibling;
            for (sibling = element.getPreviousSibling(); sibling != null && sibling.getNodeType() != 1; sibling = sibling.getPreviousSibling()) {
            }
            if (sibling != null) {
                Element e = (Element)sibling;
                prevSiblingId = e.getAttribute("ID");
            }
        }
        return prevSiblingId;
    }

    @Override
    public String getCacheKey() throws PortalException {
        return this.cacheKey;
    }

    @Override
    public boolean addLayoutEventListener(LayoutEventListener l) {
        return false;
    }

    @Override
    public boolean removeLayoutEventListener(LayoutEventListener l) {
        return false;
    }

    @Override
    public String getId() {
        return this.layoutId;
    }

    @Override
    public String getNodeId(String fname) throws PortalException {
        String nodeId = null;
        NodeList nl = this.layout.getElementsByTagName("channel");
        for (int i = 0; i < nl.getLength(); ++i) {
            Element channelE;
            Node node = nl.item(i);
            if (node.getNodeType() != 1 || !fname.equals((channelE = (Element)node).getAttribute("fname"))) continue;
            nodeId = channelE.getAttribute("ID");
            break;
        }
        return nodeId;
    }

    @Override
    public String findNodeId(XPathExpression xpathExpression) throws PortalException {
        try {
            return xpathExpression.evaluate(this.layout);
        }
        catch (XPathExpressionException e) {
            throw new PortalException("Exception while executing XPathExpression: " + xpathExpression, (Throwable)e);
        }
    }

    @Override
    public Enumeration getNodeIds() throws PortalException {
        Vector<String> v = new Vector<String>();
        try {
            String expression = "*";
            XPathFactory fac = XPathFactory.newInstance();
            XPath xpath = fac.newXPath();
            NodeList nl = (NodeList)xpath.evaluate(expression, this.layout, XPathConstants.NODESET);
            for (int i = 0; i < nl.getLength(); ++i) {
                Node node = nl.item(i);
                if (node.getNodeType() != 1) continue;
                Element e = (Element)node;
                v.add(e.getAttribute("ID"));
            }
        }
        catch (Exception e) {
            this.log.error((Object)"Exception getting node ids.", (Throwable)e);
        }
        return v.elements();
    }

    @Override
    public String getRootId() {
        String rootNode = null;
        try {
            String expression = "/layout/folder";
            XPathFactory fac = XPathFactory.newInstance();
            XPath xpath = fac.newXPath();
            Element rootNodeE = (Element)xpath.evaluate(expression, this.layout, XPathConstants.NODE);
            rootNode = rootNodeE.getAttribute("ID");
        }
        catch (Exception e) {
            this.log.error((Object)"Error getting root id.", (Throwable)e);
        }
        return rootNode;
    }
}

