/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.portlet.container.services;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.portlet.PortletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.Validate;
import org.apache.pluto.PortletContainerException;
import org.apache.pluto.PortletWindow;
import org.apache.pluto.descriptors.portlet.PortletDD;
import org.apache.pluto.descriptors.portlet.PortletPreferenceDD;
import org.apache.pluto.descriptors.portlet.PortletPreferencesDD;
import org.apache.pluto.internal.InternalPortletPreference;
import org.apache.pluto.spi.optional.PortletPreferencesService;
import org.jasig.portal.channels.portlet.IPortletAdaptor;
import org.jasig.portal.portlet.dao.jpa.PortletPreferenceImpl;
import org.jasig.portal.portlet.om.IPortletDefinition;
import org.jasig.portal.portlet.om.IPortletEntity;
import org.jasig.portal.portlet.om.IPortletEntityId;
import org.jasig.portal.portlet.om.IPortletPreference;
import org.jasig.portal.portlet.om.IPortletPreferences;
import org.jasig.portal.portlet.om.IPortletWindow;
import org.jasig.portal.portlet.registry.IPortletDefinitionRegistry;
import org.jasig.portal.portlet.registry.IPortletEntityRegistry;
import org.jasig.portal.portlet.registry.IPortletWindowRegistry;
import org.jasig.portal.security.IPerson;
import org.jasig.portal.security.IPersonManager;
import org.jasig.portal.url.IPortalRequestUtils;
import org.springframework.beans.factory.annotation.Required;

public class PortletPreferencesServiceImpl
implements PortletPreferencesService {
    protected static final String PORTLET_PREFERENCES_MAP_ATTRIBUTE = PortletPreferencesServiceImpl.class.getName() + ".PORTLET_PREFERENCES_MAP";
    private IPersonManager personManager;
    private IPortletWindowRegistry portletWindowRegistry;
    private IPortletEntityRegistry portletEntityRegistry;
    private IPortletDefinitionRegistry portletDefinitionRegistry;
    private IPortalRequestUtils portalRequestUtils;
    private boolean loadGuestPreferencesFromMemory = true;
    private boolean loadGuestPreferencesFromEntity = true;
    private boolean storeGuestPreferencesInMemory = true;
    private boolean storeGuestPreferencesInEntity = false;

    public IPortalRequestUtils getPortalRequestUtils() {
        return this.portalRequestUtils;
    }

    @Required
    public void setPortalRequestUtils(IPortalRequestUtils portalRequestUtils) {
        Validate.notNull((Object)portalRequestUtils);
        this.portalRequestUtils = portalRequestUtils;
    }

    public IPortletWindowRegistry getPortletWindowRegistry() {
        return this.portletWindowRegistry;
    }

    @Required
    public void setPortletWindowRegistry(IPortletWindowRegistry portletWindowRegistry) {
        Validate.notNull((Object)portletWindowRegistry);
        this.portletWindowRegistry = portletWindowRegistry;
    }

    public IPortletEntityRegistry getPortletEntityRegistry() {
        return this.portletEntityRegistry;
    }

    @Required
    public void setPortletEntityRegistry(IPortletEntityRegistry portletEntityRegistry) {
        Validate.notNull((Object)portletEntityRegistry);
        this.portletEntityRegistry = portletEntityRegistry;
    }

    public IPortletDefinitionRegistry getPortletDefinitionRegistry() {
        return this.portletDefinitionRegistry;
    }

    @Required
    public void setPortletDefinitionRegistry(IPortletDefinitionRegistry portletDefinitionRegistry) {
        Validate.notNull((Object)portletDefinitionRegistry);
        this.portletDefinitionRegistry = portletDefinitionRegistry;
    }

    public IPersonManager getPersonManager() {
        return this.personManager;
    }

    @Required
    public void setPersonManager(IPersonManager personManager) {
        Validate.notNull((Object)personManager);
        this.personManager = personManager;
    }

    public boolean isLoadGuestPreferencesFromMemory() {
        return this.loadGuestPreferencesFromMemory;
    }

    public void setLoadGuestPreferencesFromMemory(boolean loadGuestPreferencesFromMemory) {
        this.loadGuestPreferencesFromMemory = loadGuestPreferencesFromMemory;
    }

    public boolean isLoadGuestPreferencesFromEntity() {
        return this.loadGuestPreferencesFromEntity;
    }

    public void setLoadGuestPreferencesFromEntity(boolean loadGuestPreferencesFromEntity) {
        this.loadGuestPreferencesFromEntity = loadGuestPreferencesFromEntity;
    }

    public boolean isStoreGuestPreferencesInMemory() {
        return this.storeGuestPreferencesInMemory;
    }

    public void setStoreGuestPreferencesInMemory(boolean storeGuestPreferencesInMemory) {
        this.storeGuestPreferencesInMemory = storeGuestPreferencesInMemory;
    }

    public boolean isStoreGuestPreferencesInEntity() {
        return this.storeGuestPreferencesInEntity;
    }

    public void setStoreGuestPreferencesInEntity(boolean storeGuestPreferencesInEntity) {
        this.storeGuestPreferencesInEntity = storeGuestPreferencesInEntity;
    }

    public boolean isStoreInEntity(PortletRequest portletRequest) {
        HttpServletRequest httpServletRequest = this.portalRequestUtils.getOriginalPortletAdaptorRequest(portletRequest);
        return !this.isGuestUser(httpServletRequest) || this.storeGuestPreferencesInEntity;
    }

    public boolean isLoadFromEntity(PortletRequest portletRequest) {
        HttpServletRequest httpServletRequest = this.portalRequestUtils.getOriginalPortletAdaptorRequest(portletRequest);
        return !this.isGuestUser(httpServletRequest) || this.loadGuestPreferencesFromEntity;
    }

    public boolean isStoreInMemory(PortletRequest portletRequest) {
        HttpServletRequest httpServletRequest = this.portalRequestUtils.getOriginalPortletAdaptorRequest(portletRequest);
        return this.isGuestUser(httpServletRequest) && this.storeGuestPreferencesInMemory;
    }

    public boolean isLoadFromMemory(PortletRequest portletRequest) {
        HttpServletRequest httpServletRequest = this.portalRequestUtils.getOriginalPortletAdaptorRequest(portletRequest);
        return this.isGuestUser(httpServletRequest) && this.loadGuestPreferencesFromMemory;
    }

    public InternalPortletPreference[] getStoredPreferences(PortletWindow plutoPortletWindow, PortletRequest portletRequest) throws PortletContainerException {
        HttpServletRequest httpServletRequest = this.portalRequestUtils.getOriginalPortletAdaptorRequest(portletRequest);
        IPortletWindow portletWindow = this.portletWindowRegistry.convertPortletWindow(httpServletRequest, plutoPortletWindow);
        IPortletEntity portletEntity = this.portletWindowRegistry.getParentPortletEntity(httpServletRequest, portletWindow.getPortletWindowId());
        IPortletDefinition portletDefinition = this.portletEntityRegistry.getParentPortletDefinition(portletEntity.getPortletEntityId());
        PortletDD portletDescriptor = this.portletDefinitionRegistry.getParentPortletDescriptor(portletDefinition.getPortletDefinitionId());
        LinkedHashMap<String, InternalPortletPreference> preferencesMap = new LinkedHashMap<String, InternalPortletPreference>();
        List<IPortletPreference> descriptorPreferencesList = this.getDescriptorPreferences(portletDescriptor);
        this.addPreferencesToMap(descriptorPreferencesList, preferencesMap);
        IPortletPreferences definitionPreferences = portletDefinition.getPortletPreferences();
        List<IPortletPreference> definitionPreferencesList = definitionPreferences.getPortletPreferences();
        this.addPreferencesToMap(definitionPreferencesList, preferencesMap);
        boolean isGuest = this.isGuestUser(httpServletRequest);
        if (!IPortletAdaptor.CONFIG.equals((Object)portletWindow.getPortletMode())) {
            if (this.isLoadFromEntity(portletRequest)) {
                IPortletPreferences entityPreferences = portletEntity.getPortletPreferences();
                List<IPortletPreference> entityPreferencesList = entityPreferences.getPortletPreferences();
                this.addPreferencesToMap(entityPreferencesList, preferencesMap);
                if (!this.isLoadFromMemory(portletRequest) && !this.isStoreInEntity(portletRequest) && this.isStoreInMemory(portletRequest)) {
                    this.store(plutoPortletWindow, portletRequest, preferencesMap.values().toArray(new InternalPortletPreference[preferencesMap.size()]));
                }
            }
            if (this.isLoadFromMemory(portletRequest)) {
                List<IPortletPreference> entityPreferencesList = this.getSessionPreferences(portletEntity.getPortletEntityId(), httpServletRequest);
                this.addPreferencesToMap(entityPreferencesList, preferencesMap);
            }
        }
        return preferencesMap.values().toArray(new InternalPortletPreference[preferencesMap.size()]);
    }

    public void store(PortletWindow plutoPortletWindow, PortletRequest portletRequest, InternalPortletPreference[] newPreferences) throws PortletContainerException {
        HttpServletRequest httpServletRequest = this.portalRequestUtils.getOriginalPortletAdaptorRequest(portletRequest);
        boolean isGuest = this.isGuestUser(httpServletRequest);
        if (isGuest && !this.isStoreInEntity(portletRequest) && !this.isStoreInMemory(portletRequest)) {
            return;
        }
        IPortletWindow portletWindow = this.portletWindowRegistry.convertPortletWindow(httpServletRequest, plutoPortletWindow);
        IPortletEntity portletEntity = this.portletWindowRegistry.getParentPortletEntity(httpServletRequest, portletWindow.getPortletWindowId());
        IPortletDefinition portletDefinition = this.portletEntityRegistry.getParentPortletDefinition(portletEntity.getPortletEntityId());
        PortletDD portletDescriptor = this.portletDefinitionRegistry.getParentPortletDescriptor(portletDefinition.getPortletDefinitionId());
        boolean configMode = IPortletAdaptor.CONFIG.equals((Object)portletWindow.getPortletMode());
        HashMap<String, InternalPortletPreference> basePreferences = new HashMap<String, InternalPortletPreference>();
        List<IPortletPreference> descriptorPreferencesList = this.getDescriptorPreferences(portletDescriptor);
        this.addPreferencesToMap(descriptorPreferencesList, basePreferences);
        IPortletPreferences definitionPreferences = portletDefinition.getPortletPreferences();
        if (!configMode) {
            List<IPortletPreference> definitionPreferencesList = definitionPreferences.getPortletPreferences();
            this.addPreferencesToMap(definitionPreferencesList, basePreferences);
        }
        ArrayList<IPortletPreference> preferencesList = new ArrayList<IPortletPreference>(newPreferences.length);
        for (InternalPortletPreference internalPreference : newPreferences) {
            InternalPortletPreference basePreference;
            PortletPreferenceImpl preference;
            String name = internalPreference.getName();
            if (name == null || ((Object)(preference = new PortletPreferenceImpl(internalPreference))).equals(basePreference = (InternalPortletPreference)basePreferences.get(name))) continue;
            preferencesList.add(preference);
        }
        if (configMode) {
            definitionPreferences.setPortletPreferences(preferencesList);
            this.portletDefinitionRegistry.updatePortletDefinition(portletDefinition);
        } else if (this.isStoreInEntity(portletRequest)) {
            IPortletPreferences entityPreferences = portletEntity.getPortletPreferences();
            entityPreferences.setPortletPreferences(preferencesList);
            this.portletEntityRegistry.storePortletEntity(portletEntity);
        } else {
            this.storeSessionPreferences(portletEntity.getPortletEntityId(), httpServletRequest, preferencesList);
        }
    }

    protected List<IPortletPreference> getDescriptorPreferences(PortletDD portletDescriptor) {
        LinkedList<IPortletPreference> preferences = new LinkedList<IPortletPreference>();
        PortletPreferencesDD descriptorPreferences = portletDescriptor.getPortletPreferences();
        if (descriptorPreferences != null) {
            List descriptorPreferencesList = descriptorPreferences.getPortletPreferences();
            for (PortletPreferenceDD descriptorPreference : descriptorPreferencesList) {
                PortletPreferenceImpl internaldescriptorPreference = new PortletPreferenceImpl(descriptorPreference);
                preferences.add(internaldescriptorPreference);
            }
        }
        return preferences;
    }

    protected void addPreferencesToMap(List<IPortletPreference> preferencesList, Map<String, InternalPortletPreference> preferencesMap) {
        if (preferencesList == null) {
            return;
        }
        for (IPortletPreference definitionPreference : preferencesList) {
            preferencesMap.put(definitionPreference.getName(), new PortletPreferenceImpl(definitionPreference));
        }
    }

    protected boolean isGuestUser(HttpServletRequest httpServletRequest) {
        IPerson person = this.personManager.getPerson(httpServletRequest);
        return person.isGuest();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<IPortletPreference> getSessionPreferences(IPortletEntityId portletEntityId, HttpServletRequest httpServletRequest) {
        Map portletPreferences;
        HttpSession session;
        HttpSession httpSession = session = httpServletRequest.getSession();
        synchronized (httpSession) {
            portletPreferences = (Map)session.getAttribute(PORTLET_PREFERENCES_MAP_ATTRIBUTE);
        }
        if (portletPreferences == null) {
            return null;
        }
        return (List)portletPreferences.get(portletEntityId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void storeSessionPreferences(IPortletEntityId portletEntityId, HttpServletRequest httpServletRequest, List<IPortletPreference> preferences) {
        ConcurrentHashMap<IPortletEntityId, List<IPortletPreference>> portletPreferences;
        HttpSession session;
        HttpSession httpSession = session = httpServletRequest.getSession();
        synchronized (httpSession) {
            portletPreferences = (ConcurrentHashMap<IPortletEntityId, List<IPortletPreference>>)session.getAttribute(PORTLET_PREFERENCES_MAP_ATTRIBUTE);
            if (portletPreferences == null) {
                portletPreferences = new ConcurrentHashMap<IPortletEntityId, List<IPortletPreference>>();
                session.setAttribute(PORTLET_PREFERENCES_MAP_ATTRIBUTE, portletPreferences);
            }
        }
        portletPreferences.put(portletEntityId, preferences);
    }
}

