/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.portlet.dao.jpa;

import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToOne;
import javax.persistence.PostLoad;
import javax.persistence.PostPersist;
import javax.persistence.PostRemove;
import javax.persistence.PostUpdate;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Table;
import org.jasig.portal.portlet.dao.jpa.PortletDefinitionImpl;
import org.jasig.portal.portlet.dao.jpa.PortletEntityIdImpl;
import org.jasig.portal.portlet.dao.jpa.PortletPreferencesImpl;
import org.jasig.portal.portlet.om.IPortletDefinition;
import org.jasig.portal.portlet.om.IPortletDefinitionId;
import org.jasig.portal.portlet.om.IPortletEntity;
import org.jasig.portal.portlet.om.IPortletEntityId;
import org.jasig.portal.portlet.om.IPortletPreferences;

@Entity
@javax.persistence.Table(name="UP_PORTLET_ENT", uniqueConstraints={@UniqueConstraint(columnNames={"CHANNEL_SUB_ID", "USER_ID"})})
@Table(appliesTo="UP_PORTLET_ENT", indexes={@Index(name="IDX_PORT_END__USR_CHAN_SUB", columnNames={"CHANNEL_SUB_ID", "USER_ID"})})
@GenericGenerator(name="UP_PORTLET_ENT_GEN", strategy="native", parameters={@Parameter(name="sequence", value="UP_PORTLET_ENT_SEQ"), @Parameter(name="table", value="UP_JPA_UNIQUE_KEY"), @Parameter(name="column", value="NEXT_UP_PORTLET_ENT_HI")})
class PortletEntityImpl
implements IPortletEntity {
    @Id
    @GeneratedValue(generator="UP_PORTLET_ENT_GEN")
    @Column(name="PORTLET_ENT_ID")
    private final long internalPortletEntityId;
    @Column(name="CHANNEL_SUB_ID", nullable=false, updatable=false)
    private final String channelSubscribeId;
    @Column(name="USER_ID", nullable=false, updatable=false)
    private final int userId;
    @ManyToOne(targetEntity=PortletDefinitionImpl.class, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    @JoinColumn(name="PORTLET_DEF_ID", nullable=false)
    private final IPortletDefinition portletDefinition;
    @OneToOne(targetEntity=PortletPreferencesImpl.class, cascade={CascadeType.ALL})
    @JoinColumn(name="PORTLET_PREFS_ID", nullable=false)
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    private IPortletPreferences portletPreferences = null;
    @Transient
    private IPortletEntityId portletEntityId = null;

    @PostLoad
    @PostPersist
    @PostUpdate
    @PostRemove
    private void init() {
        this.portletEntityId = new PortletEntityIdImpl(this.internalPortletEntityId);
    }

    private PortletEntityImpl() {
        this.internalPortletEntityId = -1L;
        this.portletDefinition = null;
        this.channelSubscribeId = null;
        this.userId = -1;
        this.portletPreferences = null;
    }

    public PortletEntityImpl(IPortletDefinition portletDefinition, String channelSubscribeId, int userId) {
        Validate.notNull((Object)portletDefinition, (String)"portletDefinition can not be null");
        Validate.notNull((Object)channelSubscribeId, (String)"channelSubscribeId can not be null");
        this.internalPortletEntityId = -1L;
        this.portletDefinition = portletDefinition;
        this.channelSubscribeId = channelSubscribeId;
        this.userId = userId;
        this.portletPreferences = new PortletPreferencesImpl();
    }

    @Override
    public IPortletEntityId getPortletEntityId() {
        return this.portletEntityId;
    }

    @Override
    public IPortletDefinitionId getPortletDefinitionId() {
        return this.portletDefinition.getPortletDefinitionId();
    }

    @Override
    public String getChannelSubscribeId() {
        return this.channelSubscribeId;
    }

    @Override
    public int getUserId() {
        return this.userId;
    }

    @Override
    public IPortletPreferences getPortletPreferences() {
        return this.portletPreferences;
    }

    @Override
    public void setPortletPreferences(IPortletPreferences portletPreferences) {
        Validate.notNull((Object)portletPreferences, (String)"portletPreferences can not be null");
        this.portletPreferences = portletPreferences;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof IPortletEntity)) {
            return false;
        }
        IPortletEntity rhs = (IPortletEntity)object;
        return new EqualsBuilder().append((Object)this.channelSubscribeId, (Object)rhs.getChannelSubscribeId()).append(this.userId, rhs.getUserId()).append((Object)this.getPortletDefinitionId(), (Object)rhs.getPortletDefinitionId()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(464270933, -1074792143).append((Object)this.channelSubscribeId).append(this.userId).append((Object)this.getPortletDefinitionId()).toHashCode();
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("portletEntityId", (Object)this.portletEntityId).append("channelSubscribeId", (Object)this.channelSubscribeId).append("userId", this.userId).append("portletDefinitionId", (Object)this.getPortletDefinitionId()).toString();
    }
}

