/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.portlet.url;

import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.portlet.PortletMode;
import javax.portlet.PortletSecurityException;
import javax.portlet.WindowState;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pluto.spi.PortletURLProvider;
import org.jasig.portal.portlet.om.IPortletWindow;
import org.jasig.portal.portlet.url.IPortletUrlSyntaxProvider;
import org.jasig.portal.portlet.url.PortletUrl;
import org.jasig.portal.portlet.url.RequestType;

public class PortletURLProviderImpl
implements PortletURLProvider {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final IPortletWindow portletWindow;
    private final HttpServletRequest httpServletRequest;
    private final IPortletUrlSyntaxProvider portletUrlSyntaxProvider;
    private final PortletUrl portletUrl;

    public PortletURLProviderImpl(IPortletWindow portletWindow, HttpServletRequest httpServletRequest, IPortletUrlSyntaxProvider portletUrlSyntaxProvider) {
        Validate.notNull((Object)portletWindow, (String)"portletWindow can not be null");
        Validate.notNull((Object)httpServletRequest, (String)"httpServletRequest can not be null");
        Validate.notNull((Object)portletUrlSyntaxProvider, (String)"portletUrlSyntaxProvider can not be null");
        this.portletWindow = portletWindow;
        this.httpServletRequest = httpServletRequest;
        this.portletUrlSyntaxProvider = portletUrlSyntaxProvider;
        this.portletUrl = new PortletUrl(this.portletWindow.getPortletWindowId());
        this.portletUrl.setParameters(new HashMap<String, List<String>>());
        this.portletUrl.setRequestType(RequestType.RENDER);
    }

    public void clearParameters() {
        this.portletUrl.getParameters().clear();
    }

    public boolean isSecureSupported() {
        return this.httpServletRequest.isSecure();
    }

    public void setSecure() throws PortletSecurityException {
        if (!this.httpServletRequest.isSecure()) {
            throw new PortletSecurityException("Secure URLs are not supported at this time");
        }
    }

    public void setAction(boolean action) {
        if (action) {
            this.portletUrl.setRequestType(RequestType.ACTION);
        } else {
            this.portletUrl.setRequestType(RequestType.RENDER);
        }
    }

    public void setParameters(Map parameters) {
        LinkedHashMap<String, List<String>> listParameters = new LinkedHashMap<String, List<String>>();
        for (Map.Entry parameterEntry : parameters.entrySet()) {
            String name = (String)parameterEntry.getKey();
            String[] values = (String[])parameterEntry.getValue();
            if (values == null) {
                listParameters.put(name, null);
                continue;
            }
            listParameters.put(name, Arrays.asList(values));
        }
        this.portletUrl.setParameters(listParameters);
    }

    public void setPortletMode(PortletMode mode) {
        if (!this.portletWindow.getPortletMode().equals((Object)mode)) {
            this.portletUrl.setPortletMode(mode);
        }
    }

    public void setWindowState(WindowState state) {
        if (!this.portletWindow.getWindowState().equals((Object)state)) {
            this.portletUrl.setWindowState(state);
        }
    }

    public String toString() {
        return this.portletUrlSyntaxProvider.generatePortletUrl(this.httpServletRequest, this.portletWindow, this.portletUrl);
    }
}

