/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.portlets.localization;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import org.jasig.portal.IUserPreferencesManager;
import org.jasig.portal.PortalException;
import org.jasig.portal.i18n.LocaleManager;
import org.jasig.portal.portlets.localization.LocaleBean;
import org.jasig.portal.user.IUserInstance;
import org.jasig.portal.user.IUserInstanceManager;

public class UserLocaleHelper {
    private IUserInstanceManager userInstanceManager;

    public void setUserInstanceManager(IUserInstanceManager userInstanceManager) {
        this.userInstanceManager = userInstanceManager;
    }

    public List<LocaleBean> getLocales(Locale currentLocale) {
        Locale[] portalLocales;
        ArrayList<LocaleBean> locales = new ArrayList<LocaleBean>();
        for (Locale locale : portalLocales = this.getPortalLocales()) {
            if (currentLocale != null) {
                locales.add(new LocaleBean(locale, currentLocale));
                continue;
            }
            locales.add(new LocaleBean(locale));
        }
        return locales;
    }

    public Locale getCurrentUserLocale(HttpServletRequest request) {
        IUserInstance ui = this.userInstanceManager.getUserInstance(request);
        IUserPreferencesManager upm = ui.getPreferencesManager();
        LocaleManager localeManager = upm.getUserPreferences().getProfile().getLocaleManager();
        Locale[] sessionLocales = localeManager.getSessionLocales();
        if (sessionLocales != null && sessionLocales.length > 0) {
            return sessionLocales[0];
        }
        Locale[] userLocales = localeManager.getUserLocales();
        if (userLocales != null && userLocales.length > 0) {
            return userLocales[0];
        }
        return null;
    }

    public void updateUserLocale(HttpServletRequest request, String localeString) {
        IUserInstance ui = this.userInstanceManager.getUserInstance(request);
        IUserPreferencesManager upm = ui.getPreferencesManager();
        LocaleManager localeManager = upm.getUserPreferences().getProfile().getLocaleManager();
        if (localeString != null) {
            Locale userLocale = this.parseLocale(localeString);
            Locale[] locales = new Locale[]{userLocale};
            localeManager.setSessionLocales(locales);
            if (!ui.getPerson().isGuest()) {
                try {
                    localeManager.persistUserLocales(new Locale[]{userLocale});
                    upm.getUserLayoutManager().loadUserLayout();
                }
                catch (Exception e) {
                    throw new PortalException(e);
                }
            }
        }
    }

    protected Locale[] getPortalLocales() {
        return LocaleManager.getPortalLocales();
    }

    protected Locale parseLocale(String localeString) {
        return LocaleManager.parseLocale(localeString);
    }
}

