/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.portlets.portletadmin.xmlsupport;

import com.thoughtworks.xstream.XStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.IChannelRegistryStore;
import org.jasig.portal.channel.IChannelType;
import org.jasig.portal.portlets.portletadmin.xmlsupport.CPDParameterList;
import org.jasig.portal.portlets.portletadmin.xmlsupport.CPDStep;
import org.jasig.portal.portlets.portletadmin.xmlsupport.ChannelPublishingDefinition;
import org.jasig.portal.portlets.portletadmin.xmlsupport.IChannelPublishingDefinitionDao;
import org.jasig.portal.utils.threading.MapCachingDoubleCheckedCreator;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;

public class XmlChannelPublishingDefinitionDao
implements IChannelPublishingDefinitionDao,
ResourceLoaderAware,
InitializingBean {
    private static final String CUSTOM_CPD_PATH = "/org/jasig/portal/portlets/portletadmin/CustomChannel.cpd";
    private static final String SHARED_PARAMETERS_PATH = "/org/jasig/portal/channels/SharedParameters.cpd";
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final XStream channelPublishingDefinitionParser = new XStream();
    private MapCachingDoubleCheckedCreator<Integer, ChannelPublishingDefinition> cpdCreator;
    private CPDParameterList sharedParameters;
    private Map<Integer, ChannelPublishingDefinition> cpdCache;
    private IChannelRegistryStore channelRegistryStore;
    private ResourceLoader resourceLoader;

    public XmlChannelPublishingDefinitionDao() {
        this.channelPublishingDefinitionParser.processAnnotations(new Class[]{ChannelPublishingDefinition.class, CPDParameterList.class});
    }

    public void setCpdCache(Map<Integer, ChannelPublishingDefinition> cpdCache) {
        this.cpdCache = cpdCache;
    }

    public void setChannelRegistryStore(IChannelRegistryStore channelRegistryStore) {
        this.channelRegistryStore = channelRegistryStore;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public void afterPropertiesSet() throws Exception {
        this.cpdCreator = new CpdCreator(this.cpdCache);
    }

    @Override
    public ChannelPublishingDefinition getChannelPublishingDefinition(int channelTypeId) {
        return (ChannelPublishingDefinition)this.cpdCreator.get(channelTypeId);
    }

    @Override
    public Map<IChannelType, ChannelPublishingDefinition> getChannelPublishingDefinitions() {
        List<IChannelType> channelTypes = this.channelRegistryStore.getChannelTypes();
        LinkedHashMap<IChannelType, ChannelPublishingDefinition> cpds = new LinkedHashMap<IChannelType, ChannelPublishingDefinition>(channelTypes.size());
        for (IChannelType channelType : channelTypes) {
            ChannelPublishingDefinition cpd = this.getChannelPublishingDefinition(channelType.getId());
            cpds.put(channelType, cpd);
        }
        return cpds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ChannelPublishingDefinition loadChannelPublishingDefinition(int channelTypeId) {
        ChannelPublishingDefinition def;
        InputStream cpdStream;
        String cpdUri;
        if (channelTypeId >= 0) {
            IChannelType type = this.channelRegistryStore.getChannelType(channelTypeId);
            if (type == null) {
                throw new IllegalArgumentException("No ChannelType registered with id: " + channelTypeId);
            }
            cpdUri = type.getCpdUri();
        } else {
            cpdUri = CUSTOM_CPD_PATH;
        }
        Resource cpdResource = this.resourceLoader.getResource("classpath:" + cpdUri);
        if (!cpdResource.exists()) {
            throw new MissingResourceException("Failed to find CPD '" + cpdUri + "' for channel type " + channelTypeId, this.getClass().getName(), cpdUri);
        }
        try {
            cpdStream = cpdResource.getInputStream();
        }
        catch (IOException e) {
            throw new MissingResourceException("Failed to load CPD '" + cpdUri + "' for channel type " + channelTypeId, this.getClass().getName(), cpdUri);
        }
        try {
            def = (ChannelPublishingDefinition)this.channelPublishingDefinitionParser.fromXML(cpdStream);
        }
        finally {
            IOUtils.closeQuietly((InputStream)cpdStream);
        }
        CPDParameterList sharedParameters = this.getSharedParameters();
        CPDParameterList params = def.getParams();
        List<CPDStep> steps = params.getSteps();
        int stepId = steps.size();
        for (CPDStep step : sharedParameters.getSteps()) {
            stepId = stepId++;
            step.setId(String.valueOf(stepId));
        }
        steps.addAll(sharedParameters.getSteps());
        this.cpdCache.put(channelTypeId, def);
        return def;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CPDParameterList getSharedParameters() {
        InputStream paramStream;
        if (this.sharedParameters != null) {
            return this.sharedParameters;
        }
        Resource paramResource = this.resourceLoader.getResource("classpath:/org/jasig/portal/channels/SharedParameters.cpd");
        if (!paramResource.exists()) {
            throw new MissingResourceException("Failed to find shared parameters CPD '/org/jasig/portal/channels/SharedParameters.cpd'", this.getClass().getName(), SHARED_PARAMETERS_PATH);
        }
        try {
            paramStream = paramResource.getInputStream();
        }
        catch (IOException e) {
            throw new MissingResourceException("Failed to load CPD '/org/jasig/portal/channels/SharedParameters.cpd'", this.getClass().getName(), SHARED_PARAMETERS_PATH);
        }
        try {
            this.sharedParameters = (CPDParameterList)this.channelPublishingDefinitionParser.fromXML(paramStream);
        }
        finally {
            IOUtils.closeQuietly((InputStream)paramStream);
        }
        return this.sharedParameters;
    }

    private class CpdCreator
    extends MapCachingDoubleCheckedCreator<Integer, ChannelPublishingDefinition> {
        public CpdCreator(Map<Integer, ChannelPublishingDefinition> cache) {
            super(cache);
        }

        @Override
        protected ChannelPublishingDefinition createInternal(Integer key, Object ... args) {
            return XmlChannelPublishingDefinitionDao.this.loadChannelPublishingDefinition(key);
        }

        @Override
        protected Integer getKey(Object ... args) {
            return (Integer)args[0];
        }
    }
}

