/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.portlets.registerportal;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.jasig.portal.portlets.registerportal.IPortalDataCollator;
import org.jasig.portal.portlets.registerportal.IPortalDataCollector;

public class PortalDataCollatorImpl
implements IPortalDataCollator {
    private Map<String, IPortalDataCollector> dataCollectors = Collections.emptyMap();

    public void setCollectors(Collection<IPortalDataCollector> collectors) {
        if (collectors == null || collectors.isEmpty()) {
            this.dataCollectors = Collections.emptyMap();
        } else {
            LinkedHashMap<String, IPortalDataCollector> dataCollectors = new LinkedHashMap<String, IPortalDataCollector>();
            for (IPortalDataCollector dataCollector : collectors) {
                dataCollectors.put(dataCollector.getKey(), dataCollector);
            }
            this.dataCollectors = dataCollectors;
        }
    }

    @Override
    public Map<String, Map<String, String>> getCollectedData() {
        return this.getCollectedData(this.dataCollectors.keySet());
    }

    @Override
    public Map<String, Map<String, String>> getCollectedData(Set<String> keysToCollect) {
        LinkedHashMap<String, Map<String, String>> collectedData = new LinkedHashMap<String, Map<String, String>>();
        for (String dataKey : keysToCollect) {
            IPortalDataCollector portalDataCollector = this.dataCollectors.get(dataKey);
            Map<String, String> data = portalDataCollector.getData();
            collectedData.put(dataKey, data);
        }
        return collectedData;
    }

    @Override
    public Set<String> getPossibleDataKeys() {
        return this.dataCollectors.keySet();
    }
}

