/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.portlets.registerportal;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.portlets.registerportal.IPortalDataCollator;
import org.jasig.portal.portlets.registerportal.IPortalDataSubmitter;
import org.jasig.portal.portlets.registerportal.PortalRegistrationData;
import org.jasig.portal.portlets.registerportal.PortalRegistrationRequest;

public class PortalRegistrationHelper {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private IPortalDataCollator portalDataCollator;
    private IPortalDataSubmitter portalDataSubmitter;

    public void setPortalDataCollator(IPortalDataCollator portalDataCollator) {
        this.portalDataCollator = portalDataCollator;
    }

    public void setPortalDataSubmitter(IPortalDataSubmitter portalDataSubmitter) {
        this.portalDataSubmitter = portalDataSubmitter;
    }

    public PortalRegistrationRequest createRegistrationRequest() {
        LinkedHashMap<String, String> dataToSubmit = new LinkedHashMap<String, String>();
        Set<String> possibleDataKeys = this.portalDataCollator.getPossibleDataKeys();
        for (String possibleDataKey : possibleDataKeys) {
            dataToSubmit.put(possibleDataKey, Boolean.TRUE.toString());
        }
        PortalRegistrationRequest registrationRequest = new PortalRegistrationRequest();
        registrationRequest.setDataToSubmit(dataToSubmit);
        return registrationRequest;
    }

    public PortalRegistrationData getRegistrationData(PortalRegistrationRequest registrationRequest) {
        this.logger.debug((Object)registrationRequest);
        PortalRegistrationData registrationData = new PortalRegistrationData(registrationRequest);
        LinkedHashSet<String> dataToCollect = new LinkedHashSet<String>();
        Map<String, String> dataToSubmit = registrationRequest.getDataToSubmit();
        for (Map.Entry<String, String> dataToSubmitEntry : dataToSubmit.entrySet()) {
            if (!Boolean.parseBoolean(dataToSubmitEntry.getValue())) continue;
            dataToCollect.add(dataToSubmitEntry.getKey());
        }
        Map<String, Map<String, String>> collectedData = this.portalDataCollator.getCollectedData(dataToCollect);
        registrationData.setCollectedData(collectedData);
        return registrationData;
    }

    public boolean submitRegistration(PortalRegistrationData portalRegistrationData) {
        this.logger.debug((Object)portalRegistrationData);
        return this.portalDataSubmitter.submitPortalData(portalRegistrationData);
    }
}

