/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.portlets.swapper;

import java.util.Map;
import java.util.Set;
import org.jasig.portal.portlets.Attribute;
import org.jasig.portal.portlets.swapper.AttributeSwapRequest;
import org.jasig.portal.portlets.swapper.IAttributeSwapperHelper;
import org.springframework.binding.message.MessageBuilder;
import org.springframework.binding.message.MessageContext;
import org.springframework.binding.message.MessageResolver;
import org.springframework.webflow.context.ExternalContext;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.execution.RequestContextHolder;

public class AttributeSwapRequestValidator {
    private IAttributeSwapperHelper attributeSwapperHelper;

    public IAttributeSwapperHelper getAttributeSwapperHelper() {
        return this.attributeSwapperHelper;
    }

    public void setAttributeSwapperHelper(IAttributeSwapperHelper attributeSwapperHelper) {
        this.attributeSwapperHelper = attributeSwapperHelper;
    }

    public void validateAttributesForm(AttributeSwapRequest attributeSwapRequest, MessageContext context) {
        RequestContext requestContext = RequestContextHolder.getRequestContext();
        ExternalContext externalContext = requestContext.getExternalContext();
        Set<String> swappableAttributes = this.attributeSwapperHelper.getSwappableAttributes(externalContext);
        Map<String, Attribute> currentAttributes = attributeSwapRequest.getCurrentAttributes();
        this.checkAttributesMap(context, "currentAttributes", swappableAttributes, currentAttributes);
        Map<String, Attribute> attributesToCopy = attributeSwapRequest.getAttributesToCopy();
        this.checkAttributesMap(context, "attributesToCopy", swappableAttributes, attributesToCopy);
    }

    protected void checkAttributesMap(MessageContext context, String basePath, Set<String> swappableAttributes, Map<String, Attribute> attributesToCopy) {
        for (String attribute : attributesToCopy.keySet()) {
            if (swappableAttributes.contains(attribute)) continue;
            MessageBuilder messageBuilder = new MessageBuilder();
            messageBuilder.error();
            messageBuilder.source((Object)(basePath + "[" + attribute + "].value"));
            messageBuilder.code("attributesForm.invalidSwapAttribute");
            messageBuilder.arg((Object)attribute);
            MessageResolver errorMessage = messageBuilder.build();
            context.addMessage(errorMessage);
        }
    }
}

