/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.properties;

import java.util.Collections;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.properties.BadPropertyException;
import org.jasig.portal.properties.MissingPropertyException;

public class PropertiesManager {
    protected static final Log log = LogFactory.getLog(PropertiesManager.class);
    public static final String PORTAL_PROPERTIES_FILE_SYSTEM_VARIABLE = "portal.properties";
    private static final String PORTAL_PROPERTIES_FILE_NAME = "/properties/portal.properties";
    private static Properties props = null;
    private static final Set missingProperties = Collections.synchronizedSet(new HashSet());

    public static synchronized void setProperties(Properties props) {
        PropertiesManager.props = props;
    }

    protected static void loadProps() {
        props = new Properties();
        try {
            String pfile = System.getProperty(PORTAL_PROPERTIES_FILE_SYSTEM_VARIABLE);
            if (pfile == null) {
                pfile = PORTAL_PROPERTIES_FILE_NAME;
            }
            props.load(PropertiesManager.class.getResourceAsStream(pfile));
        }
        catch (Throwable t) {
            log.error((Object)"Unable to read portal.properties file.", t);
        }
    }

    public static String getProperty(String name) throws MissingPropertyException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("entering getProperty(" + name + ")"));
        }
        if (props == null) {
            PropertiesManager.loadProps();
        }
        String val = PropertiesManager.getPropertyUntrimmed(name);
        val = val.trim();
        if (log.isTraceEnabled()) {
            log.trace((Object)("returning from getProperty(" + name + ") with return value [" + val + "]"));
        }
        return val;
    }

    public static String getPropertyUntrimmed(String name) throws MissingPropertyException {
        if (props == null) {
            PropertiesManager.loadProps();
        }
        if (props == null) {
            boolean alreadyReported = PropertiesManager.registerMissingProperty(name);
            throw new MissingPropertyException(name, alreadyReported);
        }
        String val = props.getProperty(name);
        if (val == null) {
            boolean alreadyReported = PropertiesManager.registerMissingProperty(name);
            throw new MissingPropertyException(name, alreadyReported);
        }
        return val;
    }

    public static boolean getPropertyAsBoolean(String name) throws MissingPropertyException {
        if (props == null) {
            PropertiesManager.loadProps();
        }
        boolean retValue = false;
        String value = PropertiesManager.getProperty(name);
        if (value != null) {
            if (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("yes") || value.equalsIgnoreCase("y") || value.equalsIgnoreCase("on")) {
                retValue = true;
            } else if (value.equalsIgnoreCase("false") || value.equalsIgnoreCase("no") || value.equalsIgnoreCase("n") || value.equalsIgnoreCase("off")) {
                retValue = false;
            } else {
                log.error((Object)("property [" + name + "] is being accessed as a boolean " + "but had non-canonical value [" + value + "].  Returning it as false, " + "but this may be a property misconfiguration."));
            }
        } else {
            log.fatal((Object)("property [" + name + "] is being accessed as a boolean " + "but was null.  Returning false.  However, it should not have been " + "possible to get here because getProperty() throws a runtime " + "exception or returns a non-null value."));
        }
        return retValue;
    }

    public static byte getPropertyAsByte(String name) throws MissingPropertyException, BadPropertyException {
        if (props == null) {
            PropertiesManager.loadProps();
        }
        try {
            return Byte.parseByte(PropertiesManager.getProperty(name));
        }
        catch (NumberFormatException nfe) {
            throw new BadPropertyException(name, PropertiesManager.getProperty(name), "byte");
        }
    }

    public static short getPropertyAsShort(String name) throws MissingPropertyException, BadPropertyException {
        if (props == null) {
            PropertiesManager.loadProps();
        }
        try {
            return Short.parseShort(PropertiesManager.getProperty(name));
        }
        catch (NumberFormatException nfe) {
            throw new BadPropertyException(name, PropertiesManager.getProperty(name), "short");
        }
    }

    public static int getPropertyAsInt(String name) throws MissingPropertyException, BadPropertyException {
        if (props == null) {
            PropertiesManager.loadProps();
        }
        try {
            return Integer.parseInt(PropertiesManager.getProperty(name));
        }
        catch (NumberFormatException nfe) {
            throw new BadPropertyException(name, PropertiesManager.getProperty(name), "int");
        }
    }

    public static long getPropertyAsLong(String name) throws MissingPropertyException, BadPropertyException {
        if (props == null) {
            PropertiesManager.loadProps();
        }
        try {
            return Long.parseLong(PropertiesManager.getProperty(name));
        }
        catch (NumberFormatException nfe) {
            throw new BadPropertyException(name, PropertiesManager.getProperty(name), "long");
        }
    }

    public static float getPropertyAsFloat(String name) throws MissingPropertyException, BadPropertyException {
        if (props == null) {
            PropertiesManager.loadProps();
        }
        try {
            return Float.parseFloat(PropertiesManager.getProperty(name));
        }
        catch (NumberFormatException nfe) {
            throw new BadPropertyException(name, PropertiesManager.getProperty(name), "float");
        }
    }

    public static double getPropertyAsDouble(String name) throws MissingPropertyException, BadPropertyException {
        if (props == null) {
            PropertiesManager.loadProps();
        }
        try {
            return Double.parseDouble(PropertiesManager.getProperty(name));
        }
        catch (NumberFormatException nfe) {
            throw new BadPropertyException(name, PropertiesManager.getProperty(name), "double");
        }
    }

    private static boolean registerMissingProperty(String name) {
        boolean previouslyReported;
        boolean bl = previouslyReported = !missingProperties.add(name);
        if (!previouslyReported && log.isInfoEnabled()) {
            log.info((Object)("Property [" + name + "] was requested but not found."));
        }
        return previouslyReported;
    }

    public static String getProperty(String name, String defaultValue) {
        if (props == null) {
            PropertiesManager.loadProps();
        }
        String returnValue = defaultValue;
        try {
            returnValue = PropertiesManager.getProperty(name);
        }
        catch (MissingPropertyException missingPropertyException) {
            // empty catch block
        }
        return returnValue;
    }

    public static String getPropertyUntrimmed(String name, String defaultValue) {
        if (props == null) {
            PropertiesManager.loadProps();
        }
        String returnValue = defaultValue;
        try {
            returnValue = PropertiesManager.getPropertyUntrimmed(name);
        }
        catch (MissingPropertyException missingPropertyException) {
            // empty catch block
        }
        return returnValue;
    }

    public static boolean getPropertyAsBoolean(String name, boolean defaultValue) {
        if (props == null) {
            PropertiesManager.loadProps();
        }
        boolean returnValue = defaultValue;
        try {
            returnValue = PropertiesManager.getPropertyAsBoolean(name);
        }
        catch (MissingPropertyException missingPropertyException) {
            // empty catch block
        }
        return returnValue;
    }

    public static byte getPropertyAsByte(String name, byte defaultValue) {
        if (props == null) {
            PropertiesManager.loadProps();
        }
        byte returnValue = defaultValue;
        try {
            returnValue = PropertiesManager.getPropertyAsByte(name);
        }
        catch (Throwable t) {
            log.error((Object)("Could not retrieve or parse as byte property [" + name + "], defaulting to [" + defaultValue + "]"), t);
        }
        return returnValue;
    }

    public static short getPropertyAsShort(String name, short defaultValue) {
        if (props == null) {
            PropertiesManager.loadProps();
        }
        short returnValue = defaultValue;
        try {
            returnValue = PropertiesManager.getPropertyAsShort(name);
        }
        catch (Throwable t) {
            log.error((Object)("Could not retrieve or parse as short property [" + name + "], defaulting to given value [" + defaultValue + "]"), t);
        }
        return returnValue;
    }

    public static int getPropertyAsInt(String name, int defaultValue) {
        if (props == null) {
            PropertiesManager.loadProps();
        }
        int returnValue = defaultValue;
        try {
            returnValue = PropertiesManager.getPropertyAsInt(name);
        }
        catch (Throwable t) {
            log.error((Object)("Could not retrieve or parse as int the property [" + name + "], defaulting to " + defaultValue), t);
        }
        return returnValue;
    }

    public static long getPropertyAsLong(String name, long defaultValue) {
        if (props == null) {
            PropertiesManager.loadProps();
        }
        long returnValue = defaultValue;
        try {
            returnValue = PropertiesManager.getPropertyAsLong(name);
        }
        catch (Throwable t) {
            log.error((Object)("Could not retrieve or parse as long property [" + name + "], defaulting to " + defaultValue), t);
        }
        return returnValue;
    }

    public static float getPropertyAsFloat(String name, float defaultValue) {
        if (props == null) {
            PropertiesManager.loadProps();
        }
        float returnValue = defaultValue;
        try {
            returnValue = PropertiesManager.getPropertyAsFloat(name);
        }
        catch (Throwable t) {
            log.error((Object)("Could not retrieve or parse as float property [" + name + "], defaulting to " + defaultValue), t);
        }
        return returnValue;
    }

    public static double getPropertyAsDouble(String name, double defaultValue) {
        if (props == null) {
            PropertiesManager.loadProps();
        }
        double returnValue = defaultValue;
        try {
            returnValue = PropertiesManager.getPropertyAsDouble(name);
        }
        catch (Throwable t) {
            log.error((Object)("Could not retrieve or parse as double property [" + name + "], defaulting to " + defaultValue), t);
        }
        return returnValue;
    }

    public static Set getMissingProperties() {
        return missingProperties;
    }
}

