/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.rendering;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.TransformerHandler;
import org.apache.commons.collections.map.ReferenceMap;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.CacheEntry;
import org.jasig.portal.CacheType;
import org.jasig.portal.ChannelContentCacheEntry;
import org.jasig.portal.ChannelManager;
import org.jasig.portal.ChannelRenderingBuffer;
import org.jasig.portal.ChannelSAXStreamFilter;
import org.jasig.portal.CharacterCachingChannelIncorporationFilter;
import org.jasig.portal.IUserPreferencesManager;
import org.jasig.portal.IWorkerRequestProcessor;
import org.jasig.portal.MediaManager;
import org.jasig.portal.PortalControlStructures;
import org.jasig.portal.PortalException;
import org.jasig.portal.StructureAttributesIncorporationFilter;
import org.jasig.portal.StructureStylesheetDescription;
import org.jasig.portal.StructureStylesheetUserPreferences;
import org.jasig.portal.ThemeAttributesIncorporationFilter;
import org.jasig.portal.ThemeStylesheetDescription;
import org.jasig.portal.UPFileSpec;
import org.jasig.portal.UserInstance;
import org.jasig.portal.UserPreferences;
import org.jasig.portal.UserProfile;
import org.jasig.portal.car.CarResources;
import org.jasig.portal.events.support.PageRenderTimePortalEvent;
import org.jasig.portal.i18n.LocaleManager;
import org.jasig.portal.io.ChannelTitleIncorporationWiterFilter;
import org.jasig.portal.layout.IUserLayoutManager;
import org.jasig.portal.layout.node.IUserLayoutFolderDescription;
import org.jasig.portal.layout.node.IUserLayoutNodeDescription;
import org.jasig.portal.portlet.om.IPortletEntity;
import org.jasig.portal.portlet.om.IPortletWindowId;
import org.jasig.portal.portlet.registry.IPortletWindowRegistry;
import org.jasig.portal.portlet.url.IPortletRequestParameterManager;
import org.jasig.portal.portlet.url.PortletUrl;
import org.jasig.portal.portlet.url.RequestType;
import org.jasig.portal.properties.PropertiesManager;
import org.jasig.portal.rendering.IPortalRenderingPipeline;
import org.jasig.portal.security.IPerson;
import org.jasig.portal.serialize.BaseMarkupSerializer;
import org.jasig.portal.serialize.CachingSerializer;
import org.jasig.portal.serialize.DebugCachingSerializer;
import org.jasig.portal.serialize.OutputFormat;
import org.jasig.portal.serialize.XMLSerializer;
import org.jasig.portal.tools.versioning.Version;
import org.jasig.portal.tools.versioning.VersionsManager;
import org.jasig.portal.user.IUserInstance;
import org.jasig.portal.utils.MovingAverage;
import org.jasig.portal.utils.MovingAverageSample;
import org.jasig.portal.utils.ResourceLoader;
import org.jasig.portal.utils.SAX2BufferImpl;
import org.jasig.portal.utils.SAX2DuplicatingFilterImpl;
import org.jasig.portal.utils.URLUtil;
import org.jasig.portal.utils.XSLT;
import org.jasig.portal.web.skin.ResourcesXalanElements;
import org.jasig.resource.aggr.util.ResourcesElementsProvider;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.xml.sax.ContentHandler;
import org.xml.sax.helpers.AttributesImpl;

public class StaticRenderingPipeline
implements IPortalRenderingPipeline,
ApplicationEventPublisherAware,
InitializingBean {
    private static final MovingAverage renderTimes = new MovingAverage();
    private static volatile MovingAverageSample lastRender = new MovingAverageSample();
    private static final boolean logXMLBeforeStructureTransformation = PropertiesManager.getPropertyAsBoolean("org.jasig.portal.UserInstance.log_xml_before_structure_transformation");
    private static final boolean logXMLBeforeThemeTransformation = PropertiesManager.getPropertyAsBoolean("org.jasig.portal.UserInstance.log_xml_before_theme_transformation");
    private static final boolean CACHE_ENABLED = PropertiesManager.getPropertyAsBoolean("org.jasig.portal.UserInstance.cache_enabled");
    private static final boolean CHARACTER_CACHE_ENABLED = PropertiesManager.getPropertyAsBoolean("org.jasig.portal.UserInstance.character_cache_enabled");
    private static final int SYSTEM_XSLT_CACHE_MIN_SIZE = PropertiesManager.getPropertyAsInt("org.jasig.portal.UserInstance.system_xslt_cache_min_size");
    private static final int SYSTEM_CHARACTER_BLOCK_CACHE_MIN_SIZE = PropertiesManager.getPropertyAsInt("org.jasig.portal.UserInstance.system_character_block_cache_min_size");
    private static final Map<String, SAX2BufferImpl> systemCache = Collections.synchronizedMap(new ReferenceMap(0, 1, SYSTEM_XSLT_CACHE_MIN_SIZE, 0.75f, true));
    private static final Map<String, List<CacheEntry>> systemCharacterCache = Collections.synchronizedMap(new ReferenceMap(0, 1, SYSTEM_CHARACTER_BLOCK_CACHE_MIN_SIZE, 0.75f, true));
    private static final TransformErrorListener cErrListener = new TransformErrorListener();
    private static final String WORKER_PROPERTIES_FILE_NAME = "/properties/worker.properties";
    private static final Properties workerProperties;
    private static final MediaManager MEDIA_MANAGER;
    private static final String CHARACTER_SET = "UTF-8";
    private static final String SECURITY_PROPERTIES_FILE_NAME = "/properties/security.properties";
    private static final String CAS_LOGIN_URL_PROPERTY = "org.jasig.portal.channels.CLogin.CasLoginUrl";
    private static String externalLoginUrl;
    protected final Log log = LogFactory.getLog(this.getClass());
    private IPortletRequestParameterManager portletRequestParameterManager;
    private IPortletWindowRegistry portletWindowRegistry;
    private ApplicationEventPublisher applicationEventPublisher;
    private CarResources carResources;
    private ResourcesElementsProvider resourcesElementsProvider;

    public static MovingAverageSample getLastRenderSample() {
        return lastRender;
    }

    public IPortletRequestParameterManager getPortletRequestParameterManager() {
        return this.portletRequestParameterManager;
    }

    @Required
    public void setPortletRequestParameterManager(IPortletRequestParameterManager portletRequestParameterManager) {
        Validate.notNull((Object)portletRequestParameterManager, (String)"portletRequestParameterManager can not be null");
        this.portletRequestParameterManager = portletRequestParameterManager;
    }

    public IPortletWindowRegistry getPortletWindowRegistry() {
        return this.portletWindowRegistry;
    }

    @Required
    public void setPortletWindowRegistry(IPortletWindowRegistry portletWindowRegistry) {
        Validate.notNull((Object)portletWindowRegistry, (String)"portletWindowRegistry can not be null");
        this.portletWindowRegistry = portletWindowRegistry;
    }

    public CarResources getCarResources() {
        return this.carResources;
    }

    @Required
    public void setCarResources(CarResources carResources) {
        this.carResources = carResources;
    }

    @Required
    public void setResourcesElementsProvider(ResourcesElementsProvider resourcesElementsProvider) {
        this.resourcesElementsProvider = resourcesElementsProvider;
    }

    public void afterPropertiesSet() throws Exception {
        this.carResources.getWorkers(workerProperties);
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void renderState(HttpServletRequest req, HttpServletResponse res, IUserInstance userInstance) throws PortalException {
        String channelSubscribeId;
        boolean actionExecuted;
        IPortletEntity targetedPortletEntity;
        PortletUrl portletUrl;
        IPerson person = userInstance.getPerson();
        LocaleManager localeManager = userInstance.getLocaleManager();
        IUserPreferencesManager uPreferencesManager = userInstance.getPreferencesManager();
        ChannelManager channelManager = userInstance.getChannelManager();
        Object renderingLock = userInstance.getRenderingLock();
        UPFileSpec upfs = new UPFileSpec(req);
        String rootNodeId = upfs.getMethodNodeId();
        if (rootNodeId == null) {
            rootNodeId = "userLayoutRootNode";
        }
        String newRootNodeId = req.getParameter("uP_detach_target");
        UPFileSpec uPElement = new UPFileSpec(0, rootNodeId, null, null);
        if (newRootNodeId != null) {
            uPElement.setMethodNodeId(newRootNodeId);
        }
        channelManager.setUPElement(uPElement);
        IPortletWindowId targetedPortletWindowId = this.portletRequestParameterManager.getTargetedPortletWindowId(req);
        if (targetedPortletWindowId != null && RequestType.ACTION.equals((Object)(portletUrl = this.portletRequestParameterManager.getPortletRequestInfo(req, targetedPortletWindowId)).getRequestType()) && (targetedPortletEntity = this.portletWindowRegistry.getParentPortletEntity(req, targetedPortletWindowId)) != null && (actionExecuted = channelManager.doChannelAction(req, res, channelSubscribeId = targetedPortletEntity.getChannelSubscribeId(), false))) {
            return;
        }
        boolean workerDispatched = this.processWorkerDispatchIfNecessary(req, res, uPreferencesManager, channelManager);
        if (workerDispatched) {
            return;
        }
        res.setBufferSize(16384);
        long startTime = System.currentTimeMillis();
        Object object = renderingLock;
        synchronized (object) {
            try {
                IUserLayoutNodeDescription rElement = null;
                channelManager.setLocaleManager(localeManager);
                IUserLayoutManager ulm = uPreferencesManager.getUserLayoutManager();
                channelManager.startRenderingCycle(req, res, uPElement);
                UserPreferences userPreferences = uPreferencesManager.getUserPreferences();
                StructureStylesheetDescription ssd = uPreferencesManager.getStructureStylesheetDescription();
                ThemeStylesheetDescription tsd = uPreferencesManager.getThemeStylesheetDescription();
                if (newRootNodeId != null && !newRootNodeId.equals(rootNodeId)) {
                    try {
                        rElement = ulm.getNode(newRootNodeId);
                    }
                    catch (PortalException e) {
                        rElement = null;
                    }
                    if (rElement != null) {
                        String[] skipParams = new String[]{"uP_detach_target"};
                        try {
                            URLUtil.redirect(req, res, newRootNodeId, true, skipParams, CHARACTER_SET);
                        }
                        catch (PortalException pe) {
                            this.log.error((Object)"PortalException occurred while redirecting", (Throwable)pe);
                        }
                        return;
                    }
                }
                try {
                    rElement = ulm.getNode(rootNodeId);
                }
                catch (PortalException e) {
                    rElement = null;
                }
                if (rElement == null) {
                    rootNodeId = "userLayoutRootNode";
                }
                uPElement.setMethodNodeId(rootNodeId);
                channelManager.setUPElement(uPElement);
                res.setBufferSize(16384);
                res.setHeader("pragma", "no-cache");
                res.setHeader("Cache-Control", "no-cache, max-age=0, must-revalidate");
                res.setDateHeader("Expires", 0L);
                res.setContentType(tsd.getMimeType() + "; charset=" + CHARACTER_SET);
                BufferedWriter out = new BufferedWriter(res.getWriter(), 1024);
                BaseMarkupSerializer markupSerializer = MEDIA_MANAGER.getSerializerByName(tsd.getSerializerName(), new ChannelTitleIncorporationWiterFilter(out, channelManager, ulm));
                markupSerializer.asContentHandler();
                boolean ccaching = CHARACTER_CACHE_ENABLED && markupSerializer instanceof CachingSerializer;
                channelManager.setCharacterCaching(ccaching);
                channelManager.setSerializerName(tsd.getSerializerName());
                CharacterCachingChannelIncorporationFilter cif = new CharacterCachingChannelIncorporationFilter((ContentHandler)markupSerializer, channelManager, CACHE_ENABLED && CHARACTER_CACHE_ENABLED, req, res);
                String cacheKey = null;
                boolean output_produced = false;
                if (CACHE_ENABLED) {
                    SAX2BufferImpl cachedBuffer;
                    List<CacheEntry> cacheEntries;
                    boolean ccache_exists = false;
                    cacheKey = this.constructCacheKey(uPreferencesManager, rootNodeId);
                    if (ccaching && (cacheEntries = systemCharacterCache.get(cacheKey)) != null && cacheEntries.size() > 0) {
                        ccache_exists = true;
                        if (this.log.isDebugEnabled()) {
                            this.log.debug((Object)("retreived transformation character block cache for a key \"" + cacheKey + "\""));
                        }
                        for (int i = 0; i < cacheEntries.size(); ++i) {
                            CacheEntry ce = cacheEntries.get(i);
                            if (!ce.getCacheType().equals((Object)CacheType.CHANNEL_CONTENT)) continue;
                            String channelSubscribeId2 = ((ChannelContentCacheEntry)ce).getChannelId();
                            if (channelSubscribeId2 != null) {
                                try {
                                    channelManager.startChannelRendering(req, res, channelSubscribeId2);
                                }
                                catch (PortalException e) {
                                    this.log.error((Object)("UserInstance::renderState() : unable to start rendering channel (subscribeId=\"" + channelSubscribeId2 + "\", user=" + person.getID() + " layoutId=" + uPreferencesManager.getCurrentProfile().getLayoutId()), (Throwable)e);
                                }
                                continue;
                            }
                            this.log.error((Object)("channel entry " + Integer.toString(i) + " in character cache is invalid (user=" + person.getID() + ")!"));
                        }
                        channelManager.commitToRenderingChannelSet();
                        CachingSerializer cSerializer = (CachingSerializer)((Object)markupSerializer);
                        cSerializer.setDocumentStarted(true);
                        for (int sb = 0; sb < cacheEntries.size(); ++sb) {
                            CacheEntry ce = cacheEntries.get(sb);
                            if (this.log.isDebugEnabled()) {
                                DebugCachingSerializer dcs = new DebugCachingSerializer();
                                this.log.debug((Object)("----------printing " + (Object)((Object)ce.getCacheType()) + " cache block " + Integer.toString(sb)));
                                ce.replayCache(dcs, channelManager, req, res);
                                this.log.debug((Object)dcs.getCache());
                            }
                            ce.replayCache(cSerializer, channelManager, req, res);
                        }
                        cSerializer.flush();
                        output_produced = true;
                    }
                    if (!(ccaching && ccache_exists || (cachedBuffer = systemCache.get(cacheKey)) == null)) {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug((Object)("retreived XSLT transformation cache for a key '" + cacheKey + "'"));
                        }
                        ChannelRenderingBuffer crb = new ChannelRenderingBuffer(cachedBuffer, channelManager, ccaching, req, res);
                        cif.setParent(crb);
                        crb.setOutputAtDocumentEnd(true);
                        cachedBuffer.outputBuffer(crb);
                        output_produced = true;
                    }
                }
                if (!output_produced) {
                    Version[] versions;
                    boolean detachMode;
                    TransformerHandler ssth = XSLT.getTransformerHandler(ResourceLoader.getResourceAsURL(this.getClass(), ssd.getStylesheetURI()).toString());
                    TransformerHandler tsth = XSLT.getTransformerHandler(tsd.getStylesheetURI(), localeManager.getLocales(), this);
                    Transformer sst = ssth.getTransformer();
                    sst.setErrorListener(cErrListener);
                    Transformer tst = tsth.getTransformer();
                    tst.setErrorListener(cErrListener);
                    tst.setParameter(ResourcesXalanElements.SKIN_RESOURCESDAO_PARAMETER_NAME, this.resourcesElementsProvider);
                    tst.setParameter(ResourcesXalanElements.CURRENT_REQUEST, req);
                    ChannelRenderingBuffer crb = new ChannelRenderingBuffer(channelManager, ccaching, req, res);
                    ssth.setResult(new SAXResult(crb));
                    sst.setParameter("baseActionURL", uPElement.getUPFile());
                    UPFileSpec uPIdempotentElement = new UPFileSpec(uPElement);
                    sst.setParameter("baseIdempotentActionURL", uPElement.getUPFile());
                    Hashtable<String, String> supTable = userPreferences.getStructureStylesheetUserPreferences().getParameterValues();
                    for (Map.Entry<String, String> param : supTable.entrySet()) {
                        String pName = param.getKey();
                        String pValue = param.getValue();
                        if (this.log.isDebugEnabled()) {
                            this.log.debug((Object)("setting sparam \"" + pName + "\"=\"" + pValue + "\"."));
                        }
                        sst.setParameter(pName, pValue);
                    }
                    StructureAttributesIncorporationFilter saif = new StructureAttributesIncorporationFilter(ssth, userPreferences.getStructureStylesheetUserPreferences());
                    StringWriter dbwr1 = null;
                    OutputFormat outputFormat = null;
                    if (logXMLBeforeStructureTransformation && this.log.isDebugEnabled()) {
                        dbwr1 = new StringWriter();
                        outputFormat = new OutputFormat();
                        outputFormat.setIndenting(true);
                        XMLSerializer dbser1 = new XMLSerializer(dbwr1, outputFormat);
                        SAX2DuplicatingFilterImpl dupl1 = new SAX2DuplicatingFilterImpl(ssth, dbser1);
                        dupl1.setParent(saif);
                    }
                    boolean bl = detachMode = !rootNodeId.equals("userLayoutRootNode");
                    if (detachMode) {
                        saif.startDocument();
                        saif.startElement("", "layout_fragment", "layout_fragment", new AttributesImpl());
                        if (rElement == null) {
                            ulm.getUserLayout(new ChannelSAXStreamFilter(saif));
                        } else {
                            ulm.getUserLayout(rElement.getId(), new ChannelSAXStreamFilter(saif));
                        }
                        saif.endElement("", "layout_fragment", "layout_fragment");
                        saif.endDocument();
                    } else if (rElement == null) {
                        ulm.getUserLayout(saif);
                    } else {
                        ulm.getUserLayout(rElement.getId(), saif);
                    }
                    if (logXMLBeforeStructureTransformation && this.log.isDebugEnabled()) {
                        this.log.debug((Object)("XML incoming to the structure transformation :\n\n" + dbwr1.toString() + "\n\n"));
                    }
                    tst.setParameter("baseActionURL", uPElement.getUPFile());
                    tst.setParameter("baseIdempotentActionURL", uPIdempotentElement.getUPFile());
                    if (externalLoginUrl != null) {
                        tst.setParameter("EXTERNAL_LOGIN_URL", externalLoginUrl);
                    }
                    Hashtable<String, String> tupTable = userPreferences.getThemeStylesheetUserPreferences().getParameterValues();
                    for (Map.Entry<String, String> param : tupTable.entrySet()) {
                        String pName = param.getKey();
                        String pValue = param.getValue();
                        if (this.log.isDebugEnabled()) {
                            this.log.debug((Object)("setting tparam \"" + pName + "\"=\"" + pValue + "\"."));
                        }
                        tst.setParameter(pName, pValue);
                    }
                    VersionsManager versionsManager = VersionsManager.getInstance();
                    for (Version version : versions = versionsManager.getVersions()) {
                        String paramName = "version-" + version.getFname();
                        tst.setParameter(paramName, version.dottedTriple());
                    }
                    Version uPortalVersion = versionsManager.getVersion("UP_FRAMEWORK");
                    tst.setParameter("uP_productAndVersion", "uPortal " + uPortalVersion.dottedTriple());
                    Locale[] locales = localeManager.getLocales();
                    if (locales != null && locales.length > 0 && locales[0] != null) {
                        tst.setParameter("USER_LANG", locales[0].toString().replace('_', '-'));
                    }
                    ThemeAttributesIncorporationFilter taif = new ThemeAttributesIncorporationFilter(crb, userPreferences.getThemeStylesheetUserPreferences());
                    taif.setAllHandlers(tsth);
                    StringWriter dbwr2 = null;
                    if (logXMLBeforeThemeTransformation && this.log.isDebugEnabled()) {
                        dbwr2 = new StringWriter();
                        XMLSerializer dbser2 = new XMLSerializer(dbwr2, outputFormat);
                        SAX2DuplicatingFilterImpl dupl2 = new SAX2DuplicatingFilterImpl(tsth, dbser2);
                        dupl2.setParent(taif);
                    }
                    if (CACHE_ENABLED && !ccaching) {
                        SAX2BufferImpl newCache = new SAX2BufferImpl();
                        tsth.setResult(new SAXResult(newCache));
                        cif.setParent(newCache);
                        systemCache.put(cacheKey, newCache);
                        newCache.setOutputAtDocumentEnd(true);
                        if (this.log.isDebugEnabled()) {
                            this.log.debug((Object)("recorded transformation cache with key \"" + cacheKey + "\""));
                        }
                    } else {
                        tsth.setResult(new SAXResult(cif));
                    }
                    crb.stopBuffering();
                    crb.outputBuffer();
                    crb.clearBuffer();
                    if (logXMLBeforeThemeTransformation && this.log.isDebugEnabled()) {
                        this.log.debug((Object)("XML incoming to the theme transformation :\n\n" + dbwr2.toString() + "\n\n"));
                    }
                    if (CACHE_ENABLED && ccaching) {
                        List<CacheEntry> cacheBlocks = cif.getCacheBlocks();
                        if (cacheBlocks == null) {
                            this.log.error((Object)"CharacterCachingChannelIncorporationFilter returned invalid cache entries!");
                        } else {
                            systemCharacterCache.put(cacheKey, cacheBlocks);
                            if (this.log.isDebugEnabled()) {
                                this.log.debug((Object)("recorded transformation character block cache with key \"" + cacheKey + "\""));
                                this.log.debug((Object)"Printing transformation cache blocks:");
                                for (int i = 0; i < cacheBlocks.size(); ++i) {
                                    CacheEntry ce = cacheBlocks.get(i);
                                    if (ce.getCacheType().equals((Object)CacheType.CHARACTERS)) {
                                        this.log.debug((Object)("----------piece " + Integer.toString(i)));
                                    } else if (ce.getCacheType().equals((Object)CacheType.CHANNEL_CONTENT)) {
                                        this.log.debug((Object)("----------channel content entry " + Integer.toString(i)));
                                    }
                                    DebugCachingSerializer dcs = new DebugCachingSerializer();
                                    ce.replayCache(dcs, channelManager, req, res);
                                    this.log.debug((Object)dcs.getCache());
                                }
                            }
                        }
                    }
                }
                channelManager.finishedRenderingCycle();
            }
            catch (PortalException pe) {
                throw pe;
            }
            catch (Exception e) {
                throw new PortalException(e);
            }
            finally {
                long pageRenderTime = System.currentTimeMillis() - startTime;
                lastRender = renderTimes.add(pageRenderTime);
                UserProfile userProfile = uPreferencesManager.getCurrentProfile();
                UserPreferences userPreferences = uPreferencesManager.getUserPreferences();
                StructureStylesheetUserPreferences structureStylesheetUserPreferences = userPreferences.getStructureStylesheetUserPreferences();
                String activeTab = structureStylesheetUserPreferences.getParameterValue("activeTab");
                int activeTabIndex = NumberUtils.toInt((String)activeTab, (int)1);
                IUserLayoutManager userLayoutManager = uPreferencesManager.getUserLayoutManager();
                IUserLayoutFolderDescription targetedNode = this.getActiveTab(userLayoutManager, activeTabIndex);
                PageRenderTimePortalEvent pageRenderTimePortalEvent = new PageRenderTimePortalEvent((Object)this, person, userProfile, targetedNode, pageRenderTime);
                this.applicationEventPublisher.publishEvent((ApplicationEvent)pageRenderTimePortalEvent);
            }
        }
    }

    protected IUserLayoutFolderDescription getActiveTab(IUserLayoutManager userLayoutManager, int activeTabIndex) {
        String rootFolderId = userLayoutManager.getRootFolderId();
        Enumeration<String> rootsChildren = userLayoutManager.getChildIds(rootFolderId);
        int tabIndex = 0;
        String topNodeId = rootsChildren.nextElement();
        while (rootsChildren.hasMoreElements()) {
            IUserLayoutNodeDescription topNode = userLayoutManager.getNode(topNodeId);
            if (!topNode.isHidden() && 2 == topNode.getType() && 0 == ((IUserLayoutFolderDescription)topNode).getFolderType() && ++tabIndex == activeTabIndex) {
                return (IUserLayoutFolderDescription)topNode;
            }
            topNodeId = rootsChildren.nextElement();
        }
        return null;
    }

    protected boolean processWorkerDispatchIfNecessary(HttpServletRequest req, HttpServletResponse res, IUserPreferencesManager uPreferencesManager, ChannelManager cm) throws PortalException {
        UPFileSpec upfs;
        HttpSession session = req.getSession(false);
        if (session == null) {
            return false;
        }
        try {
            upfs = new UPFileSpec(req);
        }
        catch (IndexOutOfBoundsException iobe) {
            return false;
        }
        if ("worker".equals(upfs.getMethod())) {
            String workerName = upfs.getMethodNodeId();
            if (workerName == null) {
                throw new PortalException("Unable to determine worker type for name '" + workerName + "', uPFile='" + upfs.getUPFile() + "'.");
            }
            String dispatchClassName = workerProperties.getProperty(workerName);
            if (dispatchClassName == null) {
                throw new PortalException("Unable to find processing class for the worker type '" + workerName + "'. Please check worker.properties");
            }
            try {
                ClassLoader carClassLoader = this.carResources.getClassLoader();
                Class<?> dispatcherClass = carClassLoader.loadClass(dispatchClassName);
                IWorkerRequestProcessor wrp = (IWorkerRequestProcessor)dispatcherClass.newInstance();
                try {
                    PortalControlStructures portalControlStructures = new PortalControlStructures(req, res, cm, uPreferencesManager);
                    wrp.processWorkerDispatch(portalControlStructures);
                }
                catch (PortalException pe) {
                    throw pe;
                }
                catch (RuntimeException re) {
                    throw new PortalException(re);
                }
            }
            catch (ClassNotFoundException cnfe) {
                throw new PortalException("Unable to find processing class '" + dispatchClassName + "' for the worker type '" + workerName + "'. Please check worker.properties", (Throwable)cnfe);
            }
            catch (InstantiationException ie) {
                throw new PortalException("Unable to instantiate processing class '" + dispatchClassName + "' for the worker type '" + workerName + "'. Please check worker.properties", (Throwable)ie);
            }
            catch (IllegalAccessException iae) {
                throw new PortalException("Unable to access processing class '" + dispatchClassName + "' for the worker type '" + workerName + "'. Please check worker.properties", (Throwable)iae);
            }
            return true;
        }
        return false;
    }

    protected String constructCacheKey(IUserPreferencesManager uPreferencesManager, String rootNodeId) throws PortalException {
        UserPreferences userPreferences = uPreferencesManager.getUserPreferences();
        IUserLayoutManager userLayoutManager = uPreferencesManager.getUserLayoutManager();
        return rootNodeId + "," + userPreferences.getCacheKey() + userLayoutManager.getCacheKey();
    }

    @Override
    public void clearSystemCharacterCache() {
        systemCharacterCache.clear();
    }

    static {
        MEDIA_MANAGER = MediaManager.getMediaManager();
        externalLoginUrl = null;
        try {
            workerProperties = ResourceLoader.getResourceAsProperties(StaticRenderingPipeline.class, WORKER_PROPERTIES_FILE_NAME);
        }
        catch (IOException ioe) {
            throw new PortalException("Unable to load worker.properties file. ", (Throwable)ioe);
        }
        try {
            Properties securityProps = ResourceLoader.getResourceAsProperties(StaticRenderingPipeline.class, SECURITY_PROPERTIES_FILE_NAME);
            externalLoginUrl = securityProps.getProperty(CAS_LOGIN_URL_PROPERTY);
        }
        catch (IOException ioe) {
            throw new PortalException("Unable to load worker.properties file. ", (Throwable)ioe);
        }
    }

    private static class TransformErrorListener
    implements ErrorListener {
        protected final Log log = LogFactory.getLog(UserInstance.class);

        private TransformErrorListener() {
        }

        @Override
        public void error(TransformerException te) throws TransformerException {
            this.log.error((Object)"An error occurred during transforamtion.", (Throwable)te);
        }

        @Override
        public void fatalError(TransformerException te) throws TransformerException {
            this.log.error((Object)"A fatal error occurred during transforamtion.", (Throwable)te);
        }

        @Override
        public void warning(TransformerException te) throws TransformerException {
            this.log.error((Object)"A warning occurred during transforamtion.", (Throwable)te);
        }
    }

    protected static class CharacterCacheEntry {
        List<String> systemBuffers = null;
        List<String> channelIds = null;

        protected CharacterCacheEntry() {
        }
    }
}

