/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.security;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.security.IAuthorizationPrincipal;
import org.jasig.portal.security.IAuthorizationService;
import org.jasig.portal.security.IPermission;
import org.jasig.portal.security.IPerson;
import org.jasig.portal.security.IPersonManager;
import org.jasig.portal.security.ISecurityContext;
import org.jasig.portal.security.provider.AuthorizationImpl;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.util.Assert;

public class MaxInactiveFilter
implements Filter {
    protected final Log log = LogFactory.getLog(this.getClass());
    private IPersonManager personManager;

    public IPersonManager getPersonManager() {
        return this.personManager;
    }

    @Required
    public void setPersonManager(IPersonManager personManager) {
        Assert.notNull((Object)personManager);
        this.personManager = personManager;
    }

    public void init(FilterConfig filterConfig) {
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws ServletException, IOException {
        chain.doFilter(req, res);
        IPerson person = this.personManager.getPerson((HttpServletRequest)req);
        if (person == null) {
            return;
        }
        ISecurityContext securityContext = person.getSecurityContext();
        if (securityContext != null && securityContext.isAuthenticated()) {
            IPermission[] permissions;
            IAuthorizationService authServ = AuthorizationImpl.singleton();
            IAuthorizationPrincipal principal = authServ.newPrincipal((String)person.getAttribute("username"), IPerson.class);
            Integer rulingGrant = null;
            Integer rulingDeny = null;
            for (IPermission p : permissions = authServ.getAllPermissionsForPrincipal(principal, null, "MAX_INACTIVE", null)) {
                long now = System.currentTimeMillis();
                if (p.getEffective() != null && p.getEffective().getTime() > now || p.getExpires() != null && p.getExpires().getTime() < now) continue;
                if (p.getType().equals("GRANT")) {
                    try {
                        Integer grantEntry = Integer.valueOf(p.getTarget());
                        if (rulingGrant != null && grantEntry >= 0 && rulingGrant >= grantEntry) continue;
                        rulingGrant = grantEntry;
                    }
                    catch (NumberFormatException nfe) {
                        this.log.warn((Object)("Invalid MAX_INACTIVE permission grant '" + p.getTarget() + "';  target must be an integer value."));
                    }
                    continue;
                }
                if (p.getType().equals("DENY")) {
                    try {
                        Integer denyEntry = Integer.valueOf(p.getTarget());
                        if (rulingDeny != null && rulingDeny <= denyEntry) continue;
                        rulingDeny = denyEntry;
                    }
                    catch (NumberFormatException nfe) {
                        this.log.warn((Object)("Invalid MAX_INACTIVE permission deny '" + p.getTarget() + "';  target must be an integer value."));
                    }
                    continue;
                }
                this.log.warn((Object)("Unknown permission type:  " + p.getType()));
            }
            if (rulingDeny != null && rulingDeny < 0) {
                this.log.warn((Object)("A MAX_INACTIVE DENY entry improperly specified a negative target:  " + rulingDeny));
                rulingDeny = null;
            }
            if (rulingGrant != null || rulingDeny != null) {
                int maxInactive;
                int n = maxInactive = rulingGrant != null ? rulingGrant : 0;
                if (rulingDeny != null) {
                    int limit = rulingDeny;
                    maxInactive = maxInactive >= 0 ? (limit < maxInactive ? limit : maxInactive) : limit;
                }
                HttpSession session = ((HttpServletRequest)req).getSession();
                session.setMaxInactiveInterval(maxInactive);
                if (this.log.isInfoEnabled()) {
                    this.log.info((Object)("Setting maxInactive to '" + maxInactive + "' for user '" + person.getAttribute("username") + "'"));
                }
            }
        }
    }
}

