/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.security.provider;

import java.io.Serializable;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.security.IAdditionalDescriptor;
import org.jasig.portal.security.ISecurityContext;
import org.jasig.portal.security.PortalSecurityException;
import org.jasig.portal.security.provider.ChainingSecurityContext;
import org.jasig.portal.security.provider.JAASInlineCallbackHandler;
import org.jasig.portal.security.provider.JAASSubject;

class JAASSecurityContext
extends ChainingSecurityContext
implements ISecurityContext,
Serializable {
    private static final Log log = LogFactory.getLog(JAASSecurityContext.class);
    private final int JAASSECURITYAUTHTYPE = 65285;
    private IAdditionalDescriptor additionalDescriptor;

    JAASSecurityContext() {
    }

    @Override
    public int getAuthType() {
        return this.JAASSECURITYAUTHTYPE;
    }

    @Override
    public IAdditionalDescriptor getAdditionalDescriptor() {
        return this.additionalDescriptor;
    }

    @Override
    public synchronized void authenticate() throws PortalSecurityException {
        this.isauth = false;
        if (this.myPrincipal.UID != null && this.myOpaqueCredentials.credentialstring != null) {
            try {
                LoginContext lc = null;
                lc = new LoginContext("uPortal", new JAASInlineCallbackHandler(this.myPrincipal.UID, new String(this.myOpaqueCredentials.credentialstring).toCharArray()));
                lc.login();
                this.additionalDescriptor = new JAASSubject(lc.getSubject());
                if (log.isInfoEnabled()) {
                    log.info((Object)("User " + this.myPrincipal.UID + " is authenticated"));
                }
                this.isauth = true;
            }
            catch (LoginException e) {
                if (log.isInfoEnabled()) {
                    log.info((Object)("User " + this.myPrincipal.UID + ": invalid password"));
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)"LoginException", (Throwable)e);
                }
            }
        } else {
            log.error((Object)"Principal or OpaqueCredentials not initialized prior to authenticate");
        }
        super.authenticate();
    }
}

