/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.security.provider;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.AuthorizationException;
import org.jasig.portal.RDBMServices;
import org.jasig.portal.security.IPermission;
import org.jasig.portal.security.IPermissionStore;
import org.jasig.portal.security.provider.PermissionImpl;

public class RDBMPermissionImpl
implements IPermissionStore {
    private static final Log log = LogFactory.getLog(RDBMPermissionImpl.class);
    private static RDBMPermissionImpl singleton;
    private static boolean timestampHasMillis;
    private static String PERMISSION_TABLE;
    private static String OWNER_COLUMN;
    private static String PRINCIPAL_TYPE_COLUMN;
    private static String PRINCIPAL_KEY_COLUMN;
    private static String ACTIVITY_COLUMN;
    private static String TARGET_COLUMN;
    private static String TYPE_COLUMN;
    private static String EFFECTIVE_COLUMN;
    private static String EXPIRES_COLUMN;
    private static String allPermissionColumnsSql;
    private static String deletePermissionSql;
    private static String findPermissionSql;
    private static String insertPermissionSql;
    private static String selectPermissionSql;
    private static String updatePermissionSql;
    private static String PRINCIPAL_SEPARATOR;

    public RDBMPermissionImpl() {
        Date testDate = new Date();
        Timestamp testTimestamp = new Timestamp(testDate.getTime());
        timestampHasMillis = testDate.getTime() == testTimestamp.getTime();
    }

    @Override
    public void add(IPermission[] perms) throws AuthorizationException {
        if (perms.length > 0) {
            try {
                this.primAdd(perms);
            }
            catch (Exception ex) {
                log.error((Object)("Exception adding permissions " + perms), (Throwable)ex);
                throw new AuthorizationException(ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(IPermission perm) throws AuthorizationException {
        Connection conn = null;
        int rc = 0;
        try {
            conn = RDBMServices.getConnection();
            String sQuery = RDBMPermissionImpl.getInsertPermissionSql();
            PreparedStatement ps = conn.prepareStatement(sQuery);
            try {
                this.primAdd(perm, ps);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("RDBMPermissionImpl.add(): " + ps));
                }
                if ((rc = ps.executeUpdate()) != 1) {
                    throw new AuthorizationException("Problem adding Permission " + perm);
                }
            }
            finally {
                ps.close();
            }
        }
        catch (Exception ex) {
            log.error((Object)("Exception adding permission [" + perm + "]"), (Throwable)ex);
            throw new AuthorizationException("Problem adding Permission " + perm);
        }
        finally {
            RDBMServices.releaseConnection(conn);
        }
    }

    @Override
    public void delete(IPermission[] perms) throws AuthorizationException {
        if (perms.length > 0) {
            try {
                this.primDelete(perms);
            }
            catch (Exception ex) {
                log.error((Object)("Exception deleting permissions " + Arrays.toString(perms)), (Throwable)ex);
                throw new AuthorizationException("Exception deleting permissions " + Arrays.toString(perms), (Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(IPermission perm) throws AuthorizationException {
        Connection conn = null;
        try {
            conn = RDBMServices.getConnection();
            String sQuery = RDBMPermissionImpl.getDeletePermissionSql();
            PreparedStatement ps = conn.prepareStatement(sQuery);
            try {
                this.primDelete(perm, ps);
            }
            finally {
                ps.close();
            }
        }
        catch (Exception ex) {
            log.error((Object)("Exception deleting permission [" + perm + "]"), (Throwable)ex);
            throw new AuthorizationException("Problem deleting Permission " + perm, (Throwable)ex);
        }
        finally {
            RDBMServices.releaseConnection(conn);
        }
    }

    /*
     * Exception decompiling
     */
    public boolean existsInDatabase(IPermission perm) throws AuthorizationException, SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static String getAllPermissionColumnsSql() {
        if (allPermissionColumnsSql == null) {
            StringBuffer sqlBuff = new StringBuffer(200);
            sqlBuff.append(OWNER_COLUMN);
            sqlBuff.append(", ");
            sqlBuff.append(PRINCIPAL_TYPE_COLUMN);
            sqlBuff.append(", ");
            sqlBuff.append(PRINCIPAL_KEY_COLUMN);
            sqlBuff.append(", ");
            sqlBuff.append(ACTIVITY_COLUMN);
            sqlBuff.append(", ");
            sqlBuff.append(TARGET_COLUMN);
            sqlBuff.append(", ");
            sqlBuff.append(TYPE_COLUMN);
            sqlBuff.append(", ");
            sqlBuff.append(EFFECTIVE_COLUMN);
            sqlBuff.append(", ");
            sqlBuff.append(EXPIRES_COLUMN);
            allPermissionColumnsSql = sqlBuff.toString();
        }
        return allPermissionColumnsSql;
    }

    private static String getDeletePermissionSql() {
        if (deletePermissionSql == null) {
            StringBuffer sqlBuff = new StringBuffer(200);
            sqlBuff.append("DELETE FROM ");
            sqlBuff.append(PERMISSION_TABLE);
            sqlBuff.append(" WHERE ");
            sqlBuff.append(OWNER_COLUMN);
            sqlBuff.append(" = ? AND ");
            sqlBuff.append(PRINCIPAL_TYPE_COLUMN);
            sqlBuff.append(" = ? AND ");
            sqlBuff.append(PRINCIPAL_KEY_COLUMN);
            sqlBuff.append(" = ? AND ");
            sqlBuff.append(ACTIVITY_COLUMN);
            sqlBuff.append(" = ? AND ");
            sqlBuff.append(TARGET_COLUMN);
            sqlBuff.append(" = ? ");
            deletePermissionSql = sqlBuff.toString();
        }
        return deletePermissionSql;
    }

    private static String getFindPermissionSql() {
        if (findPermissionSql == null) {
            StringBuffer sqlBuff = new StringBuffer(RDBMPermissionImpl.getSelectPermissionSql());
            sqlBuff.append("WHERE ");
            sqlBuff.append(OWNER_COLUMN);
            sqlBuff.append(" = ? AND ");
            sqlBuff.append(PRINCIPAL_TYPE_COLUMN);
            sqlBuff.append(" = ? AND ");
            sqlBuff.append(PRINCIPAL_KEY_COLUMN);
            sqlBuff.append(" = ? AND ");
            sqlBuff.append(ACTIVITY_COLUMN);
            sqlBuff.append(" = ? AND ");
            sqlBuff.append(TARGET_COLUMN);
            sqlBuff.append(" = ? ");
            sqlBuff.append(TYPE_COLUMN);
            sqlBuff.append(" = ? ");
            findPermissionSql = sqlBuff.toString();
        }
        return findPermissionSql;
    }

    private static String getInsertPermissionSql() {
        if (insertPermissionSql == null) {
            StringBuffer sqlBuff = new StringBuffer(200);
            sqlBuff.append("INSERT INTO ");
            sqlBuff.append(PERMISSION_TABLE);
            sqlBuff.append(" (");
            sqlBuff.append(RDBMPermissionImpl.getAllPermissionColumnsSql());
            sqlBuff.append(") VALUES (?, ?, ?, ?, ?, ?, ?, ?)");
            insertPermissionSql = sqlBuff.toString();
        }
        return insertPermissionSql;
    }

    private String getPrincipalKey(String principalString) {
        return principalString.substring(principalString.indexOf(PRINCIPAL_SEPARATOR) + 1);
    }

    private String getPrincipalKey(IPermission perm) throws AuthorizationException {
        return this.getPrincipalKey(perm.getPrincipal());
    }

    private int getPrincipalType(String principalString) {
        return Integer.parseInt(principalString.substring(0, principalString.indexOf(PRINCIPAL_SEPARATOR)));
    }

    private int getPrincipalType(IPermission perm) throws AuthorizationException {
        return this.getPrincipalType(perm.getPrincipal());
    }

    private static String getSelectPermissionSql() {
        if (selectPermissionSql == null) {
            StringBuffer sqlBuff = new StringBuffer(200);
            sqlBuff.append("SELECT ");
            sqlBuff.append(RDBMPermissionImpl.getAllPermissionColumnsSql());
            sqlBuff.append(" FROM ");
            sqlBuff.append(PERMISSION_TABLE);
            sqlBuff.append(" ");
            selectPermissionSql = sqlBuff.toString();
        }
        return selectPermissionSql;
    }

    private static String getUpdatePermissionSql() {
        if (updatePermissionSql == null) {
            StringBuffer sqlBuff = new StringBuffer(300);
            sqlBuff.append("UPDATE ");
            sqlBuff.append(PERMISSION_TABLE);
            sqlBuff.append(" SET ");
            sqlBuff.append(TYPE_COLUMN);
            sqlBuff.append(" = ?, ");
            sqlBuff.append(EFFECTIVE_COLUMN);
            sqlBuff.append(" = ?, ");
            sqlBuff.append(EXPIRES_COLUMN);
            sqlBuff.append(" = ? WHERE ");
            sqlBuff.append(OWNER_COLUMN);
            sqlBuff.append(" = ? AND ");
            sqlBuff.append(PRINCIPAL_TYPE_COLUMN);
            sqlBuff.append(" = ? AND ");
            sqlBuff.append(PRINCIPAL_KEY_COLUMN);
            sqlBuff.append(" = ? AND ");
            sqlBuff.append(ACTIVITY_COLUMN);
            sqlBuff.append(" = ? AND ");
            sqlBuff.append(TARGET_COLUMN);
            sqlBuff.append(" = ? ");
            updatePermissionSql = sqlBuff.toString();
        }
        return updatePermissionSql;
    }

    private IPermission instanceFromResultSet(ResultSet rs) throws SQLException {
        Timestamp ts = null;
        IPermission perm = this.newInstance(rs.getString(OWNER_COLUMN));
        perm.setPrincipal(rs.getString(PRINCIPAL_TYPE_COLUMN) + "." + rs.getString(PRINCIPAL_KEY_COLUMN));
        perm.setActivity(rs.getString(ACTIVITY_COLUMN));
        perm.setTarget(rs.getString(TARGET_COLUMN));
        perm.setType(rs.getString(TYPE_COLUMN));
        ts = rs.getTimestamp(EFFECTIVE_COLUMN);
        if (ts != null) {
            perm.setEffective(new Date(RDBMPermissionImpl.getTimestampMillis(ts)));
        }
        if ((ts = rs.getTimestamp(EXPIRES_COLUMN)) != null) {
            perm.setExpires(new Date(RDBMPermissionImpl.getTimestampMillis(ts)));
        }
        return perm;
    }

    @Override
    public IPermission newInstance(String owner) {
        return new PermissionImpl(owner);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void primAdd(IPermission[] perms) throws Exception {
        Connection conn = null;
        int rc = 0;
        try {
            conn = RDBMServices.getConnection();
            String sQuery = RDBMPermissionImpl.getInsertPermissionSql();
            PreparedStatement ps = conn.prepareStatement(sQuery);
            try {
                RDBMServices.setAutoCommit(conn, false);
                for (int i = 0; i < perms.length; ++i) {
                    this.primAdd(perms[i], ps);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("RDBMPermissionImpl.primAdd(): " + ps));
                    }
                    if ((rc = ps.executeUpdate()) == 1) continue;
                    String errMsg = "Problem adding " + perms[i] + " RC: " + rc;
                    log.error((Object)errMsg);
                    RDBMServices.rollback(conn);
                    throw new AuthorizationException(errMsg);
                }
            }
            finally {
                ps.close();
            }
            RDBMServices.commit(conn);
        }
        catch (Exception ex) {
            log.error((Object)("Exception adding permissions " + perms), (Throwable)ex);
            RDBMServices.rollback(conn);
            throw ex;
        }
        finally {
            try {
                RDBMServices.setAutoCommit(conn, true);
            }
            finally {
                RDBMServices.releaseConnection(conn);
            }
        }
    }

    private void primAdd(IPermission perm, PreparedStatement ps) throws Exception {
        Timestamp ts = null;
        ps.clearParameters();
        ps.setString(1, perm.getOwner());
        ps.setInt(2, this.getPrincipalType(perm));
        ps.setString(3, this.getPrincipalKey(perm));
        ps.setString(4, perm.getActivity());
        ps.setString(5, perm.getTarget());
        if (perm.getType() == null) {
            ps.setNull(6, 12);
        } else {
            ps.setString(6, perm.getType());
        }
        if (perm.getEffective() == null) {
            ps.setNull(7, 93);
        } else {
            ts = new Timestamp(perm.getEffective().getTime());
            ps.setTimestamp(7, ts);
        }
        if (perm.getExpires() == null) {
            ps.setNull(8, 93);
        } else {
            ts = new Timestamp(perm.getExpires().getTime());
            ps.setTimestamp(8, ts);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void primDelete(IPermission[] perms) throws Exception {
        Connection conn = null;
        try {
            conn = RDBMServices.getConnection();
            String sQuery = RDBMPermissionImpl.getDeletePermissionSql();
            PreparedStatement ps = conn.prepareStatement(sQuery);
            try {
                RDBMServices.setAutoCommit(conn, false);
                for (int i = 0; i < perms.length; ++i) {
                    this.primDelete(perms[i], ps);
                }
            }
            finally {
                ps.close();
            }
            RDBMServices.commit(conn);
        }
        catch (Exception ex) {
            log.error((Object)("Exception deleting permissions [" + perms + "]"), (Throwable)ex);
            RDBMServices.rollback(conn);
            throw ex;
        }
        finally {
            try {
                RDBMServices.setAutoCommit(conn, true);
            }
            finally {
                RDBMServices.releaseConnection(conn);
            }
        }
    }

    private int primDelete(IPermission perm, PreparedStatement ps) throws Exception {
        ps.clearParameters();
        ps.setString(1, perm.getOwner());
        ps.setInt(2, this.getPrincipalType(perm));
        ps.setString(3, this.getPrincipalKey(perm));
        ps.setString(4, perm.getActivity());
        ps.setString(5, perm.getTarget());
        if (log.isDebugEnabled()) {
            log.debug((Object)("RDBMPermissionImpl.primDelete(): " + ps));
        }
        return ps.executeUpdate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void primUpdate(IPermission[] perms) throws Exception {
        Connection conn = null;
        try {
            conn = RDBMServices.getConnection();
            String sQuery = RDBMPermissionImpl.getUpdatePermissionSql();
            PreparedStatement ps = conn.prepareStatement(sQuery);
            try {
                RDBMServices.setAutoCommit(conn, false);
                for (int i = 0; i < perms.length; ++i) {
                    this.primUpdate(perms[i], ps);
                }
            }
            finally {
                ps.close();
            }
            RDBMServices.commit(conn);
        }
        catch (Exception ex) {
            log.error((Object)("Exception updating permissions " + perms), (Throwable)ex);
            RDBMServices.rollback(conn);
            throw ex;
        }
        finally {
            try {
                RDBMServices.setAutoCommit(conn, true);
            }
            finally {
                RDBMServices.releaseConnection(conn);
            }
        }
    }

    private int primUpdate(IPermission perm, PreparedStatement ps) throws Exception {
        Timestamp ts = null;
        ps.clearParameters();
        if (perm.getType() == null) {
            ps.setNull(1, 12);
        } else {
            ps.setString(1, perm.getType());
        }
        if (perm.getEffective() == null) {
            ps.setNull(2, 93);
        } else {
            ts = new Timestamp(perm.getEffective().getTime());
            ps.setTimestamp(2, ts);
        }
        if (perm.getExpires() == null) {
            ps.setNull(3, 93);
        } else {
            ts = new Timestamp(perm.getExpires().getTime());
            ps.setTimestamp(3, ts);
        }
        ps.setString(4, perm.getOwner());
        ps.setInt(5, this.getPrincipalType(perm));
        ps.setString(6, this.getPrincipalKey(perm));
        ps.setString(7, perm.getActivity());
        ps.setString(8, perm.getTarget());
        if (log.isDebugEnabled()) {
            log.debug((Object)("RDBMPermissionImpl.primUpdate(): " + ps));
        }
        return ps.executeUpdate();
    }

    private void prepareSelectQuery(PreparedStatement stmt, String owner, String principal, String activity, String target, String type) throws SQLException {
        int i = 1;
        if (owner != null) {
            stmt.setString(i++, owner);
        }
        if (principal != null) {
            stmt.setInt(i++, this.getPrincipalType(principal));
            stmt.setString(i++, this.getPrincipalKey(principal));
        }
        if (activity != null) {
            stmt.setString(i++, activity);
        }
        if (target != null) {
            stmt.setString(i++, target);
        }
        if (type != null) {
            stmt.setString(i++, type);
        }
    }

    private String getSelectQuery(String owner, String principal, String activity, String target, String type) {
        StringBuffer sqlQuery = new StringBuffer(RDBMPermissionImpl.getSelectPermissionSql());
        sqlQuery.append(" WHERE ");
        if (owner != null) {
            sqlQuery.append(OWNER_COLUMN);
            sqlQuery.append(" = ? ");
        } else {
            sqlQuery.append("1 = 1 ");
        }
        if (principal != null) {
            sqlQuery.append("AND ");
            sqlQuery.append(PRINCIPAL_TYPE_COLUMN);
            sqlQuery.append(" = ? AND ");
            sqlQuery.append(PRINCIPAL_KEY_COLUMN);
            sqlQuery.append(" = ? ");
        }
        if (activity != null) {
            sqlQuery.append("AND ");
            sqlQuery.append(ACTIVITY_COLUMN);
            sqlQuery.append(" = ? ");
        }
        if (target != null) {
            sqlQuery.append("AND ");
            sqlQuery.append(TARGET_COLUMN);
            sqlQuery.append(" = ? ");
        }
        if (type != null) {
            sqlQuery.append("AND ");
            sqlQuery.append(TYPE_COLUMN);
            sqlQuery.append(" = ? ");
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("Computed SQL query [" + sqlQuery + "] for owner=[" + owner + "] and principal=[" + principal + "] and activity=[" + activity + "] and target=[" + target + "] and type=[" + type + "]"));
        }
        return sqlQuery.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IPermission[] select(String owner, String principal, String activity, String target, String type) throws AuthorizationException {
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        ArrayList<IPermission> perms = new ArrayList<IPermission>();
        String query = this.getSelectQuery(owner, principal, activity, target, type);
        try {
            conn = RDBMServices.getConnection();
            stmt = conn.prepareStatement(query);
            this.prepareSelectQuery(stmt, owner, principal, activity, target, type);
            try {
                rs = stmt.executeQuery();
                try {
                    while (rs.next()) {
                        perms.add(this.instanceFromResultSet(rs));
                    }
                }
                finally {
                    rs.close();
                }
            }
            finally {
                stmt.close();
            }
        }
        catch (SQLException sqle) {
            log.error((Object)"Problem retrieving permissions", (Throwable)sqle);
            throw new AuthorizationException("Problem retrieving Permissions [" + sqle.getMessage() + "] for query=[" + query + "] for owner=[" + owner + "] and principal=[" + principal + "] and activity=[" + activity + "] and target=[" + target + "] and type=[" + type + "]", (Throwable)sqle);
        }
        finally {
            RDBMServices.releaseConnection(conn);
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("RDBMPermissionImpl.select(): [" + query + "] for owner=[" + owner + "] and principal=[" + principal + "] and activity=[" + activity + "] and target=[" + target + "] and type=[" + type + "] returned permissions [" + perms + "]"));
        }
        return perms.toArray(new IPermission[perms.size()]);
    }

    public static synchronized RDBMPermissionImpl singleton() {
        if (singleton == null) {
            singleton = new RDBMPermissionImpl();
        }
        return singleton;
    }

    @Override
    public void update(IPermission[] perms) throws AuthorizationException {
        if (perms.length > 0) {
            try {
                this.primUpdate(perms);
            }
            catch (Exception ex) {
                log.error((Object)("Exception updating permissions " + perms), (Throwable)ex);
                throw new AuthorizationException(ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(IPermission perm) throws AuthorizationException {
        Connection conn = null;
        try {
            conn = RDBMServices.getConnection();
            String sQuery = RDBMPermissionImpl.getUpdatePermissionSql();
            if (log.isDebugEnabled()) {
                log.debug((Object)("RDBMPermissionImpl.update(): " + sQuery));
            }
            PreparedStatement ps = conn.prepareStatement(sQuery);
            try {
                this.primUpdate(perm, ps);
            }
            finally {
                ps.close();
            }
        }
        catch (Exception ex) {
            log.error((Object)("Exception updating permission [" + perm + "]"), (Throwable)ex);
            throw new AuthorizationException("Problem updating Permission " + perm);
        }
        finally {
            RDBMServices.releaseConnection(conn);
        }
    }

    private static long getTimestampMillis(Timestamp ts) {
        if (timestampHasMillis) {
            return ts.getTime();
        }
        return ts.getTime() + (long)(ts.getNanos() / 1000000);
    }

    static {
        PERMISSION_TABLE = "UP_PERMISSION";
        OWNER_COLUMN = "OWNER";
        PRINCIPAL_TYPE_COLUMN = "PRINCIPAL_TYPE";
        PRINCIPAL_KEY_COLUMN = "PRINCIPAL_KEY";
        ACTIVITY_COLUMN = "ACTIVITY";
        TARGET_COLUMN = "TARGET";
        TYPE_COLUMN = "PERMISSION_TYPE";
        EFFECTIVE_COLUMN = "EFFECTIVE";
        EXPIRES_COLUMN = "EXPIRES";
        PRINCIPAL_SEPARATOR = ".";
    }
}

