/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.security.xslt;

import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.IChannelRegistryStore;
import org.jasig.portal.channel.IChannelDefinition;
import org.jasig.portal.groups.IEntity;
import org.jasig.portal.security.IAuthorizationPrincipal;
import org.jasig.portal.security.IPerson;
import org.jasig.portal.security.xslt.IXalanAuthorizationHelper;
import org.jasig.portal.services.AuthorizationService;
import org.jasig.portal.services.GroupService;
import org.springframework.beans.factory.annotation.Required;

public class XalanAuthorizationHelperBean
implements IXalanAuthorizationHelper {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private IChannelRegistryStore channelRegistryStore;

    public IChannelRegistryStore getChannelRegistryStore() {
        return this.channelRegistryStore;
    }

    @Required
    public void setChannelRegistryStore(IChannelRegistryStore channelRegistryStore) {
        Validate.notNull((Object)channelRegistryStore, (String)"channelRegistryStore can not be null");
        this.channelRegistryStore = channelRegistryStore;
    }

    @Override
    public boolean canRender(String userName, String channelFName) {
        int channelId;
        if (userName == null || channelFName == null) {
            return false;
        }
        IAuthorizationPrincipal userPrincipal = this.getUserPrincipal(userName);
        if (userPrincipal == null) {
            return false;
        }
        try {
            IChannelDefinition channelDefinition = this.channelRegistryStore.getChannelDefinition(channelFName);
            if (channelDefinition == null) {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info((Object)("No ChannelDefinition for fname='" + channelFName + "', returning false."));
                }
                return false;
            }
            channelId = channelDefinition.getId();
        }
        catch (Exception e) {
            this.logger.warn((Object)("Could not find ChannelDefinition for fname='" + channelFName + "' while checking if user '" + userName + "' can render it. Returning FALSE."), (Throwable)e);
            return false;
        }
        return userPrincipal.canRender(channelId);
    }

    protected IAuthorizationPrincipal getUserPrincipal(String userName) {
        IEntity user = GroupService.getEntity(userName, IPerson.class);
        if (user == null) {
            return null;
        }
        AuthorizationService authService = AuthorizationService.instance();
        return authService.newPrincipal(user);
    }
}

