/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.services;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.EntityTypes;
import org.jasig.portal.groups.GroupsException;
import org.jasig.portal.groups.IEntityNameFinder;
import org.jasig.portal.groups.IEntityNameFinderFactory;
import org.jasig.portal.properties.PropertiesManager;

public class EntityNameFinderService {
    private static final Log log = LogFactory.getLog(EntityNameFinderService.class);
    private static EntityNameFinderService m_instance;
    private Map nameFinders = null;
    private static boolean initialized;

    private EntityNameFinderService() {
        this.initialize();
    }

    public IEntityNameFinder getNameFinder(Class type) throws GroupsException {
        IEntityNameFinder finder = (IEntityNameFinder)this.getNameFinders().get(type);
        if (finder == null) {
            throw new GroupsException("Name finder for " + type.getName() + " could not be located.");
        }
        return finder;
    }

    private Map getNameFinders() {
        if (this.nameFinders == null) {
            this.nameFinders = new HashMap(10);
        }
        return this.nameFinders;
    }

    private synchronized void initialize() {
        Iterator types = EntityTypes.singleton().getAllEntityTypes();
        String factoryName = null;
        while (types.hasNext()) {
            Class type = (Class)types.next();
            if (type == Object.class) continue;
            String factoryKey = "org.jasig.portal.services.EntityNameFinderService.NameFinderFactory.implementation_" + type.getName();
            try {
                factoryName = PropertiesManager.getProperty(factoryKey);
            }
            catch (Exception runtime) {
                String dMsg = "EntityNameFinderService.initialize(): could not find property for " + type.getName() + " factory.";
                log.debug((Object)dMsg);
            }
            if (factoryName == null) continue;
            try {
                IEntityNameFinderFactory factory = (IEntityNameFinderFactory)Class.forName(factoryName).newInstance();
                this.getNameFinders().put(type, factory.newFinder());
            }
            catch (Exception e) {
                String eMsg = "EntityNameFinderService.initialize(): Could not instantiate finder for " + type.getName() + ": ";
                log.error((Object)eMsg, (Throwable)e);
            }
        }
        EntityNameFinderService.setInitialized(true);
    }

    public static final synchronized EntityNameFinderService instance() {
        if (m_instance == null) {
            m_instance = new EntityNameFinderService();
        }
        return m_instance;
    }

    private static boolean isInitialized() {
        return initialized;
    }

    static void setInitialized(boolean newInitialized) {
        initialized = newInitialized;
    }

    public static void start() {
        if (!EntityNameFinderService.isInitialized()) {
            EntityNameFinderService.instance();
        }
    }

    static {
        initialized = false;
    }
}

