/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.services;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.EntityIdentifier;
import org.jasig.portal.EntityTypes;
import org.jasig.portal.concurrency.CachingException;
import org.jasig.portal.services.EntityCachingService;
import org.jasig.portal.services.entityproperties.EntityProperties;
import org.jasig.portal.services.entityproperties.IEntityPropertyFinder;
import org.jasig.portal.services.entityproperties.IEntityPropertyStore;
import org.jasig.portal.utils.ResourceLoader;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class EntityPropertyRegistry {
    private static final Log log = LogFactory.getLog(EntityPropertyRegistry.class);
    protected static EntityPropertyRegistry _instance;
    protected IEntityPropertyStore store;
    protected int storePrecedence;
    protected IEntityPropertyFinder[] finders;
    protected Object[] finderTypes;
    protected Class propsType;

    protected EntityPropertyRegistry() {
    }

    protected void init() throws Exception {
        Element f;
        int i;
        Document def = ResourceLoader.getResourceAsDocument(this.getClass(), "/properties/EntityPropertyRegistry.xml");
        NodeList ss = def.getElementsByTagName("store");
        if (ss.getLength() == 1) {
            Element s = (Element)ss.item(0);
            this.store = (IEntityPropertyStore)Class.forName(s.getAttribute("impl")).newInstance();
            this.storePrecedence = Integer.parseInt(s.getAttribute("precedence"));
        }
        NodeList ff = def.getElementsByTagName("finder");
        int top = this.storePrecedence;
        for (i = 0; i < ff.getLength(); ++i) {
            f = (Element)ff.item(i);
            int test = Integer.parseInt(f.getAttribute("precedence"));
            if (test <= this.storePrecedence) continue;
            top = test;
        }
        this.finders = new IEntityPropertyFinder[top + 1];
        this.finderTypes = new Object[top + 1];
        for (i = 0; i < ff.getLength(); ++i) {
            f = (Element)ff.item(i);
            int p = Integer.parseInt(f.getAttribute("precedence"));
            this.finders[p] = (IEntityPropertyFinder)Class.forName(f.getAttribute("impl")).newInstance();
            String type = f.getAttribute("type");
            this.finderTypes[p] = type.equals("*") ? type : Class.forName(type);
        }
        this.propsType = Class.forName("org.jasig.portal.services.entityproperties.EntityProperties");
    }

    public static synchronized EntityPropertyRegistry instance() {
        if (_instance == null) {
            try {
                _instance = new EntityPropertyRegistry();
                _instance.init();
            }
            catch (Exception e) {
                _instance = null;
                log.error((Object)"Could not initialize EntityPropertyRegistry", (Throwable)e);
            }
        }
        return _instance;
    }

    public static String[] getPropertyNames(EntityIdentifier entityID) {
        return EntityPropertyRegistry.instance().getProperties(entityID).getPropertyNames();
    }

    public static String getProperty(EntityIdentifier entityID, String name) {
        return EntityPropertyRegistry.instance().getProperties(entityID).getProperty(name);
    }

    public static void storeProperty(EntityIdentifier entityID, String name, String value) {
        EntityPropertyRegistry.instance().store.storeProperty(entityID, name, value);
    }

    public static void unStoreProperty(EntityIdentifier entityID, String name) {
        EntityPropertyRegistry.instance().store.unStoreProperty(entityID, name);
    }

    protected String getPropKey(EntityIdentifier entityID) {
        String key = EntityTypes.getEntityTypeID(entityID.getType()).toString() + "." + entityID.getKey();
        return key;
    }

    protected EntityProperties getProperties(EntityIdentifier entityID) {
        EntityProperties ep = null;
        ep = new EntityProperties(this.getPropKey(entityID));
        for (int i = 0; i < this.finders.length; ++i) {
            IEntityPropertyFinder finder = i == this.storePrecedence ? this.store : (this.finderTypes[i] != null && (this.finderTypes[i].equals("*") || entityID.getType().equals(this.finderTypes[i])) ? this.finders[i] : null);
            if (finder == null) continue;
            String[] names = finder.getPropertyNames(entityID);
            for (int j = 0; j < names.length; ++j) {
                ep.setProperty(names[j], finder.getProperty(entityID, names[j]));
            }
        }
        return ep;
    }

    public void clearCache(EntityIdentifier entityID) {
        try {
            EntityCachingService.getEntityCachingService().remove(this.propsType, this.getPropKey(entityID));
        }
        catch (CachingException e) {
            log.error((Object)("Error clearing cache for entity ID [" + entityID + "]"), (Throwable)e);
        }
    }

    public void addToCache(EntityProperties ep) {
        try {
            EntityCachingService.getEntityCachingService().add(ep);
        }
        catch (CachingException e) {
            log.error((Object)("Error adding entity properties [" + ep + "] to the cache"), (Throwable)e);
        }
    }

    public EntityProperties getCachedProperties(EntityIdentifier entityID) {
        EntityProperties ep = null;
        try {
            ep = (EntityProperties)EntityCachingService.getEntityCachingService().get(this.propsType, entityID.getKey());
        }
        catch (CachingException e) {
            log.error((Object)("Error getting cached properties for entity [" + entityID + "]"), (Throwable)e);
        }
        return ep;
    }
}

