/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.spring.locator;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public abstract class AbstractBeanLocator<T>
implements DisposableBean,
InitializingBean {
    protected final Log logger = LogFactory.getLog(AbstractBeanLocator.class);
    private final T instance;

    public AbstractBeanLocator(T instance, Class<T> type) {
        Assert.notNull(instance, (String)"instance must not be null");
        Assert.notNull(type, (String)"type must not be null");
        Assert.isInstanceOf(type, instance, (String)(instance + " must implement " + type));
        this.instance = instance;
    }

    protected abstract void setLocator(AbstractBeanLocator<T> var1);

    protected abstract AbstractBeanLocator<T> getLocator();

    public final T getInstance() {
        return this.instance;
    }

    public final void afterPropertiesSet() throws Exception {
        if (this.getLocator() != null) {
            this.logger.warn((Object)("Static " + this.getClass().getName() + " reference has already been set and setInstance is being called"));
        }
        this.setLocator(this);
    }

    public final void destroy() throws Exception {
        if (this.getLocator() == null) {
            this.logger.warn((Object)("Static " + this.getClass().getName() + " reference is already null and destroy is being called"));
        }
        this.setLocator(null);
    }
}

