/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.tools.checks;

import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.tools.checks.CheckResult;
import org.jasig.portal.tools.checks.ICheck;

public abstract class BaseCheck
implements ICheck {
    protected final Log log = LogFactory.getLog(this.getClass());
    private boolean fatal;
    private String description;

    public final boolean isFatal() {
        return this.fatal;
    }

    public final void setFatal(boolean fatal) {
        this.fatal = fatal;
    }

    public final void setDescription(String description) {
        Validate.notNull((Object)description, (String)"description can not be null");
        this.description = description;
    }

    @Override
    public final CheckResult doCheck() {
        CheckResult checkResult = this.doCheckInternal();
        if (this.fatal && !checkResult.isSuccess() && !checkResult.isFatal()) {
            checkResult = CheckResult.createFatalFailure(checkResult.getMessage(), checkResult.getRemediationAdvice());
        }
        return checkResult;
    }

    protected abstract CheckResult doCheckInternal();

    @Override
    public final String getDescription() {
        return this.description;
    }
}

