/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.tools.checks;

import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public class CheckResult {
    private final boolean success;
    private final boolean fatal;
    private final String message;
    private final String remediationAdvice;

    private CheckResult(boolean success, boolean fatal, String message, String remediationAdvice) {
        this.success = success;
        this.fatal = fatal;
        this.message = message;
        this.remediationAdvice = remediationAdvice;
    }

    public static CheckResult createSuccess(String message) {
        return new CheckResult(true, false, message, null);
    }

    public static CheckResult createFailure(String message, String remediationAdvice) {
        return new CheckResult(false, false, message, remediationAdvice);
    }

    public static CheckResult createFatalFailure(String message, String remediationAdvice) {
        return new CheckResult(false, true, message, remediationAdvice);
    }

    public String getMessage() {
        return this.message;
    }

    public String getRemediationAdvice() {
        return this.remediationAdvice;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public boolean isFatal() {
        return this.fatal;
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("success", this.success).append("message", (Object)this.message).append("remediationAdvice", (Object)this.remediationAdvice).toString();
    }
}

