/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.tools.checks;

import java.util.List;
import javax.servlet.ServletContext;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.tools.checks.CheckAndResult;
import org.jasig.portal.tools.checks.ICheckRunner;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.web.context.ServletContextAware;

public class InitializingCheckRunner
implements InitializingBean,
ServletContextAware {
    public static final String INIT_CHECK_RESULTS = "INIT_CHECK_RESULTS";
    protected final Log logger = LogFactory.getLog(this.getClass());
    private ServletContext servletContext;
    private ICheckRunner checkRunner;

    public ICheckRunner getCheckRunner() {
        return this.checkRunner;
    }

    @Required
    public void setCheckRunner(ICheckRunner checkRunner) {
        Validate.notNull((Object)checkRunner, (String)"ICheckRunner must not be null");
        this.checkRunner = checkRunner;
    }

    public void afterPropertiesSet() throws Exception {
        List<CheckAndResult> results = this.checkRunner.doChecks();
        if (this.servletContext != null) {
            this.servletContext.setAttribute(INIT_CHECK_RESULTS, results);
        } else {
            this.logger.warn((Object)"No ServletContext is available, the results will not be acessible");
        }
        this.logResults(results);
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    protected void logResults(List<CheckAndResult> results) {
        if (results == null) {
            this.logger.error((Object)"Cannot log null results.");
            return;
        }
        StringBuilder fatalErrorMsg = new StringBuilder();
        for (CheckAndResult checkAndResult : results) {
            try {
                if (checkAndResult.isSuccess()) {
                    this.logger.info((Object)("Check [" + checkAndResult.getCheckDescription() + "] succeeded with message [" + checkAndResult.getResult().getMessage() + "]"));
                } else {
                    String logMessage = "Check [" + checkAndResult.getCheckDescription() + "] failed with message [" + checkAndResult.getResult().getMessage() + "] and remediation advice [" + checkAndResult.getResult().getRemediationAdvice() + "]";
                    if (checkAndResult.isFatal()) {
                        fatalErrorMsg.append(logMessage).append('\n');
                    }
                    this.logger.fatal((Object)logMessage);
                    System.err.println(logMessage);
                }
            }
            catch (Throwable t) {
                this.logger.error((Object)("Error in logging results of check: " + checkAndResult), t);
            }
            if (fatalErrorMsg.length() <= 0) continue;
            throw new BeanInitializationException(fatalErrorMsg.toString());
        }
    }
}

